/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.mvel;

import java.io.Serializable;
import org.flowable.dmn.engine.FlowableDmnExpressionException;
import org.flowable.dmn.engine.impl.mvel.MvelConditionExpressionPreParser;
import org.flowable.dmn.engine.impl.mvel.MvelExecutionContext;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.LiteralExpression;
import org.flowable.dmn.model.OutputClause;
import org.flowable.dmn.model.UnaryTests;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MvelExpressionExecutor {
    private static final Logger logger = LoggerFactory.getLogger(MvelExpressionExecutor.class);

    public static Boolean executeInputExpression(InputClause inputClause, UnaryTests inputEntry, MvelExecutionContext executionContext) {
        Boolean result;
        if (inputClause == null) {
            throw new IllegalArgumentException("input clause is required");
        }
        if (inputClause.getInputExpression() == null) {
            throw new IllegalArgumentException("input expression is required");
        }
        if (inputEntry == null) {
            throw new IllegalArgumentException("input entry is required");
        }
        for (Class<?> variableClass : executionContext.getPropertyHandlers().keySet()) {
            PropertyHandlerFactory.registerPropertyHandler(variableClass, (PropertyHandler)executionContext.getPropertyHandlers().get(variableClass));
        }
        executionContext.checkExecutionContext(inputClause.getInputExpression().getText());
        String parsedExpression = MvelConditionExpressionPreParser.parse(inputEntry.getText(), inputClause.getInputExpression().getText());
        Serializable compiledExpression = MVEL.compileExpression((String)parsedExpression, (ParserContext)executionContext.getParserContext());
        try {
            result = (Boolean)MVEL.executeExpression((Object)compiledExpression, executionContext.getStackVariables(), Boolean.class);
        }
        catch (Exception ex) {
            logger.warn("Error while executing input entry: {}", (Object)parsedExpression, (Object)ex);
            throw new FlowableDmnExpressionException("error while executing input entry", parsedExpression, ex);
        }
        return result;
    }

    public static Object executeOutputExpression(OutputClause outputClause, LiteralExpression outputEntry, MvelExecutionContext executionContext) {
        if (outputClause == null) {
            throw new IllegalArgumentException("output clause is required");
        }
        if (outputEntry == null) {
            throw new IllegalArgumentException("output entry is required");
        }
        Serializable compiledExpression = MVEL.compileExpression((String)outputEntry.getText(), (ParserContext)executionContext.getParserContext());
        Object result = null;
        try {
            result = MVEL.executeExpression((Object)compiledExpression, executionContext.getStackVariables());
        }
        catch (Exception ex) {
            logger.warn("Error while executing output entry: {}", (Object)outputEntry.getText(), (Object)ex);
            throw new FlowableDmnExpressionException("error while executing output entry", outputEntry.getText(), ex);
        }
        return result;
    }
}

