/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.context;

import java.util.Stack;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.cfg.TransactionContext;
import org.flowable.dmn.engine.impl.interceptor.CommandContext;

public class Context {
    protected static ThreadLocal<Stack<CommandContext>> commandContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<DmnEngineConfiguration>> dmnEngineConfigurationStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<TransactionContext>> transactionContextThreadLocal = new ThreadLocal();

    public static CommandContext getCommandContext() {
        Stack stack = Context.getStack(commandContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandContext)((Object)stack.peek());
    }

    public static void setCommandContext(CommandContext commandContext) {
        Context.getStack(commandContextThreadLocal).push((Object)((Object)commandContext));
    }

    public static void removeCommandContext() {
        Context.getStack(commandContextThreadLocal).pop();
    }

    public static DmnEngineConfiguration getDmnEngineConfiguration() {
        Stack stack = Context.getStack(dmnEngineConfigurationStackThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (DmnEngineConfiguration)((Object)stack.peek());
    }

    public static void setDmnEngineConfiguration(DmnEngineConfiguration dmnEngineConfiguration) {
        Context.getStack(dmnEngineConfigurationStackThreadLocal).push((Object)((Object)dmnEngineConfiguration));
    }

    public static void removeDmnEngineConfiguration() {
        Context.getStack(dmnEngineConfigurationStackThreadLocal).pop();
    }

    public static TransactionContext getTransactionContext() {
        Stack stack = Context.getStack(transactionContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (TransactionContext)stack.peek();
    }

    public static void setTransactionContext(TransactionContext transactionContext) {
        Context.getStack(transactionContextThreadLocal).push(transactionContext);
    }

    public static void removeTransactionContext() {
        Context.getStack(transactionContextThreadLocal).pop();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }
}

