/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import org.flowable.dmn.engine.impl.interceptor.Command;
import org.flowable.dmn.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;

public class SetDeploymentCategoryCmd
implements Command<Void> {
    protected String deploymentId;
    protected String category;

    public SetDeploymentCategoryCmd(String deploymentId, String category) {
        this.deploymentId = deploymentId;
        this.category = category;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new FlowableIllegalArgumentException("Deployment id is null");
        }
        DmnDeploymentEntity deployment = (DmnDeploymentEntity)commandContext.getDeploymentEntityManager().findById(this.deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("No deployment found for id = '" + this.deploymentId + "'");
        }
        deployment.setCategory(this.category);
        commandContext.getDeploymentEntityManager().update(deployment);
        return null;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

