/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.flowable.content.api.ContentObject;
import org.flowable.content.api.ContentStorageException;

public class FileSystemContentObject
implements ContentObject {
    protected File file;
    protected InputStream inputStream;
    protected String id;
    protected Long length;

    public FileSystemContentObject(File file, String id) {
        this.file = file;
        this.id = id;
    }

    public FileSystemContentObject(File file, String id, Long length) {
        this(file, id);
        this.length = length;
    }

    public String getId() {
        return this.id;
    }

    public long getContentLength() {
        if (this.length == null) {
            this.length = this.file.length();
        }
        return this.length;
    }

    public InputStream getContent() {
        if (this.inputStream == null) {
            try {
                this.inputStream = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new ContentStorageException("Error while opening file stream", (Throwable)e);
            }
        }
        return this.inputStream;
    }
}

