/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.task;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.rest.service.api.engine.variable.RestVariable;
import org.flowable.cmmn.rest.service.api.runtime.task.TaskBaseResource;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.exception.FlowableContentNotSupportedException;
import org.flowable.task.api.Task;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class TaskVariableBaseResource
extends TaskBaseResource {
    @Autowired
    protected Environment env;
    @Autowired
    protected CmmnRuntimeService runtimeService;
    protected boolean isSerializableVariableAllowed;

    @PostConstruct
    protected void postConstruct() {
        this.isSerializableVariableAllowed = (Boolean)this.env.getProperty("rest.variables.allow.serializable", Boolean.class, (Object)true);
    }

    public RestVariable getVariableFromRequest(String taskId, String variableName, String scope, boolean includeBinary) {
        Task task = this.getTaskFromRequest(taskId);
        boolean variableFound = false;
        Object value = null;
        RestVariable.RestVariableScope variableScope = RestVariable.getScopeFromString(scope);
        if (variableScope == null) {
            if (this.taskService.hasVariableLocal(taskId, variableName)) {
                value = this.taskService.getVariableLocal(taskId, variableName);
                variableScope = RestVariable.RestVariableScope.LOCAL;
                variableFound = true;
            } else if ("cmmn".equals(task.getScopeType()) && task.getScopeId() != null && this.runtimeService.hasVariable(task.getScopeId(), variableName)) {
                value = this.runtimeService.getVariable(task.getScopeId(), variableName);
                variableScope = RestVariable.RestVariableScope.GLOBAL;
                variableFound = true;
            }
        } else if (variableScope == RestVariable.RestVariableScope.GLOBAL) {
            if ("cmmn".equals(task.getScopeType()) && task.getScopeId() != null && this.runtimeService.hasVariable(task.getScopeId(), variableName)) {
                value = this.runtimeService.getVariable(task.getScopeId(), variableName);
                variableFound = true;
            }
        } else if (variableScope == RestVariable.RestVariableScope.LOCAL && this.taskService.hasVariableLocal(taskId, variableName)) {
            value = this.taskService.getVariableLocal(taskId, variableName);
            variableFound = true;
        }
        if (!variableFound) {
            throw new FlowableObjectNotFoundException("Task '" + taskId + "' doesn't have a variable with name: '" + variableName + "'.", VariableInstanceEntity.class);
        }
        return this.restResponseFactory.createRestVariable(variableName, value, variableScope, taskId, 1, includeBinary);
    }

    protected boolean hasVariableOnScope(Task task, String variableName, RestVariable.RestVariableScope scope) {
        boolean variableFound = false;
        if (scope == RestVariable.RestVariableScope.GLOBAL) {
            if ("cmmn".equals(task.getScopeType()) && task.getScopeId() != null && this.runtimeService.hasVariable(task.getScopeId(), variableName)) {
                variableFound = true;
            }
        } else if (scope == RestVariable.RestVariableScope.LOCAL && this.taskService.hasVariableLocal(task.getId(), variableName)) {
            variableFound = true;
        }
        return variableFound;
    }

    protected RestVariable setBinaryVariable(MultipartHttpServletRequest request, Task task, boolean isNew) {
        if (request.getFileMap().size() == 0) {
            throw new FlowableIllegalArgumentException("No file content was found in request body.");
        }
        MultipartFile file = request.getFile((String)request.getFileMap().keySet().iterator().next());
        if (file == null) {
            throw new FlowableIllegalArgumentException("No file content was found in request body.");
        }
        String variableScope = null;
        String variableName = null;
        String variableType = null;
        Map paramMap = request.getParameterMap();
        for (String parameterName : paramMap.keySet()) {
            if (((String[])paramMap.get(parameterName)).length <= 0) continue;
            if ("scope".equalsIgnoreCase(parameterName)) {
                variableScope = ((String[])paramMap.get(parameterName))[0];
                continue;
            }
            if ("name".equalsIgnoreCase(parameterName)) {
                variableName = ((String[])paramMap.get(parameterName))[0];
                continue;
            }
            if (!"type".equalsIgnoreCase(parameterName)) continue;
            variableType = ((String[])paramMap.get(parameterName))[0];
        }
        try {
            if (variableName == null) {
                throw new FlowableIllegalArgumentException("No variable name was found in request body.");
            }
            if (variableType != null) {
                if (!"binary".equals(variableType) && !"serializable".equals(variableType)) {
                    throw new FlowableIllegalArgumentException("Only 'binary' and 'serializable' are supported as variable type.");
                }
            } else {
                variableType = "binary";
            }
            RestVariable.RestVariableScope scope = RestVariable.RestVariableScope.LOCAL;
            if (variableScope != null) {
                scope = RestVariable.getScopeFromString(variableScope);
            }
            if (variableType.equals("binary")) {
                byte[] variableBytes = IOUtils.toByteArray((InputStream)file.getInputStream());
                this.setVariable(task, variableName, variableBytes, scope, isNew);
            } else if (this.isSerializableVariableAllowed) {
                ObjectInputStream stream = new ObjectInputStream(file.getInputStream());
                Object value = stream.readObject();
                this.setVariable(task, variableName, value, scope, isNew);
                stream.close();
            } else {
                throw new FlowableContentNotSupportedException("Serialized objects are not allowed");
            }
            return this.restResponseFactory.createBinaryRestVariable(variableName, scope, variableType, task.getId(), null);
        }
        catch (IOException ioe) {
            throw new FlowableIllegalArgumentException("Error getting binary variable", (Throwable)ioe);
        }
        catch (ClassNotFoundException ioe) {
            throw new FlowableContentNotSupportedException("The provided body contains a serialized object for which the class was not found: " + ioe.getMessage());
        }
    }

    protected RestVariable setSimpleVariable(RestVariable restVariable, Task task, boolean isNew) {
        if (restVariable.getName() == null) {
            throw new FlowableIllegalArgumentException("Variable name is required");
        }
        RestVariable.RestVariableScope scope = restVariable.getVariableScope();
        if (scope == null) {
            scope = RestVariable.RestVariableScope.LOCAL;
        }
        Object actualVariableValue = this.restResponseFactory.getVariableValue(restVariable);
        this.setVariable(task, restVariable.getName(), actualVariableValue, scope, isNew);
        return this.restResponseFactory.createRestVariable(restVariable.getName(), actualVariableValue, scope, task.getId(), 1, false);
    }

    protected void setVariable(Task task, String name, Object value, RestVariable.RestVariableScope scope, boolean isNew) {
        boolean hasVariable = this.hasVariableOnScope(task, name, scope);
        if (isNew && hasVariable) {
            throw new FlowableException("Variable '" + name + "' is already present on task '" + task.getId() + "'.");
        }
        if (!isNew && !hasVariable) {
            throw new FlowableObjectNotFoundException("Task '" + task.getId() + "' doesn't have a variable with name: '" + name + "'.", null);
        }
        if (scope == RestVariable.RestVariableScope.LOCAL) {
            this.taskService.setVariableLocal(task.getId(), name, value);
        } else if ("cmmn".equals(task.getScopeType()) && task.getScopeId() != null) {
            this.runtimeService.setVariable(task.getScopeId(), name, value);
        } else {
            throw new FlowableIllegalArgumentException("Cannot set global variable '" + name + "' on task '" + task.getId() + "', task is not part of process.");
        }
    }
}

