/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.runtime.planitem;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceQuery;
import org.flowable.cmmn.engine.impl.runtime.PlanItemInstanceQueryProperty;
import org.flowable.cmmn.rest.service.api.CmmnRestApiInterceptor;
import org.flowable.cmmn.rest.service.api.CmmnRestResponseFactory;
import org.flowable.cmmn.rest.service.api.engine.variable.QueryVariable;
import org.flowable.cmmn.rest.service.api.engine.variable.RestVariable;
import org.flowable.cmmn.rest.service.api.runtime.planitem.PlanItemInstanceQueryRequest;
import org.flowable.cmmn.rest.service.api.runtime.planitem.PlanItemInstanceResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.common.rest.api.PaginateRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class PlanItemInstanceBaseResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected CmmnRestResponseFactory restResponseFactory;
    @Autowired
    protected CmmnRuntimeService runtimeService;
    @Autowired(required=false)
    protected CmmnRestApiInterceptor restApiInterceptor;

    protected DataResponse<PlanItemInstanceResponse> getQueryResponse(PlanItemInstanceQueryRequest queryRequest, Map<String, String> requestParams, String serverRootUrl) {
        PlanItemInstanceQuery query = this.runtimeService.createPlanItemInstanceQuery();
        if (queryRequest.getId() != null) {
            query.planItemInstanceId(queryRequest.getId());
        }
        if (queryRequest.getCaseInstanceId() != null) {
            query.caseInstanceId(queryRequest.getCaseInstanceId());
        }
        if (queryRequest.getCaseDefinitionId() != null) {
            query.caseDefinitionId(queryRequest.getCaseDefinitionId());
        }
        if (queryRequest.getStageInstanceId() != null) {
            query.stageInstanceId(queryRequest.getStageInstanceId());
        }
        if (queryRequest.getPlanItemDefinitionId() != null) {
            query.planItemDefinitionId(queryRequest.getPlanItemDefinitionId());
        }
        if (queryRequest.getPlanItemDefinitionType() != null) {
            query.planItemDefinitionType(queryRequest.getPlanItemDefinitionType());
        }
        if (queryRequest.getPlanItemDefinitionTypes() != null) {
            query.planItemDefinitionTypes(queryRequest.getPlanItemDefinitionTypes());
        }
        if (queryRequest.getName() != null) {
            query.planItemInstanceName(queryRequest.getName());
        }
        if (queryRequest.getElementId() != null) {
            query.planItemInstanceElementId(queryRequest.getElementId());
        }
        if (queryRequest.getState() != null) {
            query.planItemInstanceState(queryRequest.getState());
        }
        if (queryRequest.getReferenceId() != null) {
            query.planItemInstanceReferenceId(queryRequest.getReferenceId());
        }
        if (queryRequest.getReferenceType() != null) {
            query.planItemInstanceReferenceType(queryRequest.getReferenceType());
        }
        if (queryRequest.getCreatedBefore() != null) {
            query.planItemInstanceCreatedBefore(queryRequest.getCreatedBefore());
        }
        if (queryRequest.getCreatedAfter() != null) {
            query.planItemInstanceCreatedAfter(queryRequest.getCreatedAfter());
        }
        if (queryRequest.getStartUserId() != null) {
            query.planItemInstanceStartUserId(queryRequest.getStartUserId());
        }
        if (queryRequest.getVariables() != null) {
            this.addVariables(query, queryRequest.getVariables(), false);
        }
        if (queryRequest.getCaseInstanceVariables() != null) {
            this.addVariables(query, queryRequest.getCaseInstanceVariables(), true);
        }
        if (queryRequest.getTenantId() != null) {
            query.planItemInstanceTenantId(queryRequest.getTenantId());
        }
        if (Boolean.TRUE.equals(queryRequest.getWithoutTenantId())) {
            query.planItemInstanceWithoutTenantId();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessPlanItemInstanceInfoWithQuery(query, queryRequest);
        }
        return PaginateListUtil.paginateList(requestParams, (PaginateRequest)queryRequest, (Query)query, (String)"createTime", allowedSortProperties, this.restResponseFactory::createPlanItemInstanceResponseList);
    }

    protected void addVariables(PlanItemInstanceQuery planItemInstanceQuery, List<QueryVariable> variables, boolean isCase) {
        block6: for (QueryVariable variable : variables) {
            if (variable.getVariableOperation() == null) {
                throw new FlowableIllegalArgumentException("Variable operation is missing for variable: " + variable.getName());
            }
            if (variable.getValue() == null) {
                throw new FlowableIllegalArgumentException("Variable value is missing for variable: " + variable.getName());
            }
            boolean nameLess = variable.getName() == null;
            Object actualValue = this.restResponseFactory.getVariableValue(variable);
            if (nameLess && variable.getVariableOperation() != QueryVariable.QueryVariableOperation.EQUALS) {
                throw new FlowableIllegalArgumentException("Value-only query (without a variable-name) is only supported when using 'equals' operation.");
            }
            switch (variable.getVariableOperation()) {
                case EQUALS: {
                    if (nameLess) {
                        if (isCase) {
                            planItemInstanceQuery.caseVariableValueEquals(actualValue);
                            continue block6;
                        }
                        planItemInstanceQuery.variableValueEquals(actualValue);
                        continue block6;
                    }
                    if (isCase) {
                        planItemInstanceQuery.caseVariableValueEquals(variable.getName(), actualValue);
                        continue block6;
                    }
                    planItemInstanceQuery.variableValueEquals(variable.getName(), actualValue);
                    continue block6;
                }
                case EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        if (isCase) {
                            planItemInstanceQuery.caseVariableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                            continue block6;
                        }
                        planItemInstanceQuery.variableValueEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block6;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
                case NOT_EQUALS: {
                    if (isCase) {
                        planItemInstanceQuery.caseVariableValueNotEquals(variable.getName(), actualValue);
                        continue block6;
                    }
                    planItemInstanceQuery.variableValueNotEquals(variable.getName(), actualValue);
                    continue block6;
                }
                case NOT_EQUALS_IGNORE_CASE: {
                    if (actualValue instanceof String) {
                        if (isCase) {
                            planItemInstanceQuery.caseVariableValueNotEqualsIgnoreCase(variable.getName(), (String)actualValue);
                            continue block6;
                        }
                        planItemInstanceQuery.variableValueNotEqualsIgnoreCase(variable.getName(), (String)actualValue);
                        continue block6;
                    }
                    throw new FlowableIllegalArgumentException("Only string variable values are supported when ignoring casing, but was: " + actualValue.getClass().getName());
                }
            }
            throw new FlowableIllegalArgumentException("Unsupported variable query operation: " + (Object)((Object)variable.getVariableOperation()));
        }
    }

    protected PlanItemInstance getPlanItemInstanceFromRequest(String planItemInstanceId) {
        PlanItemInstance planItemInstance = (PlanItemInstance)this.runtimeService.createPlanItemInstanceQuery().planItemInstanceId(planItemInstanceId).singleResult();
        if (planItemInstance == null) {
            throw new FlowableObjectNotFoundException("Could not find an plan item instance with id '" + planItemInstance + "'.", PlanItemInstance.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessPlanItemInstanceInfoById(planItemInstance);
        }
        return planItemInstance;
    }

    protected Map<String, Object> getVariablesToSet(List<RestVariable> restVariables) {
        HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
        for (RestVariable var : restVariables) {
            if (var.getName() == null) {
                throw new FlowableIllegalArgumentException("Variable name is required");
            }
            Object actualVariableValue = this.restResponseFactory.getVariableValue(var);
            variablesToSet.put(var.getName(), actualVariableValue);
        }
        return variablesToSet;
    }

    static {
        allowedSortProperties.put("name", (QueryProperty)PlanItemInstanceQueryProperty.NAME);
        allowedSortProperties.put("createTime", (QueryProperty)PlanItemInstanceQueryProperty.CREATE_TIME);
        allowedSortProperties.put("startTime", (QueryProperty)PlanItemInstanceQueryProperty.CREATE_TIME);
    }
}

