/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.rest.service.api.engine.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;

public class RestVariable
extends EngineRestVariable {
    private RestVariableScope variableScope;

    @ApiModelProperty(example="global", value="Scope of the variable.", notes="If local, the variable is explicitly defined on the resource it\u2019s requested from. When global, the variable is defined on the parent (or any parent in the parent-tree) of the resource it\u2019s requested from. When writing a variable and the scope is omitted, global is assumed.")
    @JsonIgnore
    public RestVariableScope getVariableScope() {
        return this.variableScope;
    }

    public void setVariableScope(RestVariableScope variableScope) {
        this.variableScope = variableScope;
    }

    public String getScope() {
        String scope = null;
        if (this.variableScope != null) {
            scope = this.variableScope.name().toLowerCase();
        }
        return scope;
    }

    public void setScope(String scope) {
        this.setVariableScope(RestVariable.getScopeFromString(scope));
    }

    public static RestVariableScope getScopeFromString(String scope) {
        if (scope != null) {
            for (RestVariableScope s : RestVariableScope.values()) {
                if (!s.name().equalsIgnoreCase(scope)) continue;
                return s;
            }
            throw new FlowableIllegalArgumentException("Invalid variable scope: '" + scope + "'");
        }
        return null;
    }

    public static enum RestVariableScope {
        LOCAL,
        GLOBAL;

    }
}

