/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.constants.CmmnStencilConstants;
import org.flowable.cmmn.editor.constants.EditorJsonConstants;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.AssociationJsonConverter;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CaseTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.CriterionJsonConverter;
import org.flowable.cmmn.editor.json.converter.DecisionTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.ExternalWorkerServiceTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.GenericEventListenerJsonConverter;
import org.flowable.cmmn.editor.json.converter.HttpTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.HumanTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.MailTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.MilestoneJsonConverter;
import org.flowable.cmmn.editor.json.converter.ProcessTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.ScriptTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.SendEventTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.ServiceTaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.StageJsonConverter;
import org.flowable.cmmn.editor.json.converter.StandaloneCmmnJsonConverterContext;
import org.flowable.cmmn.editor.json.converter.TaskJsonConverter;
import org.flowable.cmmn.editor.json.converter.TimerEventListenerJsonConverter;
import org.flowable.cmmn.editor.json.converter.UserEventListenerJsonConverter;
import org.flowable.cmmn.editor.json.converter.VariableEventListenerJsonConverter;
import org.flowable.cmmn.editor.json.converter.util.CmmnModelJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.util.CollectionUtils;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnDiEdge;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.HasEntryCriteria;
import org.flowable.cmmn.model.HasExitCriteria;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.SentryOnPart;
import org.flowable.cmmn.model.Stage;
import org.flowable.cmmn.model.TimerEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnJsonConverter
implements EditorJsonConstants,
CmmnStencilConstants,
ActivityProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CmmnJsonConverter.class);
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected static Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap = new HashMap<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>>();
    protected static Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap = new HashMap<String, Class<? extends BaseCmmnJsonConverter>>();
    public static final String MODELER_NAMESPACE = "http://flowable.org/modeler";
    protected static final DateTimeFormatter defaultFormat = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    protected static final DateTimeFormatter entFormat = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private static final List<String> DI_RECTANGLES;
    private static final List<String> DI_CIRCLES;
    private static final List<String> DI_SENTRY;
    protected double lineWidth = 0.05;

    public ObjectNode convertToJson(CmmnModel model) {
        return this.convertToJson(model, new StandaloneCmmnJsonConverterContext());
    }

    public ObjectNode convertToJson(CmmnModel model, CmmnJsonConverterContext converterContext) {
        String planModelFormKey;
        String eventType;
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        double maxX = 0.0;
        double maxY = 0.0;
        for (GraphicInfo flowInfo : model.getLocationMap().values()) {
            if (flowInfo.getX() + flowInfo.getWidth() > maxX) {
                maxX = flowInfo.getX() + flowInfo.getWidth();
            }
            if (!(flowInfo.getY() + flowInfo.getHeight() > maxY)) continue;
            maxY = flowInfo.getY() + flowInfo.getHeight();
        }
        maxX += 50.0;
        maxY += 50.0;
        if (maxX < 1485.0) {
            maxX = 1485.0;
        }
        if (maxY < 700.0) {
            maxY = 700.0;
        }
        modelNode.set("bounds", (JsonNode)CmmnJsonConverterUtil.createBoundsNode(maxX, maxY, 0.0, 0.0));
        ObjectNode stencilNode = this.objectMapper.createObjectNode();
        stencilNode.put("id", "CMMNDiagram");
        modelNode.set("stencil", (JsonNode)stencilNode);
        ObjectNode stencilsetNode = this.objectMapper.createObjectNode();
        stencilsetNode.put("namespace", "http://b3mn.org/stencilset/cmmn1.1#");
        stencilsetNode.put("url", "../editor/stencilsets/cmmn1.1/cmmn1.1.json");
        modelNode.set("stencilset", (JsonNode)stencilsetNode);
        ArrayNode shapesArrayNode = this.objectMapper.createArrayNode();
        Case caseModel = model.getPrimaryCase();
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getId())) {
            propertiesNode.put("case_id", caseModel.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getName())) {
            propertiesNode.put("name", caseModel.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getDocumentation())) {
            propertiesNode.put("documentation", caseModel.getDocumentation());
        }
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getInitiatorVariableName())) {
            propertiesNode.put("case_initiatorvariablename", caseModel.getInitiatorVariableName());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{model.getTargetNamespace()})) {
            propertiesNode.put("case_namespace", model.getTargetNamespace());
        }
        if (StringUtils.isNotEmpty((CharSequence)(eventType = caseModel.getStartEventType()))) {
            propertiesNode.put("eventType", eventType);
            this.setPropertyValue("eventname", this.getExtensionValue("eventName", caseModel), propertiesNode);
            CmmnModelJsonConverterUtil.addEventOutParameters((List)caseModel.getExtensionElements().get("eventOutParameter"), propertiesNode, this.objectMapper);
            CmmnModelJsonConverterUtil.addEventCorrelationParameters((List)caseModel.getExtensionElements().get("eventCorrelationParameter"), propertiesNode, this.objectMapper);
            this.setPropertyValue("channelkey", this.getExtensionValue("channelKey", caseModel), propertiesNode);
            this.setPropertyValue("channelname", this.getExtensionValue("channelName", caseModel), propertiesNode);
            this.setPropertyValue("channeltype", this.getExtensionValue("channelType", caseModel), propertiesNode);
            this.setPropertyValue("channeldestination", this.getExtensionValue("channelDestination", caseModel), propertiesNode);
            String keyDetectionType = this.getExtensionValue("keyDetectionType", caseModel);
            String keyDetectionValue = this.getExtensionValue("keyDetectionValue", caseModel);
            if (StringUtils.isNotEmpty((CharSequence)keyDetectionType) && StringUtils.isNotEmpty((CharSequence)keyDetectionValue)) {
                if ("fixedValue".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionfixedvalue", keyDetectionValue, propertiesNode);
                } else if ("jsonField".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionjsonfield", keyDetectionValue, propertiesNode);
                } else if ("jsonPointer".equalsIgnoreCase(keyDetectionType)) {
                    this.setPropertyValue("keydetectionjsonpointer", keyDetectionValue, propertiesNode);
                }
            }
        }
        modelNode.set("properties", (JsonNode)propertiesNode);
        Stage planModelStage = caseModel.getPlanModel();
        GraphicInfo planModelGraphicInfo = model.getGraphicInfo(planModelStage.getId());
        ObjectNode planModelNode = CmmnJsonConverterUtil.createChildShape(planModelStage.getId(), "CasePlanModel", planModelGraphicInfo.getX() + planModelGraphicInfo.getWidth(), planModelGraphicInfo.getY() + planModelGraphicInfo.getHeight(), planModelGraphicInfo.getX(), planModelGraphicInfo.getY());
        ObjectNode planModelPropertiesNode = this.objectMapper.createObjectNode();
        if (StringUtils.isNotEmpty((CharSequence)planModelStage.getName())) {
            planModelPropertiesNode.put("name", planModelStage.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)planModelStage.getDocumentation())) {
            planModelPropertiesNode.put("documentation", planModelStage.getDocumentation());
        }
        if (planModelStage.isAutoComplete()) {
            planModelPropertiesNode.put("autocompleteenabled", planModelStage.isAutoComplete());
        }
        if (StringUtils.isNotEmpty((CharSequence)planModelStage.getAutoCompleteCondition())) {
            planModelPropertiesNode.put("autocompletecondition", planModelStage.getAutoCompleteCondition());
        }
        if (StringUtils.isNotEmpty((CharSequence)(planModelFormKey = planModelStage.getFormKey()))) {
            Map<String, String> modelInfo = converterContext.getFormModelInfoForFormModelKey(planModelFormKey);
            if (modelInfo != null) {
                ObjectNode formRefNode = this.objectMapper.createObjectNode();
                formRefNode.put("id", modelInfo.get("id"));
                formRefNode.put("name", modelInfo.get("name"));
                formRefNode.put("key", modelInfo.get("key"));
                planModelPropertiesNode.set("formreference", (JsonNode)formRefNode);
            } else {
                this.setPropertyValue("formkeydefinition", planModelFormKey, planModelPropertiesNode);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)planModelStage.getValidateFormFields())) {
            planModelPropertiesNode.put("formfieldvalidation", planModelStage.getValidateFormFields());
        }
        planModelNode.set("properties", (JsonNode)planModelPropertiesNode);
        planModelNode.putArray("outgoing");
        shapesArrayNode.add((JsonNode)planModelNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        for (Criterion criterion : planModelStage.getExitCriteria()) {
            GraphicInfo criterionGraphicInfo = model.getGraphicInfo(criterion.getId());
            ObjectNode criterionNode = CmmnJsonConverterUtil.createChildShape(criterion.getId(), "ExitCriterion", criterionGraphicInfo.getX() + criterionGraphicInfo.getWidth(), criterionGraphicInfo.getY() + criterionGraphicInfo.getHeight(), criterionGraphicInfo.getX(), criterionGraphicInfo.getY());
            shapesArrayNode.add((JsonNode)criterionNode);
            ObjectNode criterionPropertiesNode = this.objectMapper.createObjectNode();
            criterionPropertiesNode.put("overrideid", criterion.getId());
            new CriterionJsonConverter().convertElementToJson(criterionNode, criterionPropertiesNode, this, (BaseElement)criterion, model, converterContext);
            criterionNode.set("properties", (JsonNode)criterionPropertiesNode);
            if (CollectionUtils.isNotEmpty(criterion.getOutgoingAssociations())) {
                ArrayNode criterionOutgoingArrayNode = this.objectMapper.createArrayNode();
                for (Association association : criterion.getOutgoingAssociations()) {
                    criterionOutgoingArrayNode.add((JsonNode)CmmnJsonConverterUtil.createResourceNode(association.getId()));
                }
                criterionNode.set("outgoing", (JsonNode)criterionOutgoingArrayNode);
            }
            outgoingArrayNode.add((JsonNode)CmmnJsonConverterUtil.createResourceNode(criterion.getId()));
        }
        planModelNode.set("outgoing", (JsonNode)outgoingArrayNode);
        ArrayNode planModelShapesArrayNode = this.objectMapper.createArrayNode();
        planModelNode.set("childShapes", (JsonNode)planModelShapesArrayNode);
        this.processPlanItems(caseModel.getPlanModel(), model, planModelShapesArrayNode, converterContext, planModelGraphicInfo.getX(), planModelGraphicInfo.getY());
        for (Association association : model.getAssociations()) {
            AssociationJsonConverter associationJsonConverter = new AssociationJsonConverter();
            associationJsonConverter.convertToJson((BaseElement)association, model, shapesArrayNode);
        }
        modelNode.set("childShapes", (JsonNode)shapesArrayNode);
        return modelNode;
    }

    @Override
    public void processPlanItems(Stage stage, CmmnModel model, ArrayNode shapesArrayNode, CmmnJsonConverterContext converterContext, double subProcessX, double subProcessY) {
        for (PlanItem planItem : stage.getPlanItems()) {
            this.processPlanItem(planItem, stage, model, shapesArrayNode, converterContext, subProcessX, subProcessY);
        }
    }

    protected void processPlanItem(PlanItem planItem, Stage stage, CmmnModel model, ArrayNode shapesArrayNode, CmmnJsonConverterContext converterContext, double containerX, double containerY) {
        PlanItemDefinition planItemDefinition = planItem.getPlanItemDefinition();
        Class<? extends BaseCmmnJsonConverter> converter = convertersToJsonMap.get(planItemDefinition.getClass());
        if (converter != null) {
            try {
                BaseCmmnJsonConverter converterInstance = converter.newInstance();
                converterInstance.convertToJson((BaseElement)planItem, this, model, (PlanFragment)stage, shapesArrayNode, converterContext, containerX, containerY);
            }
            catch (Exception e) {
                LOGGER.error("Error converting {}", (Object)planItemDefinition, (Object)e);
            }
        }
    }

    public CmmnModel convertToCmmnModel(JsonNode modelNode) {
        return this.convertToCmmnModel(modelNode, new StandaloneCmmnJsonConverterContext());
    }

    public CmmnModel convertToCmmnModel(JsonNode modelNode, CmmnJsonConverterContext converterContext) {
        String namespace;
        CmmnModel cmmnModel = new CmmnModel();
        CmmnModelIdHelper cmmnModelIdHelper = new CmmnModelIdHelper();
        cmmnModel.setTargetNamespace("http://flowable.org/cmmn");
        cmmnModel.setExporter("Flowable Open Source Modeler");
        cmmnModel.setExporterVersion(this.getClass().getPackage().getImplementationVersion());
        HashMap<String, JsonNode> shapeMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> sourceRefMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> edgeMap = new HashMap<String, JsonNode>();
        HashMap<String, List<JsonNode>> sourceAndTargetMap = new HashMap<String, List<JsonNode>>();
        this.readShapeInfo(modelNode, shapeMap, sourceRefMap);
        this.filterAllEdges(modelNode, edgeMap, sourceAndTargetMap, shapeMap, sourceRefMap);
        ArrayNode shapesArrayNode = (ArrayNode)modelNode.get("childShapes");
        if (shapesArrayNode == null || shapesArrayNode.size() == 0) {
            return cmmnModel;
        }
        Case caseModel = new Case();
        cmmnModel.getCases().add(caseModel);
        caseModel.setId(CmmnJsonConverterUtil.getPropertyValueAsString("case_id", modelNode));
        caseModel.setName(CmmnJsonConverterUtil.getPropertyValueAsString("name", modelNode));
        caseModel.setInitiatorVariableName(CmmnJsonConverterUtil.getPropertyValueAsString("case_initiatorvariablename", modelNode));
        if (StringUtils.isEmpty((CharSequence)caseModel.getInitiatorVariableName())) {
            caseModel.setInitiatorVariableName("initiator");
        }
        if (StringUtils.isNotEmpty((CharSequence)(namespace = CmmnJsonConverterUtil.getPropertyValueAsString("case_namespace", modelNode)))) {
            cmmnModel.setTargetNamespace(namespace);
        }
        caseModel.setDocumentation(CmmnJsonConverterUtil.getPropertyValueAsString("documentation", modelNode));
        String eventKey = CmmnJsonConverterUtil.getPropertyValueAsString("eventkey", modelNode);
        if (StringUtils.isNotEmpty((CharSequence)eventKey)) {
            caseModel.setStartEventType(eventKey);
            this.addFlowableExtensionElementWithValue("eventName", CmmnJsonConverterUtil.getPropertyValueAsString("eventname", modelNode), caseModel);
            CmmnModelJsonConverterUtil.convertJsonToOutParameters(modelNode, (BaseElement)caseModel);
            CmmnModelJsonConverterUtil.convertJsonToCorrelationParameters(modelNode, "eventCorrelationParameter", (BaseElement)caseModel);
            this.addFlowableExtensionElementWithValue("channelKey", CmmnJsonConverterUtil.getPropertyValueAsString("channelkey", modelNode), caseModel);
            this.addFlowableExtensionElementWithValue("channelName", CmmnJsonConverterUtil.getPropertyValueAsString("channelname", modelNode), caseModel);
            this.addFlowableExtensionElementWithValue("channelType", CmmnJsonConverterUtil.getPropertyValueAsString("channeltype", modelNode), caseModel);
            this.addFlowableExtensionElementWithValue("channelDestination", CmmnJsonConverterUtil.getPropertyValueAsString("channeldestination", modelNode), caseModel);
            String fixedValue = CmmnJsonConverterUtil.getPropertyValueAsString("keydetectionfixedvalue", modelNode);
            String jsonField = CmmnJsonConverterUtil.getPropertyValueAsString("keydetectionjsonfield", modelNode);
            String jsonPointer = CmmnJsonConverterUtil.getPropertyValueAsString("keydetectionjsonpointer", modelNode);
            if (StringUtils.isNotEmpty((CharSequence)fixedValue)) {
                this.addFlowableExtensionElementWithValue("keyDetectionType", "fixedValue", caseModel);
                this.addFlowableExtensionElementWithValue("keyDetectionValue", fixedValue, caseModel);
            } else if (StringUtils.isNotEmpty((CharSequence)jsonField)) {
                this.addFlowableExtensionElementWithValue("keyDetectionType", "jsonField", caseModel);
                this.addFlowableExtensionElementWithValue("keyDetectionValue", jsonField, caseModel);
            } else if (StringUtils.isNotEmpty((CharSequence)jsonPointer)) {
                this.addFlowableExtensionElementWithValue("keyDetectionType", "jsonPointer", caseModel);
                this.addFlowableExtensionElementWithValue("keyDetectionValue", jsonPointer, caseModel);
            }
        }
        JsonNode planModelShape = shapesArrayNode.get(0);
        JsonNode planModelShapesArray = planModelShape.get("childShapes");
        Stage planModelStage = new Stage();
        planModelStage.setId(CmmnJsonConverterUtil.getElementId(planModelShape));
        planModelStage.setName(CmmnJsonConverterUtil.getPropertyValueAsString("name", planModelShape));
        planModelStage.setDocumentation(CmmnJsonConverterUtil.getPropertyValueAsString("documentation", planModelShape));
        planModelStage.setAutoComplete(CmmnJsonConverterUtil.getPropertyValueAsBoolean("autocompleteenabled", planModelShape));
        String autocompleteCondition = CmmnJsonConverterUtil.getPropertyValueAsString("autocompletecondition", planModelShape);
        if (StringUtils.isNotEmpty((CharSequence)autocompleteCondition)) {
            planModelStage.setAutoCompleteCondition(autocompleteCondition);
        }
        planModelStage.setFormKey(CmmnJsonConverterUtil.getPropertyFormKey(planModelShape, converterContext));
        planModelStage.setValidateFormFields(CmmnJsonConverterUtil.getPropertyValueAsString("formfieldvalidation", planModelShape));
        planModelStage.setPlanModel(true);
        caseModel.setPlanModel(planModelStage);
        this.processJsonElements(planModelShapesArray, modelNode, (BaseElement)planModelStage, shapeMap, converterContext, cmmnModel, cmmnModelIdHelper);
        HashSet<String> planModelExitCriteriaRefs = new HashSet<String>();
        for (JsonNode shapeNode : shapesArrayNode) {
            JsonNode resourceNode;
            if ("Association".equalsIgnoreCase(CmmnJsonConverterUtil.getStencilId(shapeNode))) {
                AssociationJsonConverter associationConverter = new AssociationJsonConverter();
                Association association = associationConverter.convertJsonToElement(shapeNode, modelNode, (ActivityProcessor)this, (BaseElement)planModelStage, shapeMap, cmmnModel, converterContext, cmmnModelIdHelper);
                cmmnModel.addAssociation(association);
                continue;
            }
            if (!"ExitCriterion".equalsIgnoreCase(CmmnJsonConverterUtil.getStencilId(shapeNode)) || (resourceNode = shapeNode.get("resourceId")) == null) continue;
            planModelExitCriteriaRefs.add(resourceNode.asText());
            CriterionJsonConverter criterionJsonConverter = new CriterionJsonConverter();
            Criterion exitCriterion = (Criterion)criterionJsonConverter.convertJsonToElement(shapeNode, modelNode, (ActivityProcessor)this, (BaseElement)planModelStage, shapeMap, cmmnModel, converterContext, cmmnModelIdHelper);
            exitCriterion.setAttachedToRefId(planModelStage.getId());
        }
        this.readShapeDI(modelNode, 0.0, 0.0, cmmnModel);
        this.readEdgeDI(edgeMap, sourceAndTargetMap, cmmnModel);
        Map<String, List<Association>> associationMap = this.postProcessAssociations(cmmnModel);
        this.postProcessElements(planModelStage, planModelStage.getPlanItems(), edgeMap, associationMap, cmmnModel, cmmnModelIdHelper);
        this.createSentryParts(planModelExitCriteriaRefs, planModelStage, associationMap, cmmnModel, cmmnModelIdHelper, null, (HasExitCriteria)planModelStage);
        return cmmnModel;
    }

    @Override
    public void processJsonElements(JsonNode shapesArrayNode, JsonNode modelNode, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnJsonConverterContext converterContext, CmmnModel cmmnModel, CmmnModelIdHelper cmmnModelIdHelper) {
        for (JsonNode shapeNode : shapesArrayNode) {
            String stencilId = CmmnJsonConverterUtil.getStencilId(shapeNode);
            Class<? extends BaseCmmnJsonConverter> converter = convertersToCmmnMap.get(stencilId);
            try {
                BaseCmmnJsonConverter converterInstance = converter.newInstance();
                converterInstance.convertToCmmnModel(shapeNode, modelNode, this, parentElement, shapeMap, cmmnModel, converterContext, cmmnModelIdHelper);
            }
            catch (Exception e) {
                LOGGER.error("Error converting {}", (Object)CmmnJsonConverterUtil.getStencilId(shapeNode));
            }
        }
    }

    protected Map<String, List<Association>> postProcessAssociations(CmmnModel cmmnModel) {
        HashMap<String, List<Association>> associationMap = new HashMap<String, List<Association>>();
        for (Association association : cmmnModel.getAssociations()) {
            Stage stage;
            String attachedToRefid;
            PlanItemDefinition planItemDefinition;
            if (association.getSourceRef() == null || association.getTargetRef() == null) continue;
            boolean sourceIsCriterion = true;
            Criterion criterion = cmmnModel.getCriterion(association.getSourceRef());
            if (criterion != null) {
                planItemDefinition = cmmnModel.findPlanItemDefinition(association.getTargetRef());
            } else {
                criterion = cmmnModel.getCriterion(association.getTargetRef());
                if (criterion == null) {
                    this.postProcessAssociationForTextAnnotation(association, cmmnModel);
                    continue;
                }
                sourceIsCriterion = false;
                planItemDefinition = cmmnModel.findPlanItemDefinition(association.getSourceRef());
                if (planItemDefinition == null) {
                    planItemDefinition = cmmnModel.findPlanItemDefinition(association.getTargetRef());
                }
            }
            if (planItemDefinition == null) continue;
            boolean isExitCriterionOnStage = false;
            PlanItemDefinition stageDefinition = null;
            if (criterion.isExitCriterion() && (stageDefinition = cmmnModel.findPlanItemDefinition(attachedToRefid = criterion.getAttachedToRefId())) instanceof Stage && !(stage = (Stage)stageDefinition).isPlanModel()) {
                isExitCriterionOnStage = true;
            }
            if (isExitCriterionOnStage) {
                PlanItem stagePlanItem = cmmnModel.findPlanItem(stageDefinition.getPlanItemRef());
                stagePlanItem.addCriteriaRef(criterion.getId());
            }
            PlanItem planItem = cmmnModel.findPlanItem(planItemDefinition.getPlanItemRef());
            if (sourceIsCriterion) {
                association.setSourceElement((BaseElement)criterion);
                criterion.addOutgoingAssociation(association);
                association.setTargetElement((BaseElement)planItem);
                association.setTargetRef(planItem.getId());
                planItem.addIncomingAssociation(association);
            } else {
                association.setTargetElement((BaseElement)criterion);
                criterion.addIncomingAssociation(association);
                association.setSourceElement((BaseElement)planItem);
                association.setSourceRef(planItem.getId());
                planItem.addOutgoingAssociation(association);
            }
            if (!associationMap.containsKey(criterion.getId())) {
                associationMap.put(criterion.getId(), new ArrayList());
            }
            ((List)associationMap.get(criterion.getId())).add(association);
        }
        return associationMap;
    }

    protected void postProcessAssociationForTextAnnotation(Association association, CmmnModel cmmnModel) {
        PlanItemDefinition sourcePlanItemDefinition = cmmnModel.findPlanItemDefinition(association.getSourceRef());
        PlanItemDefinition targetPlanItemDefinition = cmmnModel.findPlanItemDefinition(association.getTargetRef());
        if (sourcePlanItemDefinition != null && targetPlanItemDefinition != null) {
            PlanItem sourcePlanItem = cmmnModel.findPlanItem(sourcePlanItemDefinition.getPlanItemRef());
            PlanItem targetPlanItem = cmmnModel.findPlanItem(targetPlanItemDefinition.getPlanItemRef());
            association.setSourceElement((BaseElement)sourcePlanItem);
            sourcePlanItem.addOutgoingAssociation(association);
            association.setTargetElement((BaseElement)targetPlanItem);
            targetPlanItem.addIncomingAssociation(association);
        }
    }

    protected void postProcessElements(Stage parentStage, List<PlanItem> planItems, Map<String, JsonNode> edgeMap, Map<String, List<Association>> associationMap, CmmnModel cmmnModel, CmmnModelIdHelper cmmnModelIdHelper) {
        for (PlanItem planItem : planItems) {
            TimerEventListener timerEventListener;
            String startTriggerSourceRef;
            PlanItemDefinition planItemDefinition = planItem.getPlanItemDefinition();
            if (planItemDefinition instanceof Stage) {
                Stage stage = (Stage)planItemDefinition;
                this.postProcessElements(stage, stage.getPlanItems(), edgeMap, associationMap, cmmnModel, cmmnModelIdHelper);
            } else if (planItemDefinition instanceof TimerEventListener && StringUtils.isNotEmpty((CharSequence)(startTriggerSourceRef = (timerEventListener = (TimerEventListener)planItemDefinition).getTimerStartTriggerSourceRef()))) {
                PlanItemDefinition referencedPlanItemDefinition = parentStage.findPlanItemDefinitionInStageOrUpwards(startTriggerSourceRef);
                timerEventListener.setTimerStartTriggerSourceRef(referencedPlanItemDefinition.getPlanItemRef());
            }
            if (!CollectionUtils.isNotEmpty(planItem.getCriteriaRefs())) continue;
            this.createSentryParts(planItem.getCriteriaRefs(), parentStage, associationMap, cmmnModel, cmmnModelIdHelper, (HasEntryCriteria)planItem, (HasExitCriteria)planItem);
        }
    }

    protected void createSentryParts(Set<String> criteriaRefs, Stage parentStage, Map<String, List<Association>> associationMap, CmmnModel cmmnModel, CmmnModelIdHelper cmmnModelIdHelper, HasEntryCriteria hasEntryCriteriaElement, HasExitCriteria hasExitCriteriaElement) {
        for (String criterionRef : criteriaRefs) {
            Criterion criterion;
            String criterionId = cmmnModel.getCriterionId(criterionRef);
            if (criterionId == null || (criterion = cmmnModel.getCriterion(criterionId)) == null) continue;
            PlanItemDefinition planItemDefinition = cmmnModel.findPlanItemDefinition(criterion.getAttachedToRefId());
            if (planItemDefinition != null) {
                criterion.setAttachedToRefId(planItemDefinition.getPlanItemRef());
            }
            parentStage.addSentry(criterion.getSentry());
            boolean associationsFound = associationMap.containsKey(criterion.getId());
            if (!associationsFound && criterion.getSentry() == null) continue;
            if (criterion.isEntryCriterion()) {
                hasEntryCriteriaElement.addEntryCriterion(criterion);
            } else if (criterion.isExitCriterion()) {
                Stage planItemDefinitionStage;
                hasExitCriteriaElement.addExitCriterion(criterion);
                if (planItemDefinition instanceof Stage && !(planItemDefinitionStage = (Stage)planItemDefinition).getExitCriteria().contains(criterion)) {
                    planItemDefinitionStage.addExitCriterion(criterion);
                }
            }
            if (!associationsFound) continue;
            List<Association> associations = associationMap.get(criterion.getId());
            for (Association association : associations) {
                PlanItem criterionPlanItem = null;
                criterionPlanItem = association.getSourceRef().equals(criterion.getId()) ? (PlanItem)association.getTargetElement() : (PlanItem)association.getSourceElement();
                SentryOnPart sentryOnPart = new SentryOnPart();
                sentryOnPart.setId("sentryOnPart" + cmmnModelIdHelper.nextSentryOnPartId());
                sentryOnPart.setSourceRef(criterionPlanItem.getId());
                sentryOnPart.setSource(criterionPlanItem);
                if (StringUtils.isNotEmpty((CharSequence)association.getTransitionEvent())) {
                    sentryOnPart.setStandardEvent(association.getTransitionEvent());
                } else {
                    sentryOnPart.setStandardEvent("complete");
                }
                criterion.getSentry().addSentryOnPart(sentryOnPart);
            }
        }
    }

    protected void setPropertyValue(String name, String value, ObjectNode propertiesNode) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            propertiesNode.put(name, value);
        }
    }

    protected String getExtensionValue(String name, Case caseModel) {
        List extensionElements = (List)caseModel.getExtensionElements().get(name);
        if (extensionElements != null && extensionElements.size() > 0) {
            return ((ExtensionElement)extensionElements.get(0)).getElementText();
        }
        return null;
    }

    protected ExtensionElement addFlowableExtensionElement(String name, Case caseModel) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setName(name);
        extensionElement.setNamespace("http://flowable.org/cmmn");
        extensionElement.setNamespacePrefix("flowable");
        caseModel.addExtensionElement(extensionElement);
        return extensionElement;
    }

    protected ExtensionElement addFlowableExtensionElementWithValue(String name, String value, Case caseModel) {
        ExtensionElement extensionElement = null;
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            extensionElement = this.addFlowableExtensionElement(name, caseModel);
            extensionElement.setElementText(value);
        }
        return extensionElement;
    }

    protected void readShapeInfo(JsonNode objectNode, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                String stencilId = CmmnJsonConverterUtil.getStencilId(jsonChildNode);
                if ("Association".equals(stencilId)) continue;
                String childShapeId = jsonChildNode.get("resourceId").asText();
                shapeMap.put(childShapeId, jsonChildNode);
                ArrayNode outgoingNode = (ArrayNode)jsonChildNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null) continue;
                        sourceRefMap.put(resourceNode.asText(), jsonChildNode);
                    }
                }
                this.readShapeInfo(jsonChildNode, shapeMap, sourceRefMap);
            }
        }
    }

    protected void readShapeDI(JsonNode objectNode, double parentX, double parentY, CmmnModel cmmnModel) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                String stencilId = CmmnJsonConverterUtil.getStencilId(jsonChildNode);
                if ("Association".equals(stencilId)) continue;
                GraphicInfo graphicInfo = new GraphicInfo();
                JsonNode boundsNode = jsonChildNode.get("bounds");
                ObjectNode upperLeftNode = (ObjectNode)boundsNode.get("upperLeft");
                ObjectNode lowerRightNode = (ObjectNode)boundsNode.get("lowerRight");
                graphicInfo.setX(upperLeftNode.get("x").asDouble() + parentX);
                graphicInfo.setY(upperLeftNode.get("y").asDouble() + parentY);
                graphicInfo.setWidth(lowerRightNode.get("x").asDouble() - graphicInfo.getX() + parentX);
                graphicInfo.setHeight(lowerRightNode.get("y").asDouble() - graphicInfo.getY() + parentY);
                String elementId = CmmnJsonConverterUtil.getElementId(jsonChildNode);
                if ("EntryCriterion".equals(stencilId) || "ExitCriterion".equals(stencilId)) {
                    cmmnModel.addGraphicInfo(elementId, graphicInfo);
                } else {
                    PlanItemDefinition planItemDefinition = cmmnModel.findPlanItemDefinition(elementId);
                    if (!(planItemDefinition instanceof Stage) || !((Stage)planItemDefinition).isPlanModel()) {
                        PlanItem planItem = cmmnModel.findPlanItem(planItemDefinition.getPlanItemRef());
                        cmmnModel.addGraphicInfo(planItem.getId(), graphicInfo);
                    } else {
                        cmmnModel.addGraphicInfo(planItemDefinition.getId(), graphicInfo);
                    }
                }
                this.readShapeDI(jsonChildNode, graphicInfo.getX(), graphicInfo.getY(), cmmnModel);
            }
        }
    }

    protected void filterAllEdges(JsonNode objectNode, Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                ObjectNode childNode = (ObjectNode)jsonChildNode;
                String stencilId = CmmnJsonConverterUtil.getStencilId((JsonNode)childNode);
                if ("CasePlanModel".equals(stencilId) || "Stage".equals(stencilId)) {
                    this.filterAllEdges((JsonNode)childNode, edgeMap, sourceAndTargetMap, shapeMap, sourceRefMap);
                    continue;
                }
                if (!"Association".equals(stencilId)) continue;
                String childEdgeId = CmmnJsonConverterUtil.getElementId((JsonNode)childNode);
                JsonNode targetNode = childNode.get("target");
                if (targetNode != null && !targetNode.isNull()) {
                    String targetRefId = targetNode.get("resourceId").asText();
                    ArrayList<JsonNode> sourceAndTargetList = new ArrayList<JsonNode>();
                    sourceAndTargetList.add(sourceRefMap.get(childNode.get("resourceId").asText()));
                    sourceAndTargetList.add(shapeMap.get(targetRefId));
                    sourceAndTargetMap.put(childEdgeId, sourceAndTargetList);
                }
                edgeMap.put(childEdgeId, (JsonNode)childNode);
            }
        }
    }

    protected void readEdgeDI(Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, CmmnModel cmmnModel) {
        for (String edgeId : edgeMap.keySet()) {
            JsonNode edgeNode = edgeMap.get(edgeId);
            List<JsonNode> sourceAndTargetList = sourceAndTargetMap.get(edgeId);
            JsonNode sourceRefNode = null;
            JsonNode targetRefNode = null;
            if (sourceAndTargetList != null && sourceAndTargetList.size() > 1) {
                sourceRefNode = sourceAndTargetList.get(0);
                targetRefNode = sourceAndTargetList.get(1);
            }
            if (sourceRefNode == null) {
                LOGGER.info("Skipping edge {} because source ref is null", (Object)edgeId);
                continue;
            }
            if (targetRefNode == null) {
                LOGGER.info("Skipping edge {} because target ref is null", (Object)edgeId);
                continue;
            }
            JsonNode dockersNode = edgeNode.get("dockers");
            double sourceDockersX = dockersNode.get(0).get("x").asDouble();
            double sourceDockersY = dockersNode.get(0).get("y").asDouble();
            String stencilId = CmmnJsonConverterUtil.getStencilId(sourceRefNode);
            String sourceId = null;
            if ("EntryCriterion".equals(stencilId) || "ExitCriterion".equals(stencilId)) {
                sourceId = CmmnJsonConverterUtil.getElementId(sourceRefNode);
            } else {
                String elementId = CmmnJsonConverterUtil.getElementId(sourceRefNode);
                PlanItemDefinition planItemDefinition = cmmnModel.findPlanItemDefinition(elementId);
                PlanItem planItem = cmmnModel.findPlanItem(planItemDefinition.getPlanItemRef());
                sourceId = planItem.getId();
            }
            GraphicInfo sourceInfo = cmmnModel.getGraphicInfo(sourceId);
            stencilId = CmmnJsonConverterUtil.getStencilId(targetRefNode);
            String targetId = null;
            if ("EntryCriterion".equals(stencilId) || "ExitCriterion".equals(stencilId)) {
                targetId = CmmnJsonConverterUtil.getElementId(targetRefNode);
            } else {
                String elementId = CmmnJsonConverterUtil.getElementId(targetRefNode);
                PlanItemDefinition planItemDefinition = cmmnModel.findPlanItemDefinition(elementId);
                PlanItem planItem = cmmnModel.findPlanItem(planItemDefinition.getPlanItemRef());
                targetId = planItem.getId();
            }
            GraphicInfo targetInfo = cmmnModel.getGraphicInfo(targetId);
            double sourceRefLineX = sourceInfo.getX() + sourceDockersX;
            double sourceRefLineY = sourceInfo.getY() + sourceDockersY;
            double nextPointInLineX = dockersNode.get(1).get("x").asDouble();
            double nextPointInLineY = dockersNode.get(1).get("y").asDouble();
            if (dockersNode.size() == 2) {
                nextPointInLineX += targetInfo.getX();
                nextPointInLineY += targetInfo.getY();
            }
            Line2D.Double firstLine = new Line2D.Double(sourceRefLineX, sourceRefLineY, nextPointInLineX, nextPointInLineY);
            String sourceRefStencilId = CmmnJsonConverterUtil.getStencilId(sourceRefNode);
            String targetRefStencilId = CmmnJsonConverterUtil.getStencilId(targetRefNode);
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            Area source2D = null;
            if (DI_CIRCLES.contains(sourceRefStencilId)) {
                source2D = this.createEllipse(sourceInfo, sourceDockersX, sourceDockersY);
            } else if (DI_RECTANGLES.contains(sourceRefStencilId)) {
                source2D = this.createRectangle(sourceInfo);
            } else if (DI_SENTRY.contains(sourceRefStencilId)) {
                source2D = this.createGateway(sourceInfo);
            }
            if (source2D != null) {
                Collection<Point2D> intersections = this.getIntersections(firstLine, source2D);
                if (intersections != null && intersections.size() > 0) {
                    Point2D intersection = intersections.iterator().next();
                    graphicInfoList.add(this.createGraphicInfo(intersection.getX(), intersection.getY()));
                } else {
                    graphicInfoList.add(this.createGraphicInfo(sourceRefLineX, sourceRefLineY));
                }
            }
            Line2D.Double lastLine = null;
            if (dockersNode.size() > 2) {
                for (int i = 1; i < dockersNode.size() - 1; ++i) {
                    double x = dockersNode.get(i).get("x").asDouble();
                    double y = dockersNode.get(i).get("y").asDouble();
                    graphicInfoList.add(this.createGraphicInfo(x, y));
                }
                double startLastLineX = dockersNode.get(dockersNode.size() - 2).get("x").asDouble();
                double startLastLineY = dockersNode.get(dockersNode.size() - 2).get("y").asDouble();
                double endLastLineX = dockersNode.get(dockersNode.size() - 1).get("x").asDouble();
                double endLastLineY = dockersNode.get(dockersNode.size() - 1).get("y").asDouble();
                lastLine = new Line2D.Double(startLastLineX, startLastLineY, endLastLineX += targetInfo.getX(), endLastLineY += targetInfo.getY());
            } else {
                lastLine = firstLine;
            }
            CmmnDiEdge edgeInfo = new CmmnDiEdge();
            edgeInfo.setCmmnElementRef(sourceId);
            edgeInfo.setTargetCmmnElementRef(targetId);
            edgeInfo.setWaypoints(graphicInfoList);
            GraphicInfo sourceDockerInfo = new GraphicInfo();
            sourceDockerInfo.setX(dockersNode.get(0).get("x").asDouble());
            sourceDockerInfo.setY(dockersNode.get(0).get("y").asDouble());
            edgeInfo.setSourceDockerInfo(sourceDockerInfo);
            GraphicInfo targetDockerInfo = new GraphicInfo();
            targetDockerInfo.setX(dockersNode.get(dockersNode.size() - 1).get("x").asDouble());
            targetDockerInfo.setY(dockersNode.get(dockersNode.size() - 1).get("y").asDouble());
            edgeInfo.setTargetDockerInfo(targetDockerInfo);
            cmmnModel.addEdgeInfo(edgeId, edgeInfo);
            Area target2D = null;
            if (DI_CIRCLES.contains(targetRefStencilId)) {
                double targetDockersX = dockersNode.get(dockersNode.size() - 1).get("x").asDouble();
                double targetDockersY = dockersNode.get(dockersNode.size() - 1).get("y").asDouble();
                target2D = this.createEllipse(targetInfo, targetDockersX, targetDockersY);
            }
            if (DI_RECTANGLES.contains(targetRefStencilId)) {
                target2D = this.createRectangle(targetInfo);
            } else if (DI_SENTRY.contains(targetRefStencilId)) {
                target2D = this.createGateway(targetInfo);
            }
            if (target2D != null) {
                Collection<Point2D> intersections = this.getIntersections(lastLine, target2D);
                if (intersections != null && intersections.size() > 0) {
                    Point2D intersection = intersections.iterator().next();
                    graphicInfoList.add(this.createGraphicInfo(intersection.getX(), intersection.getY()));
                } else {
                    graphicInfoList.add(this.createGraphicInfo(((Line2D)lastLine).getX2(), ((Line2D)lastLine).getY2()));
                }
            }
            cmmnModel.addFlowGraphicInfoList(edgeId, graphicInfoList);
        }
    }

    protected Area createEllipse(GraphicInfo sourceInfo, double halfWidth, double halfHeight) {
        Area outerCircle = new Area(new Ellipse2D.Double(sourceInfo.getX(), sourceInfo.getY(), 2.0 * halfWidth, 2.0 * halfHeight));
        Area innerCircle = new Area(new Ellipse2D.Double(sourceInfo.getX() + this.lineWidth, sourceInfo.getY() + this.lineWidth, 2.0 * (halfWidth - this.lineWidth), 2.0 * (halfHeight - this.lineWidth)));
        outerCircle.subtract(innerCircle);
        return outerCircle;
    }

    protected Collection<Point2D> getIntersections(Line2D line, Area shape) {
        Area intersectionArea = new Area(this.getLineShape(line));
        intersectionArea.intersect(shape);
        if (!intersectionArea.isEmpty()) {
            Rectangle2D bounds2D = intersectionArea.getBounds2D();
            HashSet<Point2D> intersections = new HashSet<Point2D>(2);
            intersections.add(new Point2D.Double(bounds2D.getX(), bounds2D.getY()));
            return intersections;
        }
        return Collections.EMPTY_SET;
    }

    protected Shape getLineShape(Line2D line2D) {
        Path2D.Double line = new Path2D.Double(1, 4);
        ((Path2D)line).moveTo(line2D.getX1(), line2D.getY1());
        ((Path2D)line).lineTo(line2D.getX2(), line2D.getY2());
        ((Path2D)line).lineTo(line2D.getX2() + this.lineWidth, line2D.getY2() + this.lineWidth);
        line.closePath();
        return line;
    }

    protected Area createRectangle(GraphicInfo graphicInfo) {
        Area outerRectangle = new Area(new Rectangle2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight()));
        Area innerRectangle = new Area(new Rectangle2D.Double(graphicInfo.getX() + this.lineWidth, graphicInfo.getY() + this.lineWidth, graphicInfo.getWidth() - 2.0 * this.lineWidth, graphicInfo.getHeight() - 2.0 * this.lineWidth));
        outerRectangle.subtract(innerRectangle);
        return outerRectangle;
    }

    protected Area createGateway(GraphicInfo graphicInfo) {
        Area outerGatewayArea = new Area(this.createGatewayShape(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight()));
        Area innerGatewayArea = new Area(this.createGatewayShape(graphicInfo.getX() + this.lineWidth, graphicInfo.getY() + this.lineWidth, graphicInfo.getWidth() - 2.0 * this.lineWidth, graphicInfo.getHeight() - 2.0 * this.lineWidth));
        outerGatewayArea.subtract(innerGatewayArea);
        return outerGatewayArea;
    }

    private Path2D.Double createGatewayShape(double x, double y, double width, double height) {
        double middleX = x + width / 2.0;
        double middleY = y + height / 2.0;
        Path2D.Double gatewayShape = new Path2D.Double(1, 4);
        gatewayShape.moveTo(x, middleY);
        gatewayShape.lineTo(middleX, y);
        gatewayShape.lineTo(x + width, middleY);
        gatewayShape.lineTo(middleX, y + height);
        gatewayShape.closePath();
        return gatewayShape;
    }

    protected GraphicInfo createGraphicInfo(double x, double y) {
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX(x);
        graphicInfo.setY(y);
        return graphicInfo;
    }

    static {
        AssociationJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        HumanTaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        ServiceTaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        DecisionTaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        HttpTaskJsonConverter.fillTypes(convertersToCmmnMap);
        MailTaskJsonConverter.fillTypes(convertersToCmmnMap);
        SendEventTaskJsonConverter.fillTypes(convertersToCmmnMap);
        ExternalWorkerServiceTaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        CaseTaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        ProcessTaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        GenericEventListenerJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        TimerEventListenerJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        UserEventListenerJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        VariableEventListenerJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        TaskJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        ScriptTaskJsonConverter.fillTypes(convertersToCmmnMap);
        MilestoneJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        CriterionJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        StageJsonConverter.fillTypes(convertersToCmmnMap, convertersToJsonMap);
        DI_RECTANGLES = new ArrayList<String>();
        DI_CIRCLES = new ArrayList<String>();
        DI_SENTRY = new ArrayList<String>();
        DI_CIRCLES.add("TimerEventListener");
        DI_CIRCLES.add("UserEventListener");
        DI_CIRCLES.add("EventListener");
        DI_CIRCLES.add("VariableEventListener");
        DI_RECTANGLES.add("Task");
        DI_RECTANGLES.add("HumanTask");
        DI_RECTANGLES.add("ServiceTask");
        DI_RECTANGLES.add("DecisionTask");
        DI_RECTANGLES.add("HttpTask");
        DI_RECTANGLES.add("MailTask");
        DI_RECTANGLES.add("SendEventTask");
        DI_RECTANGLES.add("ExternalWorkerTask");
        DI_RECTANGLES.add("CaseTask");
        DI_RECTANGLES.add("ProcessTask");
        DI_RECTANGLES.add("ScriptTask");
        DI_RECTANGLES.add("Milestone");
        DI_RECTANGLES.add("Stage");
        DI_SENTRY.add("EntryCriterion");
        DI_SENTRY.add("ExitCriterion");
    }

    public static class CmmnModelIdHelper {
        protected int planItemIndex = 0;
        protected int criterionId = 0;
        protected int sentryIndex = 0;
        protected int sentryOnPartIndex = 0;

        public int nextPlanItemId() {
            ++this.planItemIndex;
            return this.planItemIndex;
        }

        public int nextCriterionId() {
            ++this.criterionId;
            return this.criterionId;
        }

        public int nextSentryId() {
            ++this.sentryIndex;
            return this.sentryIndex;
        }

        public int nextSentryOnPartId() {
            ++this.sentryOnPartIndex;
            return this.sentryOnPartIndex;
        }
    }
}

