/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseChildTaskCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.util.ListenerConverterUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CaseTask;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;

public class CaseTaskJsonConverter
extends BaseChildTaskCmmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        CaseTaskJsonConverter.fillJsonTypes(convertersToCmmnMap);
        CaseTaskJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("CaseTask", CaseTaskJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(CaseTask.class, CaseTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "CaseTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext) {
        String caseRef;
        CaseTask caseTask = (CaseTask)((PlanItem)baseElement).getPlanItemDefinition();
        if (caseTask.getFallbackToDefaultTenant() != null) {
            propertiesNode.put("fallbacktodefaulttenant", caseTask.getFallbackToDefaultTenant());
        }
        propertiesNode.put("samedeployment", caseTask.isSameDeployment());
        if (StringUtils.isNotEmpty((CharSequence)caseTask.getCaseInstanceIdVariableName())) {
            propertiesNode.put("idvariablename", caseTask.getCaseInstanceIdVariableName());
        }
        if (StringUtils.isNotEmpty((CharSequence)(caseRef = caseTask.getCaseRef()))) {
            ObjectNode caseReferenceNode = this.objectMapper.createObjectNode();
            caseReferenceNode.put("key", caseRef);
            propertiesNode.set("casetaskcasereference", (JsonNode)caseReferenceNode);
            Map<String, String> modelInfo = converterContext.getCaseModelInfoForCaseModelKey(caseRef);
            if (modelInfo != null) {
                caseReferenceNode.put("id", modelInfo.get("id"));
                caseReferenceNode.put("name", modelInfo.get("name"));
            } else {
                converterContext.registerUnresolvedCaseModelReferenceForCaseModel(caseRef, cmmnModel);
            }
        }
        ListenerConverterUtil.convertLifecycleListenersToJson(this.objectMapper, propertiesNode, (PlanItemDefinition)caseTask);
        if (caseTask.getInParameters() != null && !caseTask.getInParameters().isEmpty()) {
            ObjectNode inParametersNode = propertiesNode.putObject("casetaskinparameters");
            ArrayNode inParametersArray = inParametersNode.putArray("inParameters");
            this.readIOParameters(caseTask.getInParameters(), inParametersArray);
        }
        if (caseTask.getOutParameters() != null && !caseTask.getOutParameters().isEmpty()) {
            ObjectNode outParametersNode = propertiesNode.putObject("casetaskoutparameters");
            ArrayNode outParametersArray = outParametersNode.putArray("outParameters");
            this.readIOParameters(caseTask.getOutParameters(), outParametersArray);
        }
        if (caseTask.getBusinessKey() != null) {
            propertiesNode.put("casetaskbusinesskey", caseTask.getBusinessKey());
        }
        if (caseTask.isInheritBusinessKey()) {
            propertiesNode.put("casetaskinheritbusinesskey", caseTask.isInheritBusinessKey());
        }
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        JsonNode idVariableName;
        boolean sameDeployment;
        boolean fallbackToDefaultTenant;
        JsonNode caseTaskInheritBusinessKey;
        JsonNode caseTaskBusinessKey;
        JsonNode caseTaskOutParametersNode;
        JsonNode caseTaskInParametersNode;
        CaseTask task = new CaseTask();
        JsonNode caseModelReferenceNode = CmmnJsonConverterUtil.getProperty("casetaskcasereference", elementNode);
        if (caseModelReferenceNode != null && caseModelReferenceNode.has("id") && !caseModelReferenceNode.get("id").isNull()) {
            String caseModelId = caseModelReferenceNode.get("id").asText();
            String caseModelKey = converterContext.getCaseModelKeyForCaseModelId(caseModelId);
            if (StringUtils.isEmpty((CharSequence)caseModelKey) && caseModelReferenceNode.has("key")) {
                caseModelKey = caseModelReferenceNode.get("key").asText();
            }
            task.setCaseRef(caseModelKey);
        }
        if ((caseTaskInParametersNode = CmmnJsonConverterUtil.getProperty("casetaskinparameters", elementNode)) != null && caseTaskInParametersNode.has("inParameters") && !caseTaskInParametersNode.get("inParameters").isNull()) {
            JsonNode inParametersNode = caseTaskInParametersNode.get("inParameters");
            task.setInParameters(this.readIOParameters(inParametersNode));
        }
        if ((caseTaskOutParametersNode = CmmnJsonConverterUtil.getProperty("casetaskoutparameters", elementNode)) != null && caseTaskOutParametersNode.has("outParameters") && !caseTaskOutParametersNode.get("outParameters").isNull()) {
            JsonNode outParametersNode = caseTaskOutParametersNode.get("outParameters");
            task.setOutParameters(this.readIOParameters(outParametersNode));
        }
        if ((caseTaskBusinessKey = CmmnJsonConverterUtil.getProperty("casetaskbusinesskey", elementNode)) != null) {
            task.setBusinessKey(caseTaskBusinessKey.asText());
        }
        if ((caseTaskInheritBusinessKey = CmmnJsonConverterUtil.getProperty("casetaskinheritbusinesskey", elementNode)) != null) {
            task.setInheritBusinessKey(caseTaskInheritBusinessKey.asBoolean());
        }
        if (fallbackToDefaultTenant = CmmnJsonConverterUtil.getPropertyValueAsBoolean("fallbacktodefaulttenant", elementNode, false)) {
            task.setFallbackToDefaultTenant(Boolean.valueOf(true));
        }
        if (sameDeployment = CmmnJsonConverterUtil.getPropertyValueAsBoolean("samedeployment", elementNode, false)) {
            task.setSameDeployment(true);
        }
        if ((idVariableName = CmmnJsonConverterUtil.getProperty("idvariablename", elementNode)) != null && idVariableName.isTextual()) {
            task.setCaseInstanceIdVariableName(idVariableName.asText());
        }
        ListenerConverterUtil.convertJsonToLifeCycleListeners(elementNode, (PlanItemDefinition)task);
        return task;
    }
}

