/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.SentryIfPart;
import org.flowable.cmmn.model.Stage;

public class CriterionJsonConverter
extends BaseCmmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        CriterionJsonConverter.fillJsonTypes(convertersToCmmnMap);
        CriterionJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap) {
        convertersToCmmnMap.put("EntryCriterion", CriterionJsonConverter.class);
        convertersToCmmnMap.put("ExitCriterion", CriterionJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(Criterion.class, CriterionJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        Criterion criterion = (Criterion)baseElement;
        if (criterion.isEntryCriterion()) {
            return "EntryCriterion";
        }
        if (criterion.isExitCriterion()) {
            return "ExitCriterion";
        }
        return "EntryCriterion";
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel) {
        Criterion criterion = (Criterion)baseElement;
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(criterion.getId());
        GraphicInfo parentGraphicInfo = null;
        Stage planModel = cmmnModel.getPrimaryCase().getPlanModel();
        if (criterion.getAttachedToRefId() != null) {
            if (criterion.getAttachedToRefId().equals(planModel.getId())) {
                parentGraphicInfo = cmmnModel.getGraphicInfo(planModel.getId());
            } else {
                PlanItem parentPlanItem = cmmnModel.findPlanItem(criterion.getAttachedToRefId());
                parentGraphicInfo = cmmnModel.getGraphicInfo(parentPlanItem.getId());
            }
            BigDecimal parentX = new BigDecimal(parentGraphicInfo.getX());
            BigDecimal parentY = new BigDecimal(parentGraphicInfo.getY());
            BigDecimal criterionX = new BigDecimal(graphicInfo.getX());
            BigDecimal criterionWidth = new BigDecimal(graphicInfo.getWidth());
            BigDecimal criterionXMid = criterionWidth.divide(new BigDecimal(2));
            BigDecimal criterionY = new BigDecimal(graphicInfo.getY());
            BigDecimal criterionHeight = new BigDecimal(graphicInfo.getHeight());
            BigDecimal criterionYMid = criterionHeight.divide(new BigDecimal(2));
            BigDecimal xBound = criterionX.add(criterionXMid).subtract(parentX).setScale(0, RoundingMode.HALF_UP);
            BigDecimal yBound = criterionY.add(criterionYMid).subtract(parentY).setScale(0, RoundingMode.HALF_UP);
            dockNode.put("x", xBound);
            dockNode.put("y", yBound);
            dockersArrayNode.add((JsonNode)dockNode);
            elementNode.set("dockers", (JsonNode)dockersArrayNode);
            elementNode.set("outgoing", this.getOutgoingArrayNodes(criterion.getId(), cmmnModel));
        } else {
            elementNode.putArray("dockers");
            elementNode.putArray("outgoing");
        }
        this.putProperty(propertiesNode, "name", criterion.getSentry().getName());
        this.putProperty(propertiesNode, "documentation", criterion.getSentry().getDocumentation());
        if (criterion.getSentry() != null && criterion.getSentry().getSentryIfPart() != null) {
            this.putProperty(propertiesNode, "ifpartcondition", criterion.getSentry().getSentryIfPart().getCondition());
        }
        if (criterion.getSentry() != null && criterion.getSentry().getTriggerMode() != null) {
            this.putProperty(propertiesNode, "triggermode", criterion.getSentry().getTriggerMode());
        }
    }

    protected JsonNode getOutgoingArrayNodes(String id, CmmnModel cmmnModel) {
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        for (Association association : cmmnModel.getAssociations()) {
            if (!id.equals(association.getSourceRef())) continue;
            outgoingArrayNode.add((JsonNode)CmmnJsonConverterUtil.createResourceNode(association.getId()));
        }
        return outgoingArrayNode;
    }

    protected void putProperty(ObjectNode propertiesNode, String propertyName, String propertyValue) {
        if (StringUtils.isNotEmpty((CharSequence)propertyValue)) {
            propertiesNode.put(propertyName, propertyValue);
        }
    }

    protected CaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        Criterion criterion = new Criterion();
        String id = CmmnJsonConverterUtil.getElementId(elementNode);
        if (StringUtils.isBlank((CharSequence)id)) {
            id = "criterion_" + cmmnModelIdHelper.nextCriterionId();
        }
        criterion.setId(id);
        criterion.setTechnicalId(CmmnJsonConverterUtil.getShapeId(elementNode));
        String stencilId = CmmnJsonConverterUtil.getStencilId(elementNode);
        if ("EntryCriterion".equals(stencilId)) {
            criterion.setEntryCriterion(true);
        } else if ("ExitCriterion".equals(stencilId)) {
            criterion.setExitCriterion(true);
        }
        String attachedRefId = this.lookForAttachedRef(elementNode.get("resourceId").asText(), elementNode, modelNode.get("childShapes"));
        if (attachedRefId == null && criterion.isExitCriterion() && parentElement instanceof Stage) {
            Stage parentStage = (Stage)parentElement;
            if (!parentStage.isPlanModel()) {
                criterion.setAttachedToRefId(parentStage.getId());
            }
        } else {
            criterion.setAttachedToRefId(attachedRefId);
        }
        if (criterion.getAttachedToRefId() != null) {
            String criterionId = CmmnJsonConverterUtil.getElementId(elementNode);
            cmmnModel.addCriterion(criterionId, criterion);
            cmmnModel.addCriterionTechnicalId(criterion.getTechnicalId(), criterionId);
        }
        this.createSentry(elementNode, criterion, cmmnModelIdHelper);
        return criterion;
    }

    protected void createSentry(JsonNode elementNode, Criterion criterion, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        Sentry sentry = new Sentry();
        sentry.setId("sentry" + cmmnModelIdHelper.nextSentryId());
        sentry.setName(CmmnJsonConverterUtil.getPropertyValueAsString("name", elementNode));
        sentry.setDocumentation(CmmnJsonConverterUtil.getPropertyValueAsString("documentation", elementNode));
        sentry.setTriggerMode(CmmnJsonConverterUtil.getPropertyValueAsString("triggermode", elementNode));
        String ifPartCondition = CmmnJsonConverterUtil.getPropertyValueAsString("ifpartcondition", elementNode);
        if (StringUtils.isNotBlank((CharSequence)ifPartCondition)) {
            SentryIfPart sentryIfPart = new SentryIfPart();
            sentryIfPart.setCondition(ifPartCondition);
            sentry.setSentryIfPart(sentryIfPart);
        }
        criterion.setSentryRef(sentry.getId());
        criterion.setSentry(sentry);
    }

    protected String lookForAttachedRef(String criterionId, JsonNode elementNode, JsonNode childShapesNode) {
        String attachedRefId = null;
        if (childShapesNode != null) {
            for (JsonNode childNode : childShapesNode) {
                ArrayNode outgoingNode = (ArrayNode)childNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null || !criterionId.equals(resourceNode.asText())) continue;
                        attachedRefId = CmmnJsonConverterUtil.getElementId(childNode);
                        break;
                    }
                    if (attachedRefId != null) break;
                }
                if ((attachedRefId = this.lookForAttachedRef(criterionId, null, childNode.get("childShapes"))) == null) continue;
                break;
            }
        }
        return attachedRefId;
    }
}

