/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.flowable.cmmn.api.runtime.PlanItemDefinitionType;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceContainer;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.CompletionEvaluationResult;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.model.ParentCompletionRule;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class PlanItemInstanceContainerUtil {
    public static CompletionEvaluationResult shouldPlanItemContainerComplete(PlanItemInstanceContainer planItemInstanceContainer, boolean containerIsAutocomplete) {
        return PlanItemInstanceContainerUtil.shouldPlanItemContainerComplete(CommandContextUtil.getCommandContext(), planItemInstanceContainer, containerIsAutocomplete);
    }

    public static CompletionEvaluationResult shouldPlanItemContainerComplete(CommandContext commandContext, PlanItemInstanceContainer planItemInstanceContainer, boolean containerIsAutocomplete) {
        return PlanItemInstanceContainerUtil.shouldPlanItemContainerComplete(commandContext, planItemInstanceContainer, null, containerIsAutocomplete);
    }

    public static CompletionEvaluationResult shouldPlanItemContainerComplete(PlanItemInstanceContainer planItemInstanceContainer, Collection<String> planItemInstanceIdsToIgnore, boolean containerIsAutocomplete) {
        return PlanItemInstanceContainerUtil.shouldPlanItemContainerComplete(CommandContextUtil.getCommandContext(), planItemInstanceContainer, planItemInstanceIdsToIgnore, containerIsAutocomplete);
    }

    public static CompletionEvaluationResult shouldPlanItemContainerComplete(CommandContext commandContext, PlanItemInstanceContainer planItemInstanceContainer, Collection<String> planItemInstanceIdsToIgnore, boolean containerIsAutocomplete) {
        boolean shouldBeCompleted = true;
        if (planItemInstanceContainer.getChildPlanItemInstances() != null) {
            for (PlanItemInstanceEntity planItemInstance : planItemInstanceContainer.getChildPlanItemInstances()) {
                if (planItemInstanceIdsToIgnore != null && planItemInstanceIdsToIgnore.contains(planItemInstance.getId())) continue;
                Boolean alreadyCompleted = null;
                if (PlanItemInstanceState.END_STATES.contains(planItemInstance.getState()) || PlanItemInstanceContainerUtil.isParentCompletionRuleForPlanItemEqualToType(planItemInstance, "ignore")) continue;
                if (PlanItemInstanceState.ACTIVE_STATES.contains(planItemInstance.getState())) {
                    alreadyCompleted = PlanItemInstanceContainerUtil.isPlanItemAlreadyCompleted(commandContext, planItemInstance);
                    if (PlanItemInstanceContainerUtil.shouldIgnorePlanItemForCompletion(commandContext, planItemInstance, alreadyCompleted)) continue;
                    return new CompletionEvaluationResult(false, false, planItemInstance);
                }
                if (ExpressionUtil.isRequiredPlanItemInstance(commandContext, planItemInstance)) {
                    if (ExpressionUtil.evaluateRepetitionRule(commandContext, planItemInstance, (PlanItemInstanceContainer)null)) {
                        alreadyCompleted = PlanItemInstanceContainerUtil.isPlanItemAlreadyCompleted(commandContext, planItemInstance);
                        if (PlanItemInstanceContainerUtil.shouldIgnorePlanItemForCompletion(commandContext, planItemInstance, alreadyCompleted)) continue;
                        if (!alreadyCompleted.booleanValue()) {
                            return new CompletionEvaluationResult(false, false, planItemInstance);
                        }
                        shouldBeCompleted = shouldBeCompleted && containerIsAutocomplete;
                    } else {
                        return new CompletionEvaluationResult(false, false, planItemInstance);
                    }
                }
                if (PlanItemInstanceContainerUtil.isParentCompletionRuleForPlanItemEqualToType(planItemInstance, "ignoreIfAvailableOrEnabled") && ("enabled".equals(planItemInstance.getState()) || "available".equals(planItemInstance.getState())) || (PlanItemInstanceContainerUtil.isParentCompletionRuleForPlanItemEqualToType(planItemInstance, "ignoreIfAvailable") || ExpressionUtil.isCompletionNeutralPlanItemInstance(commandContext, planItemInstance)) && "available".equals(planItemInstance.getState())) continue;
                if (ExpressionUtil.evaluateRepetitionRule(commandContext, planItemInstance, (PlanItemInstanceContainer)null)) {
                    if (alreadyCompleted == null) {
                        alreadyCompleted = PlanItemInstanceContainerUtil.isPlanItemAlreadyCompleted(commandContext, planItemInstance);
                    }
                    if (PlanItemInstanceContainerUtil.shouldIgnorePlanItemForCompletion(commandContext, planItemInstance, alreadyCompleted)) continue;
                }
                if ("available".equals(planItemInstance.getState()) || "enabled".equals(planItemInstance.getState())) {
                    boolean bl = shouldBeCompleted = shouldBeCompleted && containerIsAutocomplete;
                }
                if (planItemInstance.getChildPlanItemInstances() == null) continue;
                boolean childContainerIsAutocomplete = false;
                if (PlanItemDefinitionType.STAGE.equals(planItemInstance.getPlanItemDefinitionType())) {
                    Stage stage = (Stage)planItemInstance.getPlanItem().getPlanItemDefinition();
                    childContainerIsAutocomplete = ExpressionUtil.evaluateAutoComplete(commandContext, (VariableContainer)planItemInstance, stage);
                }
                CompletionEvaluationResult childPlanItemInstanceCompletionEvaluationResult = PlanItemInstanceContainerUtil.shouldPlanItemContainerComplete(commandContext, planItemInstance, null, childContainerIsAutocomplete);
                if (!childPlanItemInstanceCompletionEvaluationResult.isCompletable) {
                    return childPlanItemInstanceCompletionEvaluationResult;
                }
                shouldBeCompleted = shouldBeCompleted && childPlanItemInstanceCompletionEvaluationResult.shouldBeCompleted;
            }
        }
        return new CompletionEvaluationResult(true, shouldBeCompleted, null);
    }

    public static boolean shouldIgnorePlanItemForCompletion(CommandContext commandContext, PlanItemInstanceEntity planItemInstance, boolean alreadyCompleted) {
        if (PlanItemInstanceContainerUtil.isParentCompletionRuleForPlanItemEqualToType(planItemInstance, "ignoreAfterFirstCompletion")) {
            return alreadyCompleted;
        }
        if (PlanItemInstanceContainerUtil.isParentCompletionRuleForPlanItemEqualToType(planItemInstance, "ignoreAfterFirstCompletionIfAvailableOrEnabled") && ("available".equals(planItemInstance.getState()) || "enabled".equals(planItemInstance.getState()))) {
            return alreadyCompleted;
        }
        return false;
    }

    public static boolean isPlanItemAlreadyCompleted(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        List<PlanItemInstanceEntity> planItemInstances = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findByCaseInstanceIdAndPlanItemId(planItemInstance.getCaseInstanceId(), planItemInstance.getPlanItem().getId());
        if (planItemInstances != null && planItemInstances.size() > 0) {
            for (PlanItemInstanceEntity item : planItemInstances) {
                if (!Objects.equals(planItemInstance.getStageInstanceId(), item.getStageInstanceId()) || !"completed".equals(item.getState())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isParentCompletionRuleForPlanItemEqualToType(PlanItemInstanceEntity planItemInstance, String parentCompletionRuleType) {
        ParentCompletionRule parentCompletionRule;
        if (planItemInstance.getPlanItem() == null) {
            throw new FlowableException("Plan item could not be found for " + planItemInstance);
        }
        return planItemInstance.getPlanItem().getItemControl() != null && planItemInstance.getPlanItem().getItemControl().getParentCompletionRule() != null && parentCompletionRuleType.equals((parentCompletionRule = planItemInstance.getPlanItem().getItemControl().getParentCompletionRule()).getType());
    }
}

