/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.engine.impl.persistence.entity.AbstractCmmnEngineNoRevisionEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnResourceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.deploy.CaseDefinitionCacheEntry;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.repository.EngineResource;

public class CmmnDeploymentEntityImpl
extends AbstractCmmnEngineNoRevisionEntity
implements CmmnDeploymentEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String category;
    protected String key;
    protected String tenantId = "";
    protected String parentDeploymentId;
    protected Map<String, EngineResource> resources;
    protected Date deploymentTime;
    protected boolean isNew;
    protected Map<Class<?>, List<Object>> deployedArtifacts;
    protected Map<String, CaseDefinitionCacheEntry> caseDefinitionCache = new HashMap<String, CaseDefinitionCacheEntry>();

    @Override
    public void addResource(CmmnResourceEntity resource) {
        if (this.resources == null) {
            this.resources = new HashMap<String, EngineResource>();
        }
        this.resources.put(resource.getName(), resource);
    }

    public Map<String, EngineResource> getResources() {
        if (this.resources == null && this.id != null) {
            List<CmmnResourceEntity> resourcesList = CommandContextUtil.getCmmnResourceEntityManager().findResourcesByDeploymentId(this.id);
            this.resources = new HashMap<String, EngineResource>();
            for (CmmnResourceEntity resource : resourcesList) {
                this.resources.put(resource.getName(), resource);
            }
        }
        return this.resources;
    }

    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("category", this.category);
        persistentState.put("tenantId", this.tenantId);
        persistentState.put("parentDeploymentId", this.parentDeploymentId);
        return persistentState;
    }

    @Override
    public void addDeployedArtifact(Object deployedArtifact) {
        Class<?> clazz;
        List<Object> artifacts;
        if (this.deployedArtifacts == null) {
            this.deployedArtifacts = new HashMap();
        }
        if ((artifacts = this.deployedArtifacts.get(clazz = deployedArtifact.getClass())) == null) {
            artifacts = new ArrayList<Object>();
            this.deployedArtifacts.put(clazz, artifacts);
        }
        artifacts.add(deployedArtifact);
    }

    @Override
    public <T> List<T> getDeployedArtifacts(Class<T> clazz) {
        for (Class<?> deployedArtifactsClass : this.deployedArtifacts.keySet()) {
            if (!clazz.isAssignableFrom(deployedArtifactsClass)) continue;
            return this.deployedArtifacts.get(deployedArtifactsClass);
        }
        return null;
    }

    @Override
    public void addCaseDefinitionCacheEntry(String caseDefinitionId, CaseDefinitionCacheEntry caseDefinitionCacheEntry) {
        this.caseDefinitionCache.put(caseDefinitionId, caseDefinitionCacheEntry);
    }

    @Override
    public CaseDefinitionCacheEntry getCaseDefinitionCacheEntry(String caseDefinitionId) {
        return this.caseDefinitionCache.get(caseDefinitionId);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getParentDeploymentId() {
        return this.parentDeploymentId;
    }

    @Override
    public void setParentDeploymentId(String parentDeploymentId) {
        this.parentDeploymentId = parentDeploymentId;
    }

    @Override
    public void setResources(Map<String, EngineResource> resources) {
        this.resources = resources;
    }

    public Date getDeploymentTime() {
        return this.deploymentTime;
    }

    @Override
    public void setDeploymentTime(Date deploymentTime) {
        this.deploymentTime = deploymentTime;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public String getDerivedFrom() {
        return null;
    }

    public String getDerivedFromRoot() {
        return null;
    }

    public String getEngineVersion() {
        return null;
    }

    public String toString() {
        return "CmmnDeploymentEntity[id=" + this.id + ", name=" + this.name + "]";
    }
}

