/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.deployer;

import java.util.List;
import java.util.Map;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CmmnDeploymentEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.deploy.CaseDefinitionCacheEntry;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionQueryImpl;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.repository.EngineDeployment;
import org.flowable.common.engine.impl.EngineDeployer;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;

public class CmmnDeploymentManager {
    protected DeploymentCache<CaseDefinitionCacheEntry> caseDefinitionCache;
    protected List<EngineDeployer> deployers;
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected CmmnDeploymentEntityManager deploymentEntityManager;
    protected CaseDefinitionEntityManager caseDefinitionEntityManager;

    public void deploy(EngineDeployment deployment) {
        this.deploy(deployment, null);
    }

    public void deploy(EngineDeployment deployment, Map<String, Object> deploymentSettings) {
        for (EngineDeployer deployer : this.deployers) {
            deployer.deploy(deployment, deploymentSettings);
        }
    }

    public CaseDefinition findDeployedCaseDefinitionById(String caseDefinitionId) {
        CaseDefinition caseDefinition;
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Invalid case definition id : null");
        }
        CaseDefinitionCacheEntry cacheEntry = (CaseDefinitionCacheEntry)this.caseDefinitionCache.get(caseDefinitionId);
        CaseDefinition caseDefinition2 = caseDefinition = cacheEntry != null ? cacheEntry.getCaseDefinition() : null;
        if (caseDefinition == null) {
            caseDefinition = (CaseDefinition)this.caseDefinitionEntityManager.findById(caseDefinitionId);
            if (caseDefinition == null) {
                throw new FlowableObjectNotFoundException("no deployed case definition found with id '" + caseDefinitionId + "'", CaseDefinition.class);
            }
            caseDefinition = this.resolveCaseDefinition(caseDefinition).getCaseDefinition();
        }
        return caseDefinition;
    }

    public CaseDefinition findDeployedLatestCaseDefinitionByKey(String caseDefinitionKey) {
        CaseDefinitionEntity caseDefinition = this.caseDefinitionEntityManager.findLatestCaseDefinitionByKey(caseDefinitionKey);
        if (caseDefinition == null) {
            throw new FlowableObjectNotFoundException("no case definition deployed with key '" + caseDefinitionKey + "'", CaseDefinition.class);
        }
        caseDefinition = this.resolveCaseDefinition(caseDefinition).getCaseDefinition();
        return caseDefinition;
    }

    public CaseDefinition findDeployedLatestCaseDefinitionByKeyAndTenantId(String caseDefinitionKey, String tenantId) {
        CaseDefinitionEntity caseDefinition = this.caseDefinitionEntityManager.findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId);
        if (caseDefinition == null) {
            throw new FlowableObjectNotFoundException("no case definition deployed with key '" + caseDefinitionKey + "' for tenant identifier '" + tenantId + "'", CaseDefinition.class);
        }
        caseDefinition = this.resolveCaseDefinition(caseDefinition).getCaseDefinition();
        return caseDefinition;
    }

    public CaseDefinition findDeployedCaseDefinitionByKeyAndVersionAndTenantId(String caseDefinitionKey, Integer caseDefinitionVersion, String tenantId) {
        CaseDefinitionEntity caseDefinition = (CaseDefinitionEntity)this.caseDefinitionEntityManager.findCaseDefinitionByKeyAndVersionAndTenantId(caseDefinitionKey, caseDefinitionVersion, tenantId);
        if (caseDefinition == null) {
            throw new FlowableObjectNotFoundException("no case definition deployed with key = '" + caseDefinitionKey + "' and version = '" + caseDefinitionVersion + "'", CaseDefinition.class);
        }
        caseDefinition = this.resolveCaseDefinition(caseDefinition).getCaseDefinition();
        return caseDefinition;
    }

    public CaseDefinitionCacheEntry resolveCaseDefinition(CaseDefinition caseDefinition) {
        String caseDefinitionId = caseDefinition.getId();
        String deploymentId = caseDefinition.getDeploymentId();
        CaseDefinitionCacheEntry cachedCaseDefinition = (CaseDefinitionCacheEntry)this.caseDefinitionCache.get(caseDefinitionId);
        if (cachedCaseDefinition == null) {
            CmmnDeploymentEntity deployment = (CmmnDeploymentEntity)this.deploymentEntityManager.findById(deploymentId);
            deployment.setNew(false);
            this.deploy((EngineDeployment)deployment, null);
            cachedCaseDefinition = deployment.getCaseDefinitionCacheEntry(caseDefinitionId);
            if (cachedCaseDefinition == null) {
                throw new FlowableException("deployment '" + deploymentId + "' didn't put case definition '" + caseDefinitionId + "' in the cache");
            }
        }
        return cachedCaseDefinition;
    }

    public void removeDeployment(String deploymentId) {
        this.removeDeployment(deploymentId, true);
    }

    public void removeDeployment(String deploymentId, boolean cascade) {
        CmmnDeploymentEntity deployment = (CmmnDeploymentEntity)this.deploymentEntityManager.findById(deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", CmmnDeploymentEntity.class);
        }
        this.deploymentEntityManager.deleteDeploymentAndRelatedData(deploymentId, cascade);
        for (CaseDefinition caseDefinition : new CaseDefinitionQueryImpl().deploymentId(deploymentId).list()) {
            this.caseDefinitionCache.remove(caseDefinition.getId());
        }
    }

    public List<EngineDeployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<EngineDeployer> deployers) {
        this.deployers = deployers;
    }

    public DeploymentCache<CaseDefinitionCacheEntry> getCaseDefinitionCache() {
        return this.caseDefinitionCache;
    }

    public void setCaseDefinitionCache(DeploymentCache<CaseDefinitionCacheEntry> caseDefinitionCache) {
        this.caseDefinitionCache = caseDefinitionCache;
    }

    public CmmnEngineConfiguration getCaseEngineConfiguration() {
        return this.cmmnEngineConfiguration;
    }

    public void setCmmnEngineConfiguration(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public CaseDefinitionEntityManager getCaseDefinitionEntityManager() {
        return this.caseDefinitionEntityManager;
    }

    public void setCaseDefinitionEntityManager(CaseDefinitionEntityManager caseDefinitionEntityManager) {
        this.caseDefinitionEntityManager = caseDefinitionEntityManager;
    }

    public CmmnDeploymentEntityManager getDeploymentEntityManager() {
        return this.deploymentEntityManager;
    }

    public void setDeploymentEntityManager(CmmnDeploymentEntityManager deploymentEntityManager) {
        this.deploymentEntityManager = deploymentEntityManager;
    }
}

