/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.IdentityLinkUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class AbstractCaseInstanceIdentityLinkCmd {
    protected CaseInstanceEntity getCaseInstanceEntity(CommandContext commandContext, String caseInstanceId) {
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(commandContext).findById(caseInstanceId);
        if (caseInstanceEntity == null) {
            throw new FlowableIllegalArgumentException("The case instance with id '" + caseInstanceId + "' could not be found as an active case instance.");
        }
        return caseInstanceEntity;
    }

    protected void removeIdentityLinkType(CommandContext commandContext, String caseInstanceId, String identityType) {
        CaseInstanceEntity caseInstanceEntity = this.getCaseInstanceEntity(commandContext, caseInstanceId);
        IdentityLinkUtil.deleteCaseInstanceIdentityLinks(caseInstanceEntity, null, null, identityType, CommandContextUtil.getCmmnEngineConfiguration(commandContext));
    }

    protected void createIdentityLinkType(CommandContext commandContext, String caseInstanceId, String userId, String groupId, String identityType) {
        if (userId == null && groupId == null) {
            return;
        }
        if (userId != null && groupId != null) {
            throw new FlowableIllegalArgumentException("Either set the user id or the group id for an identity link, but not both the same time.");
        }
        CaseInstanceEntity caseInstanceEntity = this.getCaseInstanceEntity(commandContext, caseInstanceId);
        IdentityLinkUtil.createCaseInstanceIdentityLink(caseInstanceEntity, userId, groupId, identityType, CommandContextUtil.getCmmnEngineConfiguration(commandContext));
    }
}

