/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class SetCaseInstanceNameCmd
implements Command<Void> {
    protected String caseInstanceId;
    protected String caseName;

    public SetCaseInstanceNameCmd(String caseInstanceId, String caseName) {
        this.caseInstanceId = caseInstanceId;
        this.caseName = caseName;
    }

    public Void execute(CommandContext commandContext) {
        if (this.caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("You need to provide the case instance id in order to set its name");
        }
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(commandContext).findById(this.caseInstanceId);
        if (caseInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No case instance found for id " + this.caseInstanceId, CaseInstanceEntity.class);
        }
        caseInstanceEntity.setName(this.caseName);
        CommandContextUtil.getCmmnHistoryManager().recordUpdateCaseInstanceName(caseInstanceEntity, this.caseName);
        return null;
    }
}

