/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.event.FlowableCmmnEventBuilder;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.task.api.Task;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class CompleteTaskCmd
implements Command<Void> {
    protected String taskId;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;

    public CompleteTaskCmd(String taskId, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this.taskId = taskId;
        this.variables = variables;
        this.transientVariables = transientVariables;
    }

    public Void execute(CommandContext commandContext) {
        FlowableEventDispatcher eventDispatcher;
        if (this.taskId == null) {
            throw new FlowableIllegalArgumentException("Null task id");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        TaskEntity taskEntity = cmmnEngineConfiguration.getTaskServiceConfiguration().getTaskService().getTask(this.taskId);
        if (taskEntity == null) {
            throw new FlowableObjectNotFoundException("Could not find task entity for id " + this.taskId, TaskEntity.class);
        }
        if (StringUtils.isNotEmpty((CharSequence)taskEntity.getProcessInstanceId())) {
            throw new FlowableException("The task instance is created by the process engine and should be completed via the process engine API");
        }
        String planItemInstanceId = taskEntity.getSubScopeId();
        PlanItemInstanceEntity planItemInstanceEntity = null;
        if (planItemInstanceId != null && (planItemInstanceEntity = (PlanItemInstanceEntity)cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(planItemInstanceId)) == null) {
            throw new FlowableException("Could not find plan item instance for task " + this.taskId);
        }
        if (this.variables != null) {
            taskEntity.setVariables(this.variables);
        }
        if (this.transientVariables != null) {
            taskEntity.setTransientVariables(this.transientVariables);
        }
        TaskHelper.logUserTaskCompleted(taskEntity, cmmnEngineConfiguration);
        if (cmmnEngineConfiguration.getIdentityLinkInterceptor() != null) {
            cmmnEngineConfiguration.getIdentityLinkInterceptor().handleCompleteTask(taskEntity);
        }
        if ((eventDispatcher = cmmnEngineConfiguration.getEventDispatcher()) != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableCmmnEventBuilder.createTaskCompletedEvent((Task)taskEntity), cmmnEngineConfiguration.getEngineCfgKey());
        }
        cmmnEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(taskEntity, "complete");
        if (planItemInstanceEntity != null) {
            if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
                String taskLabel = null;
                taskLabel = StringUtils.isNotEmpty((CharSequence)taskEntity.getName()) ? taskEntity.getName() : taskEntity.getId();
                CmmnLoggingSessionUtil.addLoggingData("humanTaskComplete", "Human task '" + taskLabel + "' completed", taskEntity, planItemInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
            }
            CommandContextUtil.getAgenda(commandContext).planTriggerPlanItemInstanceOperation(planItemInstanceEntity);
        } else {
            TaskHelper.deleteTask(taskEntity, null, false, true, cmmnEngineConfiguration);
        }
        return null;
    }
}

