/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.engine.impl.persistence.entity.AbstractCmmnEngineVariableScopeEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInitializingList;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableScopeImpl;

public class CaseInstanceEntityImpl
extends AbstractCmmnEngineVariableScopeEntity
implements CaseInstanceEntity {
    protected String businessKey;
    protected String name;
    protected String parentId;
    protected String caseDefinitionId;
    protected String state;
    protected Date startTime;
    protected String startUserId;
    protected String callbackId;
    protected String callbackType;
    protected String referenceId;
    protected String referenceType;
    protected boolean completable;
    protected String tenantId = "";
    protected Date lockTime;
    protected String lockOwner;
    protected List<PlanItemInstanceEntity> childPlanItemInstances;
    protected List<SentryPartInstanceEntity> satisfiedSentryPartInstances;
    protected List<VariableInstanceEntity> queryVariables;
    protected String caseDefinitionKey;
    protected String caseDefinitionName;
    protected Integer caseDefinitionVersion;
    protected String caseDefinitionDeploymentId;

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("name", this.name);
        persistentState.put("parentId", this.parentId);
        persistentState.put("caseDefinitionId", this.caseDefinitionId);
        persistentState.put("state", this.state);
        persistentState.put("startTime", this.startTime);
        persistentState.put("startUserId", this.startUserId);
        persistentState.put("callbackId", this.callbackId);
        persistentState.put("callbackType", this.callbackType);
        persistentState.put("referenceId", this.referenceId);
        persistentState.put("referenceType", this.referenceType);
        persistentState.put("completeable", this.completable);
        persistentState.put("tenantId", this.tenantId);
        persistentState.put("lockTime", this.lockTime);
        persistentState.put("lockOwner", this.lockOwner);
        return persistentState;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return this.parentId;
    }

    @Override
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    @Override
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public String getState() {
        return this.state;
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getStartUserId() {
        return this.startUserId;
    }

    @Override
    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    public boolean isCompletable() {
        return this.completable;
    }

    @Override
    public void setCompletable(boolean completable) {
        this.completable = completable;
    }

    public boolean isCompleteable() {
        return this.completable;
    }

    public void setCompleteable(boolean completable) {
        this.completable = completable;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    @Override
    public void setCallbackId(String callbackId) {
        this.callbackId = callbackId;
    }

    public String getCallbackType() {
        return this.callbackType;
    }

    @Override
    public void setCallbackType(String callbackType) {
        this.callbackType = callbackType;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    @Override
    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Date getLockTime() {
        return this.lockTime;
    }

    @Override
    public void setLockTime(Date lockTime) {
        this.lockTime = lockTime;
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    @Override
    public List<PlanItem> getPlanItems() {
        if (this.caseDefinitionId != null) {
            return CaseDefinitionUtil.getCase(this.caseDefinitionId).getPlanModel().getPlanItems();
        }
        return Collections.emptyList();
    }

    @Override
    public List<PlanItemInstanceEntity> getChildPlanItemInstances() {
        return this.childPlanItemInstances;
    }

    @Override
    public void setChildPlanItemInstances(List<PlanItemInstanceEntity> childPlanItemInstances) {
        this.childPlanItemInstances = childPlanItemInstances;
    }

    @Override
    public List<SentryPartInstanceEntity> getSatisfiedSentryPartInstances() {
        if (this.satisfiedSentryPartInstances == null) {
            this.satisfiedSentryPartInstances = CommandContextUtil.getSentryPartInstanceEntityManager().findSentryPartInstancesByCaseInstanceIdAndNullPlanItemInstanceId(this.id);
        }
        return this.satisfiedSentryPartInstances;
    }

    @Override
    public void setSatisfiedSentryPartInstances(List<SentryPartInstanceEntity> sentryPartInstanceEntities) {
        this.satisfiedSentryPartInstances = sentryPartInstanceEntities;
    }

    protected Collection<VariableInstanceEntity> loadVariableInstances() {
        return this.getVariableServiceConfiguration().getVariableService().findVariableInstanceByScopeIdAndScopeType(this.id, "cmmn");
    }

    protected VariableScopeImpl getParentVariableScope() {
        return null;
    }

    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setScopeId(this.id);
        variableInstance.setScopeType("cmmn");
    }

    protected void addLoggingSessionInfo(ObjectNode loggingNode) {
        CmmnLoggingSessionUtil.fillLoggingData(loggingNode, this);
    }

    protected VariableInstanceEntity getSpecificVariable(String variableName) {
        return this.getVariableServiceConfiguration().getVariableService().createInternalVariableInstanceQuery().scopeId(this.id).withoutSubScopeId().scopeType("cmmn").name(variableName).singleResult();
    }

    protected List<VariableInstanceEntity> getSpecificVariables(Collection<String> variableNames) {
        return this.getVariableServiceConfiguration().getVariableService().createInternalVariableInstanceQuery().scopeId(this.id).withoutSubScopeId().scopeType("cmmn").names(variableNames).list();
    }

    protected boolean isPropagateToHistoricVariable() {
        return true;
    }

    protected VariableServiceConfiguration getVariableServiceConfiguration() {
        return CommandContextUtil.getCmmnEngineConfiguration().getVariableServiceConfiguration();
    }

    public Map<String, Object> getCaseVariables() {
        HashMap<String, Object> caseVariables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity queryVariable : this.queryVariables) {
                if (queryVariable.getId() == null || queryVariable.getTaskId() != null) continue;
                caseVariables.put(queryVariable.getName(), queryVariable.getValue());
            }
        }
        if (this.variableInstances != null) {
            for (String variableName : this.variableInstances.keySet()) {
                caseVariables.put(variableName, ((VariableInstanceEntity)this.variableInstances.get(variableName)).getValue());
            }
        }
        return caseVariables;
    }

    @Override
    public List<VariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new VariableInitializingList();
        }
        return this.queryVariables;
    }

    public void setQueryVariables(List<VariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    @Override
    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    @Override
    public void setCaseDefinitionName(String caseDefinitionName) {
        this.caseDefinitionName = caseDefinitionName;
    }

    public Integer getCaseDefinitionVersion() {
        return this.caseDefinitionVersion;
    }

    @Override
    public void setCaseDefinitionVersion(Integer caseDefinitionVersion) {
        this.caseDefinitionVersion = caseDefinitionVersion;
    }

    public String getCaseDefinitionDeploymentId() {
        return this.caseDefinitionDeploymentId;
    }

    @Override
    public void setCaseDefinitionDeploymentId(String caseDefinitionDeploymentId) {
        this.caseDefinitionDeploymentId = caseDefinitionDeploymentId;
    }
}

