/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceQuery;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryProperty;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.QueryCacheValues;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.variable.service.impl.AbstractVariableQueryImpl;

public class CaseInstanceQueryImpl
extends AbstractVariableQueryImpl<CaseInstanceQuery, CaseInstance>
implements CaseInstanceQuery,
QueryCacheValues {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected Set<String> caseDefinitionKeys;
    protected Set<String> caseDefinitionIds;
    protected String caseDefinitionCategory;
    protected String caseDefinitionName;
    protected Integer caseDefinitionVersion;
    protected String businessKey;
    protected String caseInstanceId;
    protected Set<String> caseInstanceIds;
    protected String caseInstanceParentId;
    protected String caseInstanceParentPlanItemInstanceId;
    protected Date startedBefore;
    protected Date startedAfter;
    protected String startedBy;
    protected String callbackId;
    protected String callbackType;
    protected String referenceId;
    protected String referenceType;
    protected boolean completeable;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected boolean includeCaseVariables;
    protected String involvedUser;
    protected Set<String> involvedGroups;
    protected List<CaseInstanceQueryImpl> orQueryObjects = new ArrayList<CaseInstanceQueryImpl>();
    protected CaseInstanceQueryImpl currentOrQueryObject;
    protected boolean inOrStatement;
    protected Integer caseInstanceVariablesLimit;

    public CaseInstanceQueryImpl() {
    }

    public CaseInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public CaseInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    protected void ensureVariablesInitialized() {
        super.ensureVariablesInitialized();
        for (CaseInstanceQueryImpl orQueryObject : this.orQueryObjects) {
            orQueryObject.ensureVariablesInitialized();
        }
    }

    public CaseInstanceQueryImpl caseDefinitionId(String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Case definition id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionId = caseDefinitionId;
        } else {
            this.caseDefinitionId = caseDefinitionId;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseDefinitionKey(String caseDefinitionKey) {
        if (caseDefinitionKey == null) {
            throw new FlowableIllegalArgumentException("Case definition key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionKey = caseDefinitionKey;
        } else {
            this.caseDefinitionKey = caseDefinitionKey;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseDefinitionCategory(String caseDefinitionCategory) {
        if (caseDefinitionCategory == null) {
            throw new FlowableIllegalArgumentException("Case definition category is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionCategory = caseDefinitionCategory;
        } else {
            this.caseDefinitionCategory = caseDefinitionCategory;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseDefinitionName(String caseDefinitionName) {
        if (caseDefinitionName == null) {
            throw new FlowableIllegalArgumentException("Case definition name is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionName = caseDefinitionName;
        } else {
            this.caseDefinitionName = caseDefinitionName;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseDefinitionVersion(Integer caseDefinitionVersion) {
        if (caseDefinitionVersion == null) {
            throw new FlowableIllegalArgumentException("Case definition version is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionVersion = caseDefinitionVersion;
        } else {
            this.caseDefinitionVersion = caseDefinitionVersion;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceId(String caseInstanceId) {
        if (caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("Case instance id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseInstanceId = caseInstanceId;
        } else {
            this.caseInstanceId = caseInstanceId;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceIds(Set<String> caseInstanceIds) {
        if (caseInstanceIds == null) {
            throw new FlowableIllegalArgumentException("Case instance ids is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseInstanceIds = caseInstanceIds;
        } else {
            this.caseInstanceIds = caseInstanceIds;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceBusinessKey(String businessKey) {
        if (businessKey == null) {
            throw new FlowableIllegalArgumentException("Business key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.businessKey = businessKey;
        } else {
            this.businessKey = businessKey;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseDefinitionKeys(Set<String> caseDefinitionKeys) {
        if (caseDefinitionKeys == null) {
            throw new FlowableIllegalArgumentException("Case definition keys is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionKeys = caseDefinitionKeys;
        } else {
            this.caseDefinitionKeys = caseDefinitionKeys;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceParentId(String parentId) {
        if (parentId == null) {
            throw new FlowableIllegalArgumentException("Parent id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseInstanceParentId = parentId;
        } else {
            this.caseInstanceParentId = parentId;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceStartedBefore(Date beforeTime) {
        if (beforeTime == null) {
            throw new FlowableIllegalArgumentException("before time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedBefore = beforeTime;
        } else {
            this.startedBefore = beforeTime;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceStartedAfter(Date afterTime) {
        if (afterTime == null) {
            throw new FlowableIllegalArgumentException("after time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedAfter = afterTime;
        } else {
            this.startedAfter = afterTime;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceStartedBy(String userId) {
        if (userId == null) {
            throw new FlowableIllegalArgumentException("user id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedBy = userId;
        } else {
            this.startedBy = userId;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceCallbackId(String callbackId) {
        if (callbackId == null) {
            throw new FlowableIllegalArgumentException("callbackId is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.callbackId = callbackId;
        } else {
            this.callbackId = callbackId;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceCallbackType(String callbackType) {
        if (callbackType == null) {
            throw new FlowableIllegalArgumentException("callbackType is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.callbackType = callbackType;
        } else {
            this.callbackType = callbackType;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceReferenceId(String referenceId) {
        if (referenceId == null) {
            throw new FlowableIllegalArgumentException("referenceId is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.referenceId = referenceId;
        } else {
            this.referenceId = referenceId;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceReferenceType(String referenceType) {
        if (referenceType == null) {
            throw new FlowableIllegalArgumentException("referenceType is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.referenceType = referenceType;
        } else {
            this.referenceType = referenceType;
        }
        return this;
    }

    public CaseInstanceQuery caseInstanceIsCompleteable() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.completeable = true;
        } else {
            this.completeable = true;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantId = tenantId;
        } else {
            this.tenantId = tenantId;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantIdLike = tenantIdLike;
        } else {
            this.tenantIdLike = tenantIdLike;
        }
        return this;
    }

    public CaseInstanceQueryImpl caseInstanceWithoutTenantId() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutTenantId = true;
        } else {
            this.withoutTenantId = true;
        }
        return this;
    }

    public CaseInstanceQuery involvedUser(String userId) {
        if (userId == null) {
            throw new FlowableIllegalArgumentException("involvedUser is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedUser = userId;
        } else {
            this.involvedUser = userId;
        }
        return this;
    }

    public CaseInstanceQuery involvedGroups(Set<String> groupIds) {
        if (groupIds == null) {
            throw new FlowableIllegalArgumentException("involvedGroups are null");
        }
        if (groupIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("involvedGroups are empty");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedGroups = groupIds;
        } else {
            this.involvedGroups = groupIds;
        }
        return this;
    }

    public CaseInstanceQuery or() {
        if (this.inOrStatement) {
            throw new FlowableException("the query is already in an or statement");
        }
        this.inOrStatement = true;
        this.currentOrQueryObject = new CaseInstanceQueryImpl();
        this.orQueryObjects.add(this.currentOrQueryObject);
        return this;
    }

    public CaseInstanceQuery endOr() {
        if (!this.inOrStatement) {
            throw new FlowableException("endOr() can only be called after calling or()");
        }
        this.inOrStatement = false;
        this.currentOrQueryObject = null;
        return this;
    }

    public CaseInstanceQuery variableValueEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableName, variableValue, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueEquals(variableName, variableValue, false);
    }

    public CaseInstanceQuery variableValueNotEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEquals(variableName, variableValue, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueNotEquals(variableName, variableValue, false);
    }

    public CaseInstanceQuery variableValueEquals(Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableValue, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueEquals(variableValue, false);
    }

    public CaseInstanceQuery variableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueEqualsIgnoreCase(name, value, false);
    }

    public CaseInstanceQuery variableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueNotEqualsIgnoreCase(name, value, false);
    }

    public CaseInstanceQuery variableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueGreaterThan(name, value, false);
    }

    public CaseInstanceQuery variableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueGreaterThanOrEqual(name, value, false);
    }

    public CaseInstanceQuery variableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThan(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueLessThan(name, value, false);
    }

    public CaseInstanceQuery variableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueLessThanOrEqual(name, value, false);
    }

    public CaseInstanceQuery variableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLike(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueLike(name, value, false);
    }

    public CaseInstanceQuery variableValueLikeIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableValueLikeIgnoreCase(name, value, false);
    }

    public CaseInstanceQuery variableExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableExists(name, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableExists(name, false);
    }

    public CaseInstanceQuery variableNotExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableNotExists(name, false);
            return this;
        }
        return (CaseInstanceQuery)this.variableNotExists(name, false);
    }

    public CaseInstanceQueryImpl orderByCaseInstanceId() {
        this.orderProperty = CaseInstanceQueryProperty.CASE_INSTANCE_ID;
        return this;
    }

    public CaseInstanceQueryImpl orderByCaseDefinitionId() {
        this.orderProperty = CaseInstanceQueryProperty.CASE_DEFINITION_ID;
        return this;
    }

    public CaseInstanceQueryImpl orderByCaseDefinitionKey() {
        this.orderProperty = CaseInstanceQueryProperty.CASE_DEFINITION_KEY;
        return this;
    }

    public CaseInstanceQueryImpl orderByStartTime() {
        this.orderProperty = CaseInstanceQueryProperty.CASE_START_TIME;
        return this;
    }

    public CaseInstanceQueryImpl orderByTenantId() {
        this.orderProperty = CaseInstanceQueryProperty.TENANT_ID;
        return this;
    }

    public CaseInstanceQueryImpl includeCaseVariables() {
        this.includeCaseVariables = true;
        return this;
    }

    public CaseInstanceQuery limitCaseInstanceVariables(Integer caseInstanceVariablesLimit) {
        this.caseInstanceVariablesLimit = caseInstanceVariablesLimit;
        return this;
    }

    public Integer getCaseInstanceVariablesLimit() {
        return this.caseInstanceVariablesLimit;
    }

    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        return CommandContextUtil.getCaseInstanceEntityManager(commandContext).countByCriteria(this);
    }

    public List<CaseInstance> executeList(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        if (this.isIncludeCaseVariables()) {
            return CommandContextUtil.getCaseInstanceEntityManager(commandContext).findWithVariablesByCriteria(this);
        }
        return CommandContextUtil.getCaseInstanceEntityManager(commandContext).findByCriteria(this);
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseDefinitionCategory() {
        return this.caseDefinitionCategory;
    }

    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    public Integer getCaseDefinitionVersion() {
        return this.caseDefinitionVersion;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getId() {
        return this.caseInstanceId;
    }

    public Set<String> getCaseInstanceIds() {
        return this.caseInstanceIds;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getExecutionId() {
        return this.caseInstanceId;
    }

    public Set<String> getCaseDefinitionIds() {
        return this.caseDefinitionIds;
    }

    public Set<String> getCaseDefinitionKeys() {
        return this.caseDefinitionKeys;
    }

    public String getParentId() {
        return this.caseInstanceParentId;
    }

    public String getCaseInstanceParentId() {
        return this.caseInstanceParentId;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public String getCallbackType() {
        return this.callbackType;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public boolean isCompleteable() {
        return this.completeable;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public Set<String> getInvolvedGroups() {
        return this.involvedGroups;
    }

    public boolean isIncludeCaseVariables() {
        return this.includeCaseVariables;
    }

    public String getMssqlOrDB2OrderBy() {
        String specialOrderBy = super.getOrderByColumns();
        if (specialOrderBy != null && specialOrderBy.length() > 0) {
            specialOrderBy = specialOrderBy.replace("RES.", "TEMPRES_");
        }
        return specialOrderBy;
    }
}

