/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.eventregistry;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.impl.consumer.BaseEventRegistryEventConsumer;
import org.flowable.eventregistry.impl.consumer.CorrelationKey;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionQuery;
import org.flowable.eventsubscription.service.impl.EventSubscriptionQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnEventRegistryEventConsumer
extends BaseEventRegistryEventConsumer {
    private static Logger LOGGER = LoggerFactory.getLogger(CmmnEventRegistryEventConsumer.class);
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public CmmnEventRegistryEventConsumer(CmmnEngineConfiguration cmmnEngineConfiguration) {
        super((AbstractEngineConfiguration)cmmnEngineConfiguration);
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public String getConsumerKey() {
        return "cmmnEventConsumer";
    }

    protected void eventReceived(EventInstance eventInstance) {
        Collection correlationKeys = this.generateCorrelationKeys(eventInstance.getCorrelationParameterInstances());
        List eventSubscriptions = this.findEventSubscriptions("cmmn", eventInstance, correlationKeys);
        CmmnRuntimeService cmmnRuntimeService = this.cmmnEngineConfiguration.getCmmnRuntimeService();
        for (EventSubscription eventSubscription : eventSubscriptions) {
            this.handleEventSubscription(cmmnRuntimeService, eventSubscription, eventInstance, correlationKeys);
        }
    }

    protected void handleEventSubscription(CmmnRuntimeService cmmnRuntimeService, EventSubscription eventSubscription, EventInstance eventInstance, Collection<CorrelationKey> correlationKeys) {
        if (eventSubscription.getSubScopeId() != null) {
            cmmnRuntimeService.createPlanItemInstanceTransitionBuilder(eventSubscription.getSubScopeId()).transientVariable("eventInstance", (Object)eventInstance).trigger();
        } else if (eventSubscription.getScopeDefinitionId() != null && eventSubscription.getScopeId() == null && eventSubscription.getSubScopeId() == null) {
            String startCorrelationConfiguration;
            CaseInstanceBuilder caseInstanceBuilder = cmmnRuntimeService.createCaseInstanceBuilder().caseDefinitionId(eventSubscription.getScopeDefinitionId()).transientVariable("eventInstance", (Object)eventInstance);
            if (eventInstance.getTenantId() != null && !Objects.equals("", eventInstance.getTenantId())) {
                caseInstanceBuilder.overrideCaseDefinitionTenantId(eventInstance.getTenantId());
            }
            if (correlationKeys != null && Objects.equals(startCorrelationConfiguration = this.getStartCorrelationConfiguration(eventSubscription), "storeAsUniqueReferenceId")) {
                CorrelationKey correlationKeyWithAllParameters = this.getCorrelationKeyWithAllParameters(correlationKeys);
                long caseInstanceCount = cmmnRuntimeService.createCaseInstanceQuery().caseDefinitionId(eventSubscription.getScopeDefinitionId()).caseInstanceReferenceId(correlationKeyWithAllParameters.getValue()).caseInstanceReferenceType("event-to-cmmn-1.1-case").count();
                if (caseInstanceCount > 0L) {
                    LOGGER.debug("Event received to start a new case instance, but a unique instance already exists.");
                    return;
                }
                caseInstanceBuilder.referenceId(correlationKeyWithAllParameters.getValue());
                caseInstanceBuilder.referenceType("event-to-cmmn-1.1-case");
            }
            caseInstanceBuilder.startAsync();
        }
    }

    protected String getStartCorrelationConfiguration(EventSubscription eventSubscription) {
        List correlationCfgExtensions;
        CmmnModel cmmnModel = this.cmmnEngineConfiguration.getCmmnRepositoryService().getCmmnModel(eventSubscription.getScopeDefinitionId());
        if (cmmnModel != null && !(correlationCfgExtensions = cmmnModel.getPrimaryCase().getExtensionElements().getOrDefault("startEventCorrelationConfiguration", Collections.emptyList())).isEmpty()) {
            return ((ExtensionElement)correlationCfgExtensions.get(0)).getElementText();
        }
        return null;
    }

    protected EventSubscriptionQuery createEventSubscriptionQuery() {
        return new EventSubscriptionQueryImpl(this.commandExecutor);
    }
}

