/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.identitylink.api.IdentityLink;

public class GetIdentityLinksForPlanItemInstanceCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String planItemInstanceId;

    public GetIdentityLinksForPlanItemInstanceCmd(String planItemInstanceId) {
        this.planItemInstanceId = planItemInstanceId;
    }

    public List<IdentityLink> execute(CommandContext commandContext) {
        PlanItemInstance planItemInstance = (PlanItemInstance)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(this.planItemInstanceId);
        if (planItemInstance == null) {
            throw new FlowableObjectNotFoundException("Cannot find plan item instance with id " + this.planItemInstanceId, PlanItemInstanceEntity.class);
        }
        return CommandContextUtil.getIdentityLinkService(commandContext).findIdentityLinksBySubScopeIdAndType(this.planItemInstanceId, "planItem");
    }
}

