/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.callback;

import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.listener.PlanItemLifeCycleListenerUtil;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.job.api.Job;
import org.flowable.job.service.InternalJobManager;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class DefaultInternalCmmnJobManager
implements InternalJobManager {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public DefaultInternalCmmnJobManager(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public VariableScope resolveVariableScope(Job job) {
        if (job.getSubScopeId() != null) {
            return (VariableScope)this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(job.getSubScopeId());
        }
        return null;
    }

    public boolean handleJobInsert(Job job) {
        return true;
    }

    public void handleJobDelete(Job job) {
    }

    public void lockJobScope(Job job) {
        PlanItemInstanceEntity planItemInstanceEntity;
        CaseInstanceEntityManager caseInstanceEntityManager = this.cmmnEngineConfiguration.getCaseInstanceEntityManager();
        caseInstanceEntityManager.updateLockTime(job.getScopeId());
        if (this.cmmnEngineConfiguration.isLoggingSessionEnabled() && (planItemInstanceEntity = (PlanItemInstanceEntity)this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(job.getSubScopeId())) != null) {
            CmmnLoggingSessionUtil.addAsyncActivityLoggingData("Locking job for " + planItemInstanceEntity.getPlanItemDefinitionId() + ", with job id " + job.getId(), "serviceTaskLockJob", (JobEntity)job, planItemInstanceEntity.getPlanItemDefinition(), planItemInstanceEntity);
        }
    }

    public void clearJobScopeLock(Job job) {
        PlanItemInstanceEntity planItemInstanceEntity;
        CaseInstanceEntityManager caseInstanceEntityManager = this.cmmnEngineConfiguration.getCaseInstanceEntityManager();
        caseInstanceEntityManager.clearLockTime(job.getScopeId());
        if (this.cmmnEngineConfiguration.isLoggingSessionEnabled() && (planItemInstanceEntity = (PlanItemInstanceEntity)this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(job.getSubScopeId())) != null) {
            CmmnLoggingSessionUtil.addAsyncActivityLoggingData("Unlocking job for " + planItemInstanceEntity.getPlanItemDefinitionId() + ", with job id " + job.getId(), "serviceTaskUnlockJob", (JobEntity)job, planItemInstanceEntity.getPlanItemDefinition(), planItemInstanceEntity);
        }
    }

    public void preTimerJobDelete(JobEntity jobEntity, VariableScope variableScope) {
    }

    public void preRepeatedTimerSchedule(TimerJobEntity timerJobEntity, VariableScope variableScope) {
        if (variableScope instanceof PlanItemInstanceEntity) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)variableScope;
            PlanItemInstanceEntity stagePlanItem = planItemInstanceEntity.getStagePlanItemInstanceEntity();
            if (stagePlanItem == null && planItemInstanceEntity.getStageInstanceId() != null) {
                stagePlanItem = (PlanItemInstance)this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(planItemInstanceEntity.getStageInstanceId());
            }
            PlanItemInstanceEntity newPlanItemInstanceEntity = this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().createPlanItemInstanceEntityBuilder().planItem(planItemInstanceEntity.getPlanItem()).caseDefinitionId(planItemInstanceEntity.getCaseDefinitionId()).caseInstanceId(planItemInstanceEntity.getCaseInstanceId()).stagePlanItemInstance((PlanItemInstance)stagePlanItem).tenantId(planItemInstanceEntity.getTenantId()).addToParent(true).create();
            String oldState = newPlanItemInstanceEntity.getState();
            String newState = "available";
            newPlanItemInstanceEntity.setState(newState);
            PlanItemLifeCycleListenerUtil.callLifecycleListeners(Context.getCommandContext(), planItemInstanceEntity, oldState, newState);
            CommandContextUtil.getAgenda().planCreatePlanItemInstanceOperation(newPlanItemInstanceEntity);
            timerJobEntity.setSubScopeId(newPlanItemInstanceEntity.getId());
        }
    }
}

