/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.naming.NamingException;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.cfg.mail.MailServerInfo;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.content.api.ContentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailActivityBehavior
extends CoreCmmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MailActivityBehavior.class);
    private static final String NEWLINE_REGEX = "\\r?\\n";
    protected Expression to;
    protected Expression from;
    protected Expression cc;
    protected Expression bcc;
    protected Expression headers;
    protected Expression subject;
    protected Expression text;
    protected Expression textVar;
    protected Expression html;
    protected Expression htmlVar;
    protected Expression charset;
    protected Expression ignoreException;
    protected Expression exceptionVariableName;
    protected Expression attachments;

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        boolean doIgnoreException = Boolean.parseBoolean(this.getStringFromField(this.ignoreException, planItemInstanceEntity));
        String exceptionVariable = this.getStringFromField(this.exceptionVariableName, planItemInstanceEntity);
        Email email = null;
        try {
            String headersStr = this.getStringFromField(this.headers, planItemInstanceEntity);
            String toStr = this.getStringFromField(this.to, planItemInstanceEntity);
            String fromStr = this.getStringFromField(this.from, planItemInstanceEntity);
            String ccStr = this.getStringFromField(this.cc, planItemInstanceEntity);
            String bccStr = this.getStringFromField(this.bcc, planItemInstanceEntity);
            String subjectStr = this.getStringFromField(this.subject, planItemInstanceEntity);
            String textStr = this.textVar == null ? this.getStringFromField(this.text, planItemInstanceEntity) : this.getStringFromField(this.getExpression(commandContext, planItemInstanceEntity, this.textVar), planItemInstanceEntity);
            String htmlStr = this.htmlVar == null ? this.getStringFromField(this.html, planItemInstanceEntity) : this.getStringFromField(this.getExpression(commandContext, planItemInstanceEntity, this.htmlVar), planItemInstanceEntity);
            String charSetStr = this.getStringFromField(this.charset, planItemInstanceEntity);
            LinkedList<File> files = new LinkedList<File>();
            LinkedList<DataSource> dataSources = new LinkedList<DataSource>();
            this.getFilesFromFields(this.attachments, planItemInstanceEntity, files, dataSources);
            email = this.createEmail(textStr, htmlStr, this.attachmentsExist(files, dataSources));
            this.addHeader(email, headersStr);
            this.addTo(commandContext, email, toStr, planItemInstanceEntity.getTenantId());
            this.setFrom(commandContext, email, fromStr, planItemInstanceEntity.getTenantId());
            this.addCc(commandContext, email, ccStr, planItemInstanceEntity.getTenantId());
            this.addBcc(commandContext, email, bccStr, planItemInstanceEntity.getTenantId());
            this.setSubject(email, subjectStr);
            this.setMailServerProperties(commandContext, email, planItemInstanceEntity.getTenantId());
            this.setCharset(email, charSetStr);
            this.attach(email, files, dataSources);
            email.send();
        }
        catch (FlowableException e) {
            this.handleException(planItemInstanceEntity, e.getMessage(), (Exception)((Object)e), doIgnoreException, exceptionVariable);
        }
        catch (EmailException e) {
            this.handleException(planItemInstanceEntity, "Could not send e-mail for plan item instance " + planItemInstanceEntity.getId(), (Exception)((Object)e), doIgnoreException, exceptionVariable);
        }
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
    }

    protected void addHeader(Email email, String headersStr) {
        if (headersStr == null) {
            return;
        }
        for (String headerEntry : headersStr.split(NEWLINE_REGEX)) {
            String[] split = headerEntry.split(":");
            if (split.length != 2) {
                throw new FlowableIllegalArgumentException("When using email headers name and value must be defined colon separated. (e.g. X-Attribute: value");
            }
            String name = split[0].trim();
            String value = split[1].trim();
            email.addHeader(name, value);
        }
    }

    private boolean attachmentsExist(List<File> files, List<DataSource> dataSources) {
        return files != null && !files.isEmpty() || dataSources != null && !dataSources.isEmpty();
    }

    protected Email createEmail(String text, String html, boolean attachmentsExist) {
        if (html != null) {
            return this.createHtmlEmail(text, html);
        }
        if (text != null) {
            if (!attachmentsExist) {
                return this.createTextOnlyEmail(text);
            }
            return this.createMultiPartEmail(text);
        }
        throw new FlowableIllegalArgumentException("'html' or 'text' is required to be defined when using the mail activity");
    }

    protected HtmlEmail createHtmlEmail(String text, String html) {
        HtmlEmail email = new HtmlEmail();
        try {
            email.setHtmlMsg(html);
            if (text != null) {
                email.setTextMsg(text);
            }
            return email;
        }
        catch (EmailException e) {
            throw new FlowableException("Could not create HTML email", (Throwable)e);
        }
    }

    protected SimpleEmail createTextOnlyEmail(String text) {
        SimpleEmail email = new SimpleEmail();
        try {
            email.setMsg(text);
            return email;
        }
        catch (EmailException e) {
            throw new FlowableException("Could not create text-only email", (Throwable)e);
        }
    }

    protected MultiPartEmail createMultiPartEmail(String text) {
        MultiPartEmail email = new MultiPartEmail();
        try {
            email.setMsg(text);
            return email;
        }
        catch (EmailException e) {
            throw new FlowableException("Could not create text-only email", (Throwable)e);
        }
    }

    protected void addTo(CommandContext commandContext, Email email, String to, String tenantId) {
        String[] tos;
        if (to == null) {
            throw new FlowableException("No recipient could be found for sending email");
        }
        String newTo = this.getForceTo(commandContext, tenantId);
        if (newTo == null) {
            newTo = to;
        }
        if ((tos = this.splitAndTrim(newTo)) != null) {
            for (String t : tos) {
                try {
                    email.addTo(t);
                }
                catch (EmailException e) {
                    throw new FlowableException("Could not add " + t + " as recipient", (Throwable)e);
                }
            }
        } else {
            throw new FlowableException("No recipient could be found for sending email");
        }
    }

    protected void setFrom(CommandContext commandContext, Email email, String from, String tenantId) {
        String fromAddress = null;
        if (from != null) {
            fromAddress = from;
        } else {
            Map<String, MailServerInfo> mailServers;
            if (tenantId != null && tenantId.length() > 0 && (mailServers = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getMailServers()) != null && mailServers.containsKey(tenantId)) {
                MailServerInfo mailServerInfo = mailServers.get(tenantId);
                fromAddress = mailServerInfo.getMailServerDefaultFrom();
            }
            if (fromAddress == null) {
                fromAddress = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getMailServerDefaultFrom();
            }
        }
        try {
            email.setFrom(fromAddress);
        }
        catch (EmailException e) {
            throw new FlowableException("Could not set " + from + " as from address in email", (Throwable)e);
        }
    }

    protected void addCc(CommandContext commandContext, Email email, String cc, String tenantId) {
        String[] ccs;
        if (cc == null) {
            return;
        }
        String newCc = this.getForceTo(commandContext, tenantId);
        if (newCc == null) {
            newCc = cc;
        }
        if ((ccs = this.splitAndTrim(newCc)) != null) {
            for (String c : ccs) {
                try {
                    email.addCc(c);
                }
                catch (EmailException e) {
                    throw new FlowableException("Could not add " + c + " as cc recipient", (Throwable)e);
                }
            }
        }
    }

    protected void addBcc(CommandContext commandContext, Email email, String bcc, String tenantId) {
        String[] bccs;
        if (bcc == null) {
            return;
        }
        String newBcc = this.getForceTo(commandContext, tenantId);
        if (newBcc == null) {
            newBcc = bcc;
        }
        if ((bccs = this.splitAndTrim(newBcc)) != null) {
            for (String b : bccs) {
                try {
                    email.addBcc(b);
                }
                catch (EmailException e) {
                    throw new FlowableException("Could not add " + b + " as bcc recipient", (Throwable)e);
                }
            }
        }
    }

    protected void attach(Email email, List<File> files, List<DataSource> dataSources) throws EmailException {
        if (!(email instanceof MultiPartEmail) || !this.attachmentsExist(files, dataSources)) {
            return;
        }
        MultiPartEmail mpEmail = (MultiPartEmail)email;
        for (File file : files) {
            mpEmail.attach(file);
        }
        for (DataSource ds : dataSources) {
            if (ds == null) continue;
            mpEmail.attach(ds, ds.getName(), null);
        }
    }

    protected void setSubject(Email email, String subject) {
        email.setSubject(subject != null ? subject : "");
    }

    protected void setMailServerProperties(CommandContext commandContext, Email email, String tenantId) {
        String host;
        CmmnEngineConfiguration engineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        boolean isMailServerSet = false;
        if (tenantId != null && tenantId.length() > 0) {
            if (engineConfiguration.getMailSessionJndi(tenantId) != null) {
                this.setEmailSession(email, engineConfiguration.getMailSessionJndi(tenantId));
                isMailServerSet = true;
            } else if (engineConfiguration.getMailServer(tenantId) != null) {
                MailServerInfo mailServerInfo = engineConfiguration.getMailServer(tenantId);
                host = mailServerInfo.getMailServerHost();
                if (host == null) {
                    throw new FlowableException("Could not send email: no SMTP host is configured for tenantId " + tenantId);
                }
                email.setHostName(host);
                email.setSmtpPort(mailServerInfo.getMailServerPort());
                email.setSSLOnConnect(mailServerInfo.isMailServerUseSSL());
                email.setStartTLSEnabled(mailServerInfo.isMailServerUseTLS());
                String user = mailServerInfo.getMailServerUsername();
                String password = mailServerInfo.getMailServerPassword();
                if (user != null && password != null) {
                    email.setAuthentication(user, password);
                }
                isMailServerSet = true;
            }
        }
        if (!isMailServerSet) {
            String mailSessionJndi = engineConfiguration.getMailSessionJndi();
            if (mailSessionJndi != null) {
                this.setEmailSession(email, mailSessionJndi);
            } else {
                host = engineConfiguration.getMailServerHost();
                if (host == null) {
                    throw new FlowableException("Could not send email: no SMTP host is configured");
                }
                email.setHostName(host);
                int port = engineConfiguration.getMailServerPort();
                email.setSmtpPort(port);
                email.setSSLOnConnect(engineConfiguration.getMailServerUseSSL());
                email.setStartTLSEnabled(engineConfiguration.getMailServerUseTLS());
                String user = engineConfiguration.getMailServerUsername();
                String password = engineConfiguration.getMailServerPassword();
                if (user != null && password != null) {
                    email.setAuthentication(user, password);
                }
            }
        }
    }

    protected void setEmailSession(Email email, String mailSessionJndi) {
        try {
            email.setMailSessionFromJNDI(mailSessionJndi);
        }
        catch (NamingException e) {
            throw new FlowableException("Could not send email: Incorrect JNDI configuration", (Throwable)e);
        }
    }

    protected void setCharset(Email email, String charSetStr) {
        if (this.charset != null) {
            email.setCharset(charSetStr);
        }
    }

    protected String[] splitAndTrim(String str) {
        if (str != null) {
            String[] splittedStrings = str.split(",");
            for (int i = 0; i < splittedStrings.length; ++i) {
                splittedStrings[i] = splittedStrings[i].trim();
            }
            return splittedStrings;
        }
        return null;
    }

    protected String getStringFromField(Expression expression, PlanItemInstanceEntity planItemInstanceEntity) {
        Object value;
        if (expression != null && (value = expression.getValue((VariableContainer)planItemInstanceEntity)) != null) {
            return value.toString();
        }
        return null;
    }

    protected void getFilesFromFields(Expression expression, PlanItemInstanceEntity planItemInstanceEntity, List<File> files, List<DataSource> dataSources) {
        if (expression == null) {
            return;
        }
        Object value = expression.getValue((VariableContainer)planItemInstanceEntity);
        if (value != null) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (!collection.isEmpty()) {
                    for (Object object : collection) {
                        this.addExpressionValueToAttachments(object, files, dataSources);
                    }
                }
            } else {
                this.addExpressionValueToAttachments(value, files, dataSources);
            }
            files.removeIf(file -> !this.fileExists((File)file));
        }
    }

    protected void addExpressionValueToAttachments(Object value, List<File> files, List<DataSource> dataSources) {
        if (value instanceof File) {
            files.add((File)value);
        } else if (value instanceof String) {
            files.add(new File((String)value));
        } else if (value instanceof File[]) {
            Collections.addAll(files, (File[])value);
        } else if (value instanceof String[]) {
            String[] paths;
            for (String path : paths = (String[])value) {
                files.add(new File(path));
            }
        } else if (value instanceof DataSource) {
            dataSources.add((DataSource)value);
        } else if (value instanceof DataSource[]) {
            for (DataSource ds : (DataSource[])value) {
                if (ds == null) continue;
                dataSources.add(ds);
            }
        } else if (value instanceof ContentItem) {
            dataSources.add(new ContentItemDataSourceWrapper((ContentItem)value));
        } else if (value instanceof ContentItem[]) {
            for (ContentItem contentItem : (ContentItem[])value) {
                dataSources.add(new ContentItemDataSourceWrapper(contentItem));
            }
        } else {
            throw new FlowableException("Invalid attachment type: " + value.getClass());
        }
    }

    protected boolean fileExists(File file) {
        return file != null && file.exists() && file.isFile() && file.canRead();
    }

    protected Expression getExpression(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, Expression var) {
        String variable = (String)planItemInstanceEntity.getVariable(var.getExpressionText());
        return CommandContextUtil.getCmmnEngineConfiguration(commandContext).getExpressionManager().createExpression(variable);
    }

    protected void handleException(PlanItemInstanceEntity planItemInstanceEntity, String msg, Exception e, boolean doIgnoreException, String exceptionVariable) {
        if (doIgnoreException) {
            LOGGER.info("Ignoring email send error: {}", (Object)msg, (Object)e);
            if (exceptionVariable != null && exceptionVariable.length() > 0) {
                planItemInstanceEntity.setVariable(exceptionVariable, msg);
            }
        } else {
            if (e instanceof FlowableException) {
                throw (FlowableException)((Object)e);
            }
            throw new FlowableException(msg, (Throwable)e);
        }
    }

    protected String getForceTo(CommandContext commandContext, String tenantId) {
        Map<String, MailServerInfo> mailServers;
        String forceTo = null;
        if (tenantId != null && tenantId.length() > 0 && (mailServers = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getMailServers()) != null && mailServers.containsKey(tenantId)) {
            MailServerInfo mailServerInfo = mailServers.get(tenantId);
            forceTo = mailServerInfo.getMailServerForceTo();
        }
        if (forceTo == null) {
            forceTo = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getMailServerForceTo();
        }
        return forceTo;
    }

    public static class ContentItemDataSourceWrapper
    implements DataSource {
        protected ContentItem contentItem;

        public ContentItemDataSourceWrapper(ContentItem contentItem) {
            this.contentItem = contentItem;
        }

        public InputStream getInputStream() throws IOException {
            return CommandContextUtil.getContentService().getContentItemData(this.contentItem.getId());
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public String getContentType() {
            return this.contentItem.getMimeType();
        }

        public String getName() {
            return this.contentItem.getName();
        }
    }
}

