/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.engine.impl.agenda.operation.AbstractDeleteCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class TerminateCaseInstanceOperation
extends AbstractDeleteCaseInstanceOperation {
    protected boolean manualTermination;
    protected String exitCriterionId;
    protected String exitType;
    protected String exitEventType;

    public TerminateCaseInstanceOperation(CommandContext commandContext, String caseInstanceId, boolean manualTermination, String exitCriterionId, String exitType, String exitEventType) {
        super(commandContext, caseInstanceId);
        this.manualTermination = manualTermination;
        this.exitCriterionId = exitCriterionId;
        this.exitType = exitType;
        this.exitEventType = exitEventType;
    }

    @Override
    public void run() {
        if ("complete".equals(this.exitEventType)) {
            this.checkCaseToBeCompletable();
        }
        super.run();
    }

    protected void checkCaseToBeCompletable() {
        if (!this.getCaseInstanceEntity().isCompletable()) {
            throw new FlowableIllegalArgumentException("Cannot exit case with 'complete' event type as the case '" + this.getCaseInstanceId() + "' is not yet completable.");
        }
    }

    @Override
    protected String getNewState() {
        if ("complete".equals(this.exitEventType) || "forceComplete".equals(this.exitEventType)) {
            return "completed";
        }
        return "terminated";
    }

    @Override
    protected void changeStateForChildPlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        if (this.manualTermination) {
            CommandContextUtil.getAgenda(this.commandContext).planTerminatePlanItemInstanceOperation(planItemInstanceEntity, null, null);
        } else {
            CommandContextUtil.getAgenda(this.commandContext).planExitPlanItemInstanceOperation(planItemInstanceEntity, this.exitCriterionId, null, null);
        }
    }

    @Override
    protected String getDeleteReason() {
        return "cmmn-state-transition-terminate-case";
    }
}

