/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.Objects;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.criteria.PlanItemLifeCycleEvent;
import org.flowable.cmmn.engine.impl.listener.PlanItemLifeCycleListenerUtil;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.runtime.StateTransition;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class AbstractChangePlanItemInstanceStateOperation
extends AbstractPlanItemInstanceOperation {
    public AbstractChangePlanItemInstanceStateOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    public void run() {
        Object behavior;
        String newState;
        String oldState = this.planItemInstanceEntity.getState();
        if (this.isStateNotChanged(oldState, newState = this.getNewState())) {
            this.markAsNoop();
            return;
        }
        if (this.planItemInstanceEntity.getPlanItem() != null && (behavior = this.planItemInstanceEntity.getPlanItem().getBehavior()) instanceof PlanItemActivityBehavior && StateTransition.isPossible((PlanItemInstance)this.planItemInstanceEntity, this.getLifeCycleTransition())) {
            ((PlanItemActivityBehavior)behavior).onStateTransition(this.commandContext, this.planItemInstanceEntity, this.getLifeCycleTransition());
        }
        this.planItemInstanceEntity.setState(newState);
        PlanItemLifeCycleListenerUtil.callLifecycleListeners(this.commandContext, this.planItemInstanceEntity, oldState, this.getNewState());
        CommandContextUtil.getAgenda(this.commandContext).planEvaluateCriteriaOperation(this.planItemInstanceEntity.getCaseInstanceId(), this.createPlanItemLifeCycleEvent());
        this.internalExecute();
        if (CommandContextUtil.getCmmnEngineConfiguration(this.commandContext).isLoggingSessionEnabled()) {
            String loggingType = null;
            String message = null;
            if (oldState == null) {
                loggingType = "planItemCreated";
                message = "Plan item instance created with type " + this.planItemInstanceEntity.getPlanItemDefinitionType() + ", new state " + this.planItemInstanceEntity.getState();
            } else {
                loggingType = "planItemNewState";
                message = "Plan item instance state change with type " + this.planItemInstanceEntity.getPlanItemDefinitionType() + ", old state " + oldState + ", new state " + newState;
            }
            CmmnLoggingSessionUtil.addLoggingData(loggingType, message, oldState, newState, this.planItemInstanceEntity);
        }
    }

    protected boolean isStateNotChanged(String oldState, String newState) {
        return oldState != null && oldState.equals(newState) && this.abortOperationIfNewStateEqualsOldState();
    }

    protected abstract void internalExecute();

    protected PlanItemLifeCycleEvent createPlanItemLifeCycleEvent() {
        return new PlanItemLifeCycleEvent(this.planItemInstanceEntity.getPlanItem(), this.getLifeCycleTransition());
    }

    protected abstract String getNewState();

    protected abstract String getLifeCycleTransition();

    protected boolean abortOperationIfNewStateEqualsOldState() {
        return false;
    }

    protected abstract String getOperationName();

    public String toString() {
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        StringBuilder stringBuilder = new StringBuilder();
        String operationName = this.getOperationName();
        stringBuilder.append(operationName != null ? operationName : "[Change plan item state]").append(" ");
        if (planItem != null) {
            stringBuilder.append(planItem);
        } else {
            stringBuilder.append(this.planItemInstanceEntity);
        }
        stringBuilder.append(", ");
        String currentState = this.planItemInstanceEntity.getState();
        String newState = this.getNewState();
        if (!Objects.equals(currentState, newState)) {
            stringBuilder.append("new state: [").append(this.getNewState()).append("]");
            stringBuilder.append(" with transition [");
            stringBuilder.append(this.getLifeCycleTransition());
            stringBuilder.append("]");
        } else {
            stringBuilder.append("will remain in state [").append(newState).append("]");
        }
        return stringBuilder.toString();
    }
}

