/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.test;

import java.time.Instant;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnManagementService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.CmmnTaskService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.test.impl.CmmnJobTestHelper;
import org.flowable.cmmn.engine.test.impl.CmmnTestRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=CmmnTestRunner.class)
public abstract class AbstractFlowableCmmnTestCase {
    public static CmmnEngine cmmnEngine;
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected CmmnManagementService cmmnManagementService;
    protected CmmnRepositoryService cmmnRepositoryService;
    protected CmmnRuntimeService cmmnRuntimeService;
    protected CmmnTaskService cmmnTaskService;
    protected CmmnHistoryService cmmnHistoryService;
    protected String deploymentId;

    @After
    public void cleanup() {
        if (this.deploymentId != null) {
            this.cmmnRepositoryService.deleteDeployment(this.deploymentId, true);
        }
    }

    protected void deployOneHumanTaskCaseModel() {
        this.deploymentId = this.cmmnRepositoryService.createDeployment().addClasspathResource("org/flowable/cmmn/test/one-human-task-model.cmmn").deploy().getId();
    }

    protected CaseInstance deployAndStartOneHumanTaskCaseModel() {
        this.deployOneHumanTaskCaseModel();
        return this.cmmnRuntimeService.createCaseInstanceBuilder().caseDefinitionKey("oneTaskCase").start();
    }

    protected void deployOneTaskCaseModel() {
        this.deploymentId = this.cmmnRepositoryService.createDeployment().addClasspathResource("org/flowable/cmmn/test/one-task-model.cmmn").deploy().getId();
    }

    protected Date setClockFixedToCurrentTime() {
        Date date = Date.from(Instant.now().with(ChronoField.MILLI_OF_SECOND, 0L));
        this.cmmnEngineConfiguration.getClock().setCurrentTime(date);
        return date;
    }

    protected void setClockTo(long epochTime) {
        this.setClockTo(new Date(epochTime));
    }

    protected void setClockTo(Date date) {
        this.cmmnEngineConfiguration.getClock().setCurrentTime(date);
    }

    protected Date forwardClock(long milliseconds) {
        long currentMillis = this.cmmnEngineConfiguration.getClock().getCurrentTime().getTime();
        Date date = new Date(currentMillis + milliseconds);
        this.cmmnEngineConfiguration.getClock().setCurrentTime(date);
        return date;
    }

    protected void assertCaseInstanceEnded(CaseInstance caseInstance) {
        long count = this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstance.getId()).count();
        Assert.assertEquals((String)this.createCaseInstanceEndedErrorMessage(caseInstance, count), (long)0L, (long)count);
        Assert.assertEquals((String)"Runtime case instance found", (long)0L, (long)this.cmmnRuntimeService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).count());
        Assert.assertEquals((long)1L, (long)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstance.getId()).finished().count());
    }

    protected String createCaseInstanceEndedErrorMessage(CaseInstance caseInstance, long count) {
        String errorMessage = "Plan item instances found for case instance: ";
        if (count != 0L) {
            List planItemInstances = this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstance.getId()).list();
            String names = planItemInstances.stream().map(planItemInstance -> planItemInstance.getName() + "(" + planItemInstance.getPlanItemDefinitionType() + ")").collect(Collectors.joining(", "));
            errorMessage = errorMessage + names;
        }
        return errorMessage;
    }

    protected void assertCaseInstanceEnded(CaseInstance caseInstance, int nrOfExpectedMilestones) {
        this.assertCaseInstanceEnded(caseInstance);
        Assert.assertEquals((long)0L, (long)this.cmmnRuntimeService.createMilestoneInstanceQuery().milestoneInstanceCaseInstanceId(caseInstance.getId()).count());
        Assert.assertEquals((long)nrOfExpectedMilestones, (long)this.cmmnHistoryService.createHistoricMilestoneInstanceQuery().milestoneInstanceCaseInstanceId(caseInstance.getId()).count());
    }

    protected void assertCaseInstanceNotEnded(CaseInstance caseInstance) {
        Assert.assertTrue((String)"Found no plan items for case instance", (this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstance.getId()).count() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"No runtime case instance found", (this.cmmnRuntimeService.createCaseInstanceQuery().caseInstanceId(caseInstance.getId()).count() > 0L ? 1 : 0) != 0);
        Assert.assertNull((String)"Historical case instance is already marked as ended", (Object)((HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstance.getId()).singleResult()).getEndTime());
    }

    protected void waitForJobExecutorToProcessAllJobs() {
        CmmnJobTestHelper.waitForJobExecutorToProcessAllJobs(this.cmmnEngineConfiguration, 20000L, 200L, true);
    }

    protected void waitForAsyncHistoryExecutorToProcessAllJobs() {
        CmmnJobTestHelper.waitForAsyncHistoryExecutorToProcessAllJobs(this.cmmnEngineConfiguration, 20000L, 200L, true);
    }
}

