/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.ExpressionUtil;
import org.flowable.cmmn.model.ManualActivationRule;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.Task;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class ActivatePlanItemInstanceOperation
extends AbstractPlanItemInstanceOperation {
    protected String entryCriterionId;

    public ActivatePlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        super(commandContext, planItemInstanceEntity);
        this.entryCriterionId = entryCriterionId;
    }

    @Override
    public void run() {
        if (this.isAsync() && !"async-active".equals(this.planItemInstanceEntity.getState())) {
            CommandContextUtil.getAgenda(this.commandContext).planActivateAsyncPlanItemInstanceOperation(this.planItemInstanceEntity, this.entryCriterionId);
        } else {
            boolean isManuallyActivated;
            if (this.entryCriterionId != null) {
                this.planItemInstanceEntity.setEntryCriterionId(this.entryCriterionId);
            }
            if (isManuallyActivated = this.evaluateManualActivationRule()) {
                CommandContextUtil.getAgenda(this.commandContext).planEnablePlanItemInstanceOperation(this.planItemInstanceEntity, this.entryCriterionId);
            } else {
                CommandContextUtil.getAgenda(this.commandContext).planStartPlanItemInstanceOperation(this.planItemInstanceEntity, this.entryCriterionId);
            }
        }
    }

    protected boolean evaluateManualActivationRule() {
        PlanItemControl planItemControl = this.planItemInstanceEntity.getPlanItem().getItemControl();
        if (planItemControl != null && planItemControl.getManualActivationRule() != null) {
            ManualActivationRule manualActivationRule = planItemControl.getManualActivationRule();
            if (StringUtils.isNotEmpty((CharSequence)manualActivationRule.getCondition())) {
                return ExpressionUtil.evaluateBooleanExpression(this.commandContext, (VariableContainer)this.planItemInstanceEntity, manualActivationRule.getCondition());
            }
            return true;
        }
        return false;
    }

    protected boolean isAsync() {
        Task task;
        return this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof Task && (task = (Task)this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition()).isAsync();
    }

    public String toString() {
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Activate PlanItem] ");
        if (planItem.getName() != null) {
            stringBuilder.append(planItem.getName());
            stringBuilder.append(" (");
            stringBuilder.append(planItem.getId());
            stringBuilder.append(") ");
        } else {
            stringBuilder.append(planItem.getId());
        }
        if (this.entryCriterionId != null) {
            stringBuilder.append("via entry criterion ").append(this.entryCriterionId);
        }
        return stringBuilder.toString();
    }
}

