/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.deployer.CmmnDeploymentManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceHelper;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.engine.impl.util.IdentityLinkUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.callback.CallbackData;
import org.flowable.common.engine.impl.callback.RuntimeInstanceStateChangeCallback;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInstanceHelperImpl
implements CaseInstanceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseInstanceHelperImpl.class);

    @Override
    public CaseInstanceEntity startCaseInstance(CaseInstanceBuilder caseInstanceBuilder) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        return this.startCaseInstance(commandContext, this.getCaseDefinition(caseInstanceBuilder, commandContext), caseInstanceBuilder);
    }

    @Override
    public CaseInstanceEntity startCaseInstanceAsync(CaseInstanceBuilder caseInstanceBuilder) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        return this.startCaseInstanceAsync(commandContext, this.getCaseDefinition(caseInstanceBuilder, commandContext), caseInstanceBuilder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CaseDefinition getCaseDefinition(CaseInstanceBuilder caseInstanceBuilder, CommandContext commandContext) {
        CaseDefinition caseDefinition = null;
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        if (caseInstanceBuilder.getCaseDefinitionId() != null) {
            String caseDefinitionId = caseInstanceBuilder.getCaseDefinitionId();
            CaseDefinitionEntityManager definitionEntityManager = cmmnEngineConfiguration.getCaseDefinitionEntityManager();
            if (caseDefinitionId == null || (caseDefinition = (CaseDefinition)definitionEntityManager.findById(caseDefinitionId)) != null) return caseDefinition;
            throw new FlowableObjectNotFoundException("No case definition found for id " + caseDefinitionId, CaseDefinition.class);
        }
        if (caseInstanceBuilder.getCaseDefinitionKey() == null) throw new FlowableIllegalArgumentException("caseDefinitionKey and caseDefinitionId are null");
        String caseDefinitionKey = caseInstanceBuilder.getCaseDefinitionKey();
        CaseDefinitionEntityManager caseDefinitionEntityManager = cmmnEngineConfiguration.getCaseDefinitionEntityManager();
        String tenantId = caseInstanceBuilder.getTenantId();
        if (tenantId == null || "".equals(tenantId)) {
            caseDefinition = caseDefinitionEntityManager.findLatestCaseDefinitionByKey(caseDefinitionKey);
            if (caseDefinition != null) return caseDefinition;
            throw new FlowableObjectNotFoundException("No case definition found for key " + caseDefinitionKey, CaseDefinition.class);
        }
        if ("".equals(tenantId) || (caseDefinition = caseDefinitionEntityManager.findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId)) != null) return caseDefinition;
        if (!caseInstanceBuilder.isFallbackToDefaultTenant() && !cmmnEngineConfiguration.isFallbackToDefaultTenant()) throw new FlowableObjectNotFoundException("Case definition was not found by key '" + caseDefinitionKey + "' and tenant '" + tenantId + "'");
        if (StringUtils.isNotEmpty((CharSequence)cmmnEngineConfiguration.getDefaultTenantValue())) {
            caseDefinition = caseDefinitionEntityManager.findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, cmmnEngineConfiguration.getDefaultTenantValue());
            caseInstanceBuilder.overrideCaseDefinitionTenantId(tenantId);
        } else {
            caseDefinition = caseDefinitionEntityManager.findLatestCaseDefinitionByKey(caseDefinitionKey);
        }
        if (caseDefinition != null) return caseDefinition;
        throw new FlowableObjectNotFoundException("Case definition was not found by key '" + caseDefinitionKey + "'. Fallback to default tenant was also used.");
    }

    protected CaseInstanceEntity startCaseInstance(CommandContext commandContext, CaseDefinition caseDefinition, CaseInstanceBuilder caseInstanceBuilder) {
        CaseInstanceEntity caseInstanceEntity = this.initializeCaseInstanceEntity(commandContext, caseDefinition, caseInstanceBuilder);
        CommandContextUtil.getAgenda(commandContext).planInitPlanModelOperation(caseInstanceEntity);
        return caseInstanceEntity;
    }

    protected CaseInstanceEntity startCaseInstanceAsync(CommandContext commandContext, CaseDefinition caseDefinition, CaseInstanceBuilder caseInstanceBuilder) {
        CaseInstanceEntity caseInstanceEntity = this.initializeCaseInstanceEntity(commandContext, caseDefinition, caseInstanceBuilder);
        JobService jobService = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getJobServiceConfiguration().getJobService();
        this.createAsyncInitJob(caseInstanceEntity, jobService);
        return caseInstanceEntity;
    }

    protected void createAsyncInitJob(CaseInstance caseInstance, JobService jobService) {
        JobEntity job = jobService.createJob();
        job.setJobHandlerType("cmmn-async-init-plan-model-instance");
        job.setScopeId(caseInstance.getId());
        job.setScopeDefinitionId(caseInstance.getCaseDefinitionId());
        job.setScopeType("cmmn");
        job.setJobHandlerConfiguration(caseInstance.getId());
        job.setTenantId(caseInstance.getTenantId());
        jobService.createAsyncJob(job, true);
        jobService.scheduleAsyncJob(job);
    }

    protected CaseInstanceEntity initializeCaseInstanceEntity(CommandContext commandContext, CaseDefinition caseDefinition, CaseInstanceBuilder caseInstanceBuilder) {
        CaseInstanceEntity caseInstanceEntity = this.createCaseInstanceEntityFromDefinition(commandContext, caseDefinition);
        this.applyCaseInstanceBuilder(caseInstanceBuilder, caseInstanceEntity, caseDefinition, commandContext);
        this.callCaseInstanceStateChangeCallbacks(commandContext, caseInstanceEntity, null, "active");
        CommandContextUtil.getCmmnHistoryManager(commandContext).recordCaseInstanceStart(caseInstanceEntity);
        return caseInstanceEntity;
    }

    protected void applyCaseInstanceBuilder(CaseInstanceBuilder caseInstanceBuilder, CaseInstanceEntity caseInstanceEntity, CaseDefinition caseDefinition, CommandContext commandContext) {
        Map startFormVariables;
        Map transientVariables;
        Map variables;
        if (caseInstanceBuilder.getName() != null) {
            caseInstanceEntity.setName(caseInstanceBuilder.getName());
        }
        if (caseInstanceBuilder.getBusinessKey() != null) {
            caseInstanceEntity.setBusinessKey(caseInstanceBuilder.getBusinessKey());
        }
        if (caseInstanceBuilder.getOverrideDefinitionTenantId() != null) {
            caseInstanceEntity.setTenantId(caseInstanceBuilder.getOverrideDefinitionTenantId());
        }
        if (caseInstanceBuilder.getParentId() != null) {
            caseInstanceEntity.setParentId(caseInstanceBuilder.getParentId());
        }
        if (caseInstanceBuilder.getCallbackId() != null) {
            caseInstanceEntity.setCallbackId(caseInstanceBuilder.getCallbackId());
        }
        if (caseInstanceBuilder.getCallbackType() != null) {
            caseInstanceEntity.setCallbackType(caseInstanceBuilder.getCallbackType());
        }
        if ((variables = caseInstanceBuilder.getVariables()) != null) {
            for (Object variableName : variables.keySet()) {
                caseInstanceEntity.setVariable((String)variableName, variables.get(variableName));
            }
        }
        if ((transientVariables = caseInstanceBuilder.getTransientVariables()) != null) {
            for (String variableName : transientVariables.keySet()) {
                caseInstanceEntity.setTransientVariable(variableName, transientVariables.get(variableName));
            }
        }
        if ((startFormVariables = caseInstanceBuilder.getStartFormVariables()) != null || caseInstanceBuilder.getOutcome() != null) {
            FormService formService = CommandContextUtil.getFormService(commandContext);
            CmmnModel cmmnModel = CaseDefinitionUtil.getCmmnModel(caseDefinition.getId());
            Case caze = cmmnModel.getCaseById(caseDefinition.getKey());
            Stage planModel = caze.getPlanModel();
            if (planModel != null && StringUtils.isNotEmpty((CharSequence)planModel.getFormKey())) {
                FormRepositoryService formRepositoryService = CommandContextUtil.getFormRepositoryService(commandContext);
                if (formRepositoryService != null) {
                    FormInfo formInfo = null;
                    if (caseInstanceEntity.getTenantId() == null || "".equals(caseInstanceEntity.getTenantId())) {
                        formInfo = formRepositoryService.getFormModelByKey(planModel.getFormKey());
                    } else {
                        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
                        formInfo = formRepositoryService.getFormModelByKey(planModel.getFormKey(), caseInstanceEntity.getTenantId(), cmmnEngineConfiguration.isFallbackToDefaultTenant());
                    }
                    if (formInfo != null) {
                        Map formVariables = formService.getVariablesFromFormSubmission(formInfo, startFormVariables, caseInstanceBuilder.getOutcome());
                        for (String variableName : startFormVariables.keySet()) {
                            caseInstanceEntity.setVariable(variableName, startFormVariables.get(variableName));
                        }
                        formService.createFormInstanceWithScopeId(formVariables, formInfo, null, caseInstanceEntity.getId(), "cmmn", caseInstanceEntity.getCaseDefinitionId(), caseInstanceEntity.getTenantId());
                        FormFieldHandler formFieldHandler = CommandContextUtil.getCmmnEngineConfiguration().getFormFieldHandler();
                        formFieldHandler.handleFormFieldsOnSubmit(formInfo, null, null, caseInstanceEntity.getId(), "cmmn", formVariables, caseInstanceEntity.getTenantId());
                    }
                } else {
                    LOGGER.warn("Requesting form model {} without configured formRepositoryService", (Object)planModel.getFormKey());
                }
            }
        }
    }

    protected CaseInstanceEntity createCaseInstanceEntityFromDefinition(CommandContext commandContext, CaseDefinition caseDefinition) {
        CaseInstanceEntityManager caseInstanceEntityManager = CommandContextUtil.getCaseInstanceEntityManager(commandContext);
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)caseInstanceEntityManager.create();
        caseInstanceEntity.setCaseDefinitionId(caseDefinition.getId());
        caseInstanceEntity.setStartTime(CommandContextUtil.getCmmnEngineConfiguration(commandContext).getClock().getCurrentTime());
        caseInstanceEntity.setState("active");
        caseInstanceEntity.setTenantId(caseDefinition.getTenantId());
        String authenticatedUserId = Authentication.getAuthenticatedUserId();
        caseInstanceEntity.setStartUserId(authenticatedUserId);
        caseInstanceEntityManager.insert(caseInstanceEntity);
        if (authenticatedUserId != null) {
            IdentityLinkUtil.createCaseInstanceIdentityLink(caseInstanceEntity, authenticatedUserId, null, "starter");
        }
        caseInstanceEntity.setSatisfiedSentryPartInstances(new ArrayList(1));
        CmmnDeploymentManager deploymentManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getDeploymentManager();
        CmmnModel cmmnModel = deploymentManager.resolveCaseDefinition(caseDefinition).getCmmnModel();
        Case caseModel = cmmnModel.getCaseById(caseDefinition.getKey());
        if (caseModel.getInitiatorVariableName() != null) {
            caseInstanceEntity.setVariable(caseModel.getInitiatorVariableName(), Authentication.getAuthenticatedUserId());
        }
        return caseInstanceEntity;
    }

    @Override
    public void callCaseInstanceStateChangeCallbacks(CommandContext commandContext, CaseInstance caseInstance, String oldState, String newState) {
        Map<String, List<RuntimeInstanceStateChangeCallback>> caseInstanceCallbacks;
        if (caseInstance.getCallbackId() != null && caseInstance.getCallbackType() != null && (caseInstanceCallbacks = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getCaseInstanceStateChangeCallbacks()) != null && caseInstanceCallbacks.containsKey(caseInstance.getCallbackType())) {
            for (RuntimeInstanceStateChangeCallback caseInstanceCallback : caseInstanceCallbacks.get(caseInstance.getCallbackType())) {
                CallbackData callBackData = new CallbackData(caseInstance.getCallbackId(), caseInstance.getCallbackType(), caseInstance.getId(), oldState, newState);
                caseInstanceCallback.stateChanged(callBackData);
            }
        }
    }
}

