/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.callback;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.process.ProcessInstanceService;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.callback.CallbackData;
import org.flowable.common.engine.impl.callback.RuntimeInstanceStateChangeCallback;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class ChildBpmnCaseInstanceStateChangeCallback
implements RuntimeInstanceStateChangeCallback {
    public void stateChanged(CallbackData callbackData) {
        if ("terminated".equals(callbackData.getNewState()) || "completed".equals(callbackData.getNewState())) {
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            CaseInstanceEntity caseInstance = (CaseInstanceEntity)cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(callbackData.getInstanceId());
            ProcessInstanceService processInstanceService = cmmnEngineConfiguration.getProcessInstanceService();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            for (IOParameter ioParameter : processInstanceService.getOutputParametersOfCaseTask(callbackData.getCallbackId())) {
                Object value = null;
                if (StringUtils.isNotEmpty((CharSequence)ioParameter.getSourceExpression())) {
                    Expression expression = cmmnEngineConfiguration.getExpressionManager().createExpression(ioParameter.getSourceExpression().trim());
                    value = expression.getValue((VariableContainer)caseInstance);
                } else {
                    value = caseInstance.getVariable(ioParameter.getSource());
                }
                variables.put(ioParameter.getTarget(), value);
            }
            processInstanceService.triggerCaseTask(callbackData.getCallbackId(), variables);
        }
    }
}

