/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.configurator.impl.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.CaseServiceTask;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.cmmn.engine.impl.process.ProcessInstanceService;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.TriggerCaseTaskCmd;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceBuilder;

public class DefaultProcessInstanceService
implements ProcessInstanceService {
    private static final String DELETE_REASON = "deletedFromCmmnCase";
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultProcessInstanceService(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public String generateNewProcessInstanceId() {
        if (this.processEngineConfiguration.isUsePrefixId()) {
            return "PRC-" + this.processEngineConfiguration.getIdGenerator().getNextId();
        }
        return this.processEngineConfiguration.getIdGenerator().getNextId();
    }

    public String startProcessInstanceByKey(String processDefinitionKey, String predefinedProcessInstanceId, String tenantId, Boolean fallbackToDefaultTenant, Map<String, Object> inParametersMap) {
        return this.startProcessInstanceByKey(processDefinitionKey, predefinedProcessInstanceId, null, tenantId, fallbackToDefaultTenant, inParametersMap);
    }

    public String startProcessInstanceByKey(String processDefinitionKey, String predefinedProcessInstanceId, String planItemInstanceId, String tenantId, Boolean fallbackToDefaultTenant, Map<String, Object> inParametersMap) {
        ProcessInstanceBuilder processInstanceBuilder = this.processEngineConfiguration.getRuntimeService().createProcessInstanceBuilder();
        processInstanceBuilder.processDefinitionKey(processDefinitionKey);
        if (tenantId != null) {
            processInstanceBuilder.tenantId(tenantId);
            processInstanceBuilder.overrideProcessDefinitionTenantId(tenantId);
        }
        processInstanceBuilder.predefineProcessInstanceId(predefinedProcessInstanceId);
        if (planItemInstanceId != null) {
            processInstanceBuilder.callbackId(planItemInstanceId);
            processInstanceBuilder.callbackType("cmmn-1.1-to-bpmn-2.0-child-process");
        }
        for (String target : inParametersMap.keySet()) {
            processInstanceBuilder.variable(target, inParametersMap.get(target));
        }
        if (fallbackToDefaultTenant != null && fallbackToDefaultTenant.booleanValue()) {
            processInstanceBuilder.fallbackToDefaultTenant();
        }
        ProcessInstance processInstance = processInstanceBuilder.start();
        return processInstance.getId();
    }

    public void triggerCaseTask(String executionId, Map<String, Object> variables) {
        this.processEngineConfiguration.getCommandExecutor().execute((Command)new TriggerCaseTaskCmd(executionId, variables));
    }

    public List<org.flowable.cmmn.model.IOParameter> getOutputParametersOfCaseTask(String executionId) {
        ExecutionEntity execution = (ExecutionEntity)this.processEngineConfiguration.getExecutionEntityManager().findById(executionId);
        if (execution == null) {
            throw new FlowableException("No execution could be found for id " + executionId);
        }
        FlowElement flowElement = execution.getCurrentFlowElement();
        if (!(flowElement instanceof CaseServiceTask)) {
            throw new FlowableException("No execution could be found with a case service task for id " + executionId);
        }
        ArrayList<org.flowable.cmmn.model.IOParameter> cmmnParameters = new ArrayList<org.flowable.cmmn.model.IOParameter>();
        CaseServiceTask caseServiceTask = (CaseServiceTask)flowElement;
        List parameters = caseServiceTask.getOutParameters();
        for (IOParameter ioParameter : parameters) {
            org.flowable.cmmn.model.IOParameter parameter = new org.flowable.cmmn.model.IOParameter();
            parameter.setSource(ioParameter.getSource());
            parameter.setSourceExpression(ioParameter.getSourceExpression());
            parameter.setTarget(ioParameter.getTarget());
            parameter.setTargetExpression(ioParameter.getTargetExpression());
            cmmnParameters.add(parameter);
        }
        return cmmnParameters;
    }

    public void deleteProcessInstance(String processInstanceId) {
        this.processEngineConfiguration.getCommandExecutor().execute(commandContext -> {
            ExecutionEntity processInstanceEntity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager((CommandContext)commandContext).findById(processInstanceId);
            if (processInstanceEntity == null || processInstanceEntity.isDeleted()) {
                return null;
            }
            CommandContextUtil.getExecutionEntityManager((CommandContext)commandContext).deleteProcessInstance(processInstanceEntity.getProcessInstanceId(), DELETE_REASON, false);
            return null;
        });
    }

    public Object getVariable(String executionId, String variableName) {
        return this.processEngineConfiguration.getRuntimeService().getVariable(executionId, variableName);
    }

    public Map<String, Object> getVariables(String executionId) {
        return this.processEngineConfiguration.getRuntimeService().getVariables(executionId);
    }

    public Object resolveExpression(String executionId, String expressionString) {
        Expression expression = this.processEngineConfiguration.getExpressionManager().createExpression(expressionString);
        return this.processEngineConfiguration.getCommandExecutor().execute(commandContext -> {
            ExecutionEntity executionEntity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager((CommandContext)commandContext).findById(executionId);
            return expression.getValue((VariableContainer)executionEntity);
        });
    }
}

