/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import javax.xml.stream.XMLStreamReader;
import org.flowable.cmmn.converter.CaseElementXmlConverter;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.PlanItemControl;
import org.flowable.cmmn.model.RepetitionRule;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;

public class RepetitionRuleXmlConverter
extends CaseElementXmlConverter {
    @Override
    public String getXMLElementName() {
        return "repetitionRule";
    }

    @Override
    public boolean hasChildElements() {
        return true;
    }

    protected CmmnElement convert(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        if (conversionHelper.getCurrentCmmnElement() instanceof PlanItemControl) {
            String maxInstanceCountValue;
            RepetitionRule repetitionRule = new RepetitionRule();
            repetitionRule.setName(xtr.getAttributeValue(null, "name"));
            repetitionRule.setRepetitionCounterVariableName(xtr.getAttributeValue("http://flowable.org/cmmn", "counterVariable"));
            String ignoreRepetitionCounterVariableValue = xtr.getAttributeValue("http://flowable.org/cmmn", "ignoreCounterVariable");
            if ("true".equalsIgnoreCase(ignoreRepetitionCounterVariableValue)) {
                repetitionRule.setIgnoreRepetitionCounterVariable(true);
            }
            if ((maxInstanceCountValue = xtr.getAttributeValue("http://flowable.org/cmmn", "maxInstanceCount")) == null) {
                repetitionRule.setMaxInstanceCount(null);
            } else if ("unlimited".equals(maxInstanceCountValue)) {
                repetitionRule.setMaxInstanceCount(RepetitionRule.MAX_INSTANCE_COUNT_UNLIMITED);
            } else {
                int maxInstanceCount = Integer.parseInt(maxInstanceCountValue);
                if (maxInstanceCount == 0) {
                    throw new FlowableIllegalArgumentException("A 'maxInstanceCount' on a repetition rule with value '0' is not allowed, either set it to '-1' or 'unlimited' or any other positive value..");
                }
                repetitionRule.setMaxInstanceCount(Integer.valueOf(maxInstanceCount));
            }
            repetitionRule.setCollectionVariableName(xtr.getAttributeValue("http://flowable.org/cmmn", "collectionVariable"));
            repetitionRule.setElementVariableName(xtr.getAttributeValue("http://flowable.org/cmmn", "elementVariable"));
            repetitionRule.setElementIndexVariableName(xtr.getAttributeValue("http://flowable.org/cmmn", "elementIndexVariable"));
            PlanItemControl planItemControl = (PlanItemControl)conversionHelper.getCurrentCmmnElement();
            planItemControl.setRepetitionRule(repetitionRule);
            return repetitionRule;
        }
        return null;
    }

    protected Integer parseInt(String value) {
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }
}

