/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.util.CriterionUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CmmnDiEdge;
import org.flowable.cmmn.model.CmmnDiShape;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.HasEntryCriteria;
import org.flowable.cmmn.model.HasExitCriteria;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.SentryIfPart;
import org.flowable.cmmn.model.SentryOnPart;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableException;

public class ConversionHelper {
    protected CmmnModel cmmnModel;
    protected Case currentCase;
    protected LinkedList<CmmnElement> currentCmmnElements = new LinkedList();
    protected LinkedList<PlanFragment> planFragmentsStack = new LinkedList();
    protected LinkedList<Stage> stagesStack = new LinkedList();
    protected Sentry currentSentry;
    protected SentryOnPart currentSentryOnPart;
    protected PlanItem currentPlanItem;
    protected CmmnDiShape currentDiShape;
    protected CmmnDiEdge currentDiEdge;
    protected GraphicInfo currentLabelGraphicInfo;
    protected Map<Case, List<CaseElement>> caseElements = new HashMap<Case, List<CaseElement>>();
    protected List<Stage> stages = new ArrayList<Stage>();
    protected List<PlanFragment> planFragments = new ArrayList<PlanFragment>();
    protected List<Criterion> entryCriteria = new ArrayList<Criterion>();
    protected List<Criterion> exitCriteria = new ArrayList<Criterion>();
    protected List<Sentry> sentries = new ArrayList<Sentry>();
    protected List<SentryOnPart> sentryOnParts = new ArrayList<SentryOnPart>();
    protected List<SentryIfPart> sentryIfParts = new ArrayList<SentryIfPart>();
    protected List<PlanItem> planItems = new ArrayList<PlanItem>();
    protected List<PlanItemDefinition> planItemDefinitions = new ArrayList<PlanItemDefinition>();
    protected List<CmmnDiShape> diShapes = new ArrayList<CmmnDiShape>();
    protected List<CmmnDiEdge> diEdges = new ArrayList<CmmnDiEdge>();

    public void addCaseElement(CaseElement caseElement) {
        if (!this.caseElements.containsKey(this.currentCase)) {
            this.caseElements.put(this.currentCase, new ArrayList());
        }
        this.caseElements.get(this.currentCase).add(caseElement);
    }

    public Map<Case, List<CaseElement>> getCaseElements() {
        return this.caseElements;
    }

    public void setCaseElements(Map<Case, List<CaseElement>> caseElements) {
        this.caseElements = caseElements;
    }

    public void addStage(Stage stage) {
        this.stages.add(stage);
    }

    public void addPlanFragment(PlanFragment planFragment) {
        this.planFragments.add(planFragment);
    }

    public void addEntryCriterion(Criterion entryCriterion) {
        this.entryCriteria.add(entryCriterion);
    }

    public void addEntryCriterionToCurrentElement(Criterion entryCriterion) {
        this.addEntryCriterion(entryCriterion);
        ListIterator<CmmnElement> iterator = this.currentCmmnElements.listIterator(this.currentCmmnElements.size());
        HasEntryCriteria hasEntryCriteria = null;
        while (hasEntryCriteria == null && iterator.hasPrevious()) {
            CmmnElement cmmnElement = iterator.previous();
            if (!(cmmnElement instanceof HasEntryCriteria)) continue;
            hasEntryCriteria = (HasEntryCriteria)cmmnElement;
        }
        if (hasEntryCriteria != null) {
            if (StringUtils.isEmpty((CharSequence)entryCriterion.getId())) {
                entryCriterion.setId(CriterionUtil.generateEntryCriterionId(hasEntryCriteria));
            }
        } else {
            throw new FlowableException("Cannot add an entry criteria " + entryCriterion.getId() + " no matching plan item found to attach it to");
        }
        entryCriterion.setAttachedToRefId(hasEntryCriteria.getId());
        hasEntryCriteria.getEntryCriteria().add(entryCriterion);
    }

    public void addExitCriterion(Criterion exitCriterion) {
        this.exitCriteria.add(exitCriterion);
    }

    public void addExitCriteriaToCurrentElement(Criterion exitCriterion) {
        this.addExitCriterion(exitCriterion);
        ListIterator<CmmnElement> iterator = this.currentCmmnElements.listIterator(this.currentCmmnElements.size());
        Stage hasExitCriteria = null;
        while (hasExitCriteria == null && iterator.hasPrevious()) {
            CmmnElement cmmnElement = iterator.previous();
            if (!(cmmnElement instanceof HasExitCriteria)) continue;
            hasExitCriteria = (HasExitCriteria)cmmnElement;
        }
        if (hasExitCriteria == null) {
            hasExitCriteria = this.getCurrentCase().getPlanModel();
        }
        if (StringUtils.isEmpty((CharSequence)exitCriterion.getId())) {
            exitCriterion.setId(CriterionUtil.generateExitCriterionId((HasExitCriteria)hasExitCriteria));
        }
        exitCriterion.setAttachedToRefId(hasExitCriteria.getId());
        hasExitCriteria.getExitCriteria().add(exitCriterion);
    }

    public void addSentry(Sentry sentry) {
        this.sentries.add(sentry);
    }

    public void addSentryToCurrentPlanFragment(Sentry sentry) {
        this.addSentry(sentry);
        this.setCurrentSentry(sentry);
        this.getCurrentPlanFragment().addSentry(sentry);
    }

    public void addSentryOnPart(SentryOnPart sentryOnPart) {
        this.sentryOnParts.add(sentryOnPart);
    }

    public void addSentryOnPartToCurrentSentry(SentryOnPart sentryOnPart) {
        this.addSentryOnPart(sentryOnPart);
        this.getCurrentSentry().addSentryOnPart(sentryOnPart);
        this.setCurrentSentryOnPart(sentryOnPart);
    }

    public void addSentryIfPart(SentryIfPart sentryIfPart) {
        this.sentryIfParts.add(sentryIfPart);
    }

    public void addSentryIfPartToCurrentSentry(SentryIfPart sentryIfPart) {
        this.addSentryIfPart(sentryIfPart);
        this.getCurrentSentry().setSentryIfPart(sentryIfPart);
    }

    public void addPlanItem(PlanItem planItem) {
        this.planItems.add(planItem);
    }

    public void addPlanItemToCurrentPlanFragment(PlanItem planItem) {
        this.addPlanItem(planItem);
        this.getCurrentPlanFragment().addPlanItem(planItem);
        this.setCurrentPlanItem(planItem);
    }

    public void addPlanItemDefinition(PlanItemDefinition planItemDefinition) {
        this.planItemDefinitions.add(planItemDefinition);
    }

    public void addDiShape(CmmnDiShape diShape) {
        this.diShapes.add(diShape);
        this.setCurrentDiShape(diShape);
    }

    public void addDiEdge(CmmnDiEdge diEdge) {
        this.diEdges.add(diEdge);
        this.setCurrentDiEdge(diEdge);
    }

    public Optional<PlanItem> findPlanItem(String planItemId) {
        return this.planItems.stream().filter(planItem -> planItem.getId().equals(planItemId)).findFirst();
    }

    public CmmnModel getCmmnModel() {
        return this.cmmnModel;
    }

    public void setCmmnModel(CmmnModel cmmnModel) {
        this.cmmnModel = cmmnModel;
    }

    public Case getCurrentCase() {
        return this.currentCase;
    }

    public void setCurrentCase(Case currentCase) {
        this.currentCase = currentCase;
    }

    public CmmnElement getCurrentCmmnElement() {
        return this.currentCmmnElements.peekLast();
    }

    public PlanFragment getCurrentPlanFragment() {
        return this.planFragmentsStack.peekLast();
    }

    public void setCurrentPlanFragment(PlanFragment currentPlanFragment) {
        if (currentPlanFragment != null) {
            this.planFragmentsStack.add(currentPlanFragment);
        }
    }

    public void removeCurrentPlanFragment() {
        this.planFragmentsStack.removeLast();
    }

    public Stage getCurrentStage() {
        return this.stagesStack.peekLast();
    }

    public void setCurrentStage(Stage currentStage) {
        if (currentStage != null) {
            this.stagesStack.add(currentStage);
            this.setCurrentPlanFragment((PlanFragment)currentStage);
        }
    }

    public void removeCurrentStage() {
        this.stagesStack.removeLast();
        this.removeCurrentPlanFragment();
    }

    public void setCurrentCmmnElement(CmmnElement currentCmmnElement) {
        this.currentCmmnElements.add(currentCmmnElement);
    }

    public void removeCurrentCmmnElement() {
        this.currentCmmnElements.removeLast();
    }

    public Sentry getCurrentSentry() {
        return this.currentSentry;
    }

    public void setCurrentSentry(Sentry currentSentry) {
        this.currentSentry = currentSentry;
    }

    public SentryOnPart getCurrentSentryOnPart() {
        return this.currentSentryOnPart;
    }

    public void setCurrentSentryOnPart(SentryOnPart currentSentryOnPart) {
        this.currentSentryOnPart = currentSentryOnPart;
    }

    public PlanItem getCurrentPlanItem() {
        return this.currentPlanItem;
    }

    public void setCurrentPlanItem(PlanItem currentPlanItem) {
        this.currentPlanItem = currentPlanItem;
    }

    public CmmnDiShape getCurrentDiShape() {
        return this.currentDiShape;
    }

    public void setCurrentDiShape(CmmnDiShape currentDiShape) {
        this.currentDiShape = currentDiShape;
    }

    public CmmnDiEdge getCurrentDiEdge() {
        return this.currentDiEdge;
    }

    public void setCurrentDiEdge(CmmnDiEdge currentDiEdge) {
        this.currentDiEdge = currentDiEdge;
    }

    public List<Stage> getStages() {
        return this.stages;
    }

    public List<PlanFragment> getPlanFragments() {
        return this.planFragments;
    }

    public List<Criterion> getEntryCriteria() {
        return this.entryCriteria;
    }

    public List<Criterion> getExitCriteria() {
        return this.exitCriteria;
    }

    public List<Sentry> getSentries() {
        return this.sentries;
    }

    public List<SentryOnPart> getSentryOnParts() {
        return this.sentryOnParts;
    }

    public List<SentryIfPart> getSentryIfParts() {
        return this.sentryIfParts;
    }

    public List<PlanItem> getPlanItems() {
        return this.planItems;
    }

    public List<PlanItemDefinition> getPlanItemDefinitions() {
        return this.planItemDefinitions;
    }

    public List<CmmnDiShape> getDiShapes() {
        return this.diShapes;
    }

    public List<CmmnDiEdge> getDiEdges() {
        return this.diEdges;
    }

    public GraphicInfo getCurrentLabelGraphicInfo() {
        return this.currentLabelGraphicInfo;
    }

    public void setCurrentLabelGraphicInfo(GraphicInfo labelGraphicInfo) {
        this.currentLabelGraphicInfo = labelGraphicInfo;
    }
}

