/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter;

import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.BaseCmmnXmlConverter;
import org.flowable.cmmn.converter.ConversionHelper;
import org.flowable.cmmn.converter.util.CmmnXmlUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnElement;

public class CaseXmlConverter
extends BaseCmmnXmlConverter {
    @Override
    public String getXMLElementName() {
        return "case";
    }

    @Override
    public boolean hasChildElements() {
        return true;
    }

    protected CmmnElement convert(XMLStreamReader xtr, ConversionHelper conversionHelper) {
        String candidateGroupsString;
        Case caze = new Case();
        caze.setName(xtr.getAttributeValue(null, "name"));
        caze.setInitiatorVariableName(xtr.getAttributeValue("http://flowable.org/cmmn", "initiatorVariableName"));
        String candidateUsersString = CmmnXmlUtil.getAttributeValue("candidateStarterUsers", xtr);
        if (StringUtils.isNotEmpty((CharSequence)candidateUsersString)) {
            List<String> candidateUsers = CmmnXmlUtil.parseDelimitedList(candidateUsersString);
            caze.setCandidateStarterUsers(candidateUsers);
        }
        if (StringUtils.isNotEmpty((CharSequence)(candidateGroupsString = CmmnXmlUtil.getAttributeValue("candidateStarterGroups", xtr)))) {
            List<String> candidateGroups = CmmnXmlUtil.parseDelimitedList(candidateGroupsString);
            caze.setCandidateStarterGroups(candidateGroups);
        }
        if ("true".equals(xtr.getAttributeValue("http://flowable.org/cmmn", "async"))) {
            caze.setAsync(true);
        }
        conversionHelper.getCmmnModel().addCase(caze);
        conversionHelper.setCurrentCase(caze);
        return caze;
    }
}

