/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.converter.export.PlanItemDefinitionExport;
import org.flowable.cmmn.converter.export.PlanItemExport;
import org.flowable.cmmn.converter.export.SentryExport;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.Stage;

public class StageExport
implements CmmnXmlConstants {
    public static void writeStage(Stage stage, XMLStreamWriter xtw) throws Exception {
        if (stage.isPlanModel()) {
            xtw.writeStartElement("casePlanModel");
        } else {
            xtw.writeStartElement("stage");
        }
        xtw.writeAttribute("id", stage.getId());
        if (StringUtils.isNotEmpty((CharSequence)stage.getName())) {
            xtw.writeAttribute("name", stage.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)stage.getDocumentation())) {
            xtw.writeStartElement("documentation");
            xtw.writeCharacters(stage.getDocumentation());
            xtw.writeEndElement();
        }
        for (PlanItem planItem : stage.getPlanItems()) {
            PlanItemExport.writePlanItem(planItem, xtw);
        }
        for (Sentry sentry : stage.getSentries()) {
            SentryExport.writeSentry(sentry, xtw);
        }
        for (PlanItemDefinition planItemDefinition : stage.getPlanItemDefinitions()) {
            PlanItemDefinitionExport.writePlanItemDefinition(planItemDefinition, xtw);
        }
        if (stage.isPlanModel() && stage.getExitCriteria() != null && !stage.getExitCriteria().isEmpty()) {
            for (Criterion exitCriterion : stage.getExitCriteria()) {
                xtw.writeStartElement("exitCriterion");
                xtw.writeAttribute("id", exitCriterion.getId());
                if (StringUtils.isNotEmpty((CharSequence)exitCriterion.getName())) {
                    xtw.writeAttribute("name", exitCriterion.getName());
                }
                if (StringUtils.isNotEmpty((CharSequence)exitCriterion.getSentryRef())) {
                    xtw.writeAttribute("sentryRef", exitCriterion.getSentryRef());
                }
                xtw.writeEndElement();
            }
        }
        xtw.writeEndElement();
    }
}

