/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.model.Sentry;
import org.flowable.cmmn.model.SentryOnPart;

public class SentryExport
implements CmmnXmlConstants {
    public static void writeSentry(Sentry sentry, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("sentry");
        xtw.writeAttribute("id", sentry.getId());
        if (StringUtils.isNotEmpty((CharSequence)sentry.getName())) {
            xtw.writeAttribute("name", sentry.getName());
        }
        for (SentryOnPart sentryOnPart : sentry.getOnParts()) {
            xtw.writeStartElement("planItemOnPart");
            xtw.writeAttribute("id", sentryOnPart.getId());
            xtw.writeAttribute("sourceRef", sentryOnPart.getSourceRef());
            xtw.writeStartElement("standardEvent");
            xtw.writeCharacters(sentryOnPart.getStandardEvent());
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
        if (sentry.getSentryIfPart() != null) {
            xtw.writeStartElement("ifPart");
            xtw.writeStartElement("condition");
            xtw.writeCData(sentry.getSentryIfPart().getCondition());
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
        xtw.writeEndElement();
    }
}

