/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.flowable.app.api.AppManagementService;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.engine.AppEngine;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.impl.cfg.StandaloneInMemAppEngineConfiguration;
import org.flowable.app.engine.test.impl.AppTestRunner;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=AppTestRunner.class)
public abstract class FlowableAppTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableAppTestCase.class);
    public static final String FLOWABLE_APP_CFG_XML = "flowable.app.cfg.xml";
    protected AppEngineConfiguration appEngineConfiguration;
    protected AppManagementService appManagementService;
    protected AppRepositoryService appRepositoryService;
    protected String deploymentId;

    @BeforeClass
    public static void setupEngine() {
        if (AppTestRunner.getAppEngineConfiguration() == null) {
            FlowableAppTestCase.initAppEngine();
        }
    }

    protected static void initAppEngine() {
        try (InputStream inputStream = FlowableAppTestCase.class.getClassLoader().getResourceAsStream(FLOWABLE_APP_CFG_XML);){
            AppEngine cmmnEngine = null;
            if (inputStream != null) {
                cmmnEngine = AppEngineConfiguration.createAppEngineConfigurationFromInputStream(inputStream).buildAppEngine();
            } else {
                LOGGER.info("No {} configuration found. Using default in-memory standalone configuration.", (Object)FLOWABLE_APP_CFG_XML);
                cmmnEngine = new StandaloneInMemAppEngineConfiguration().buildAppEngine();
            }
            AppTestRunner.setAppEngineConfiguration(cmmnEngine.getAppEngineConfiguration());
        }
        catch (IOException e) {
            LOGGER.error("Could not create App engine", (Throwable)e);
        }
    }

    @Before
    public void setupServices() {
        AppEngineConfiguration appEngineConfiguration;
        this.appEngineConfiguration = appEngineConfiguration = AppTestRunner.getAppEngineConfiguration();
        this.appRepositoryService = appEngineConfiguration.getAppRepositoryService();
        this.appManagementService = appEngineConfiguration.getAppManagementService();
    }

    @After
    public void cleanupDeployment() {
        if (this.deploymentId != null) {
            this.appRepositoryService.deleteDeployment(this.deploymentId, true);
        }
    }

    protected Date setClockFixedToCurrentTime() {
        Date date = new Date();
        this.appEngineConfiguration.getClock().setCurrentTime(date);
        return date;
    }

    protected void setClockTo(Date date) {
        this.appEngineConfiguration.getClock().setCurrentTime(date);
    }
}

