/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.rest.AppRestApiInterceptor;
import org.flowable.app.rest.AppRestResponseFactory;
import org.flowable.app.rest.service.api.repository.AppDefinitionActionRequest;
import org.flowable.app.rest.service.api.repository.AppDefinitionResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"App Definitions"}, description="Manage App Definitions", authorizations={@Authorization(value="basicAuth")})
public class AppDefinitionResource {
    @Autowired
    protected AppRestResponseFactory appRestResponseFactory;
    @Autowired
    protected AppRepositoryService appRepositoryService;
    @Autowired(required=false)
    protected AppRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get a app definition", tags={"App Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the app definition was found returned."), @ApiResponse(code=404, message="Indicates the app definition was not found.")})
    @GetMapping(value={"/app-repository/app-definitions/{appDefinitionId}"}, produces={"application/json"})
    public AppDefinitionResponse getAppDefinition(@ApiParam(name="appDefinitionId") @PathVariable String appDefinitionId, HttpServletRequest request) {
        AppDefinition appDefinition = this.appRepositoryService.getAppDefinition(appDefinitionId);
        if (appDefinition == null) {
            throw new FlowableObjectNotFoundException("Could not find an app definition with id '" + appDefinitionId);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessAppDefinitionInfoById(appDefinition);
        }
        return this.appRestResponseFactory.createAppDefinitionResponse(appDefinition);
    }

    @ApiOperation(value="Execute actions for an app definition", tags={"App Definitions"}, notes="Execute actions for an app definition (Update category)")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates action has been executed for the specified app definition. (category altered)"), @ApiResponse(code=400, message="Indicates no category was defined in the request body."), @ApiResponse(code=404, message="Indicates the requested app definition was not found.")})
    @PutMapping(value={"/app-repository/app-definitions/{appDefinitionId}"}, produces={"application/json"})
    public AppDefinitionResponse executeAppDefinitionAction(@ApiParam(name="appDefinitionId") @PathVariable String appDefinitionId, @ApiParam(required=true) @RequestBody AppDefinitionActionRequest actionRequest, HttpServletRequest request) {
        if (actionRequest == null) {
            throw new FlowableIllegalArgumentException("No action found in request body.");
        }
        AppDefinition appDefinition = this.appRepositoryService.getAppDefinition(appDefinitionId);
        if (appDefinition == null) {
            throw new FlowableObjectNotFoundException("Could not find an app definition with id '" + appDefinitionId + "'.", AppDefinition.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessAppDefinitionInfoById(appDefinition);
        }
        if (actionRequest.getCategory() != null) {
            this.appRepositoryService.setAppDefinitionCategory(appDefinition.getId(), actionRequest.getCategory());
            AppDefinitionResponse response = this.appRestResponseFactory.createAppDefinitionResponse(appDefinition);
            response.setCategory(actionRequest.getCategory());
            return response;
        }
        throw new FlowableIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
    }
}

