/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.signer;

import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.transaction.signer.AsyncTransactionSignercInterface;
import org.fisco.bcos.sdk.transaction.signer.RemoteSignCallbackInterface;
import org.fisco.bcos.sdk.transaction.signer.RemoteSignProviderInterface;
import org.fisco.bcos.sdk.transaction.signer.TransactionSignerInterface;

public class TransactionSignerWithRemoteSignService
implements TransactionSignerInterface,
AsyncTransactionSignercInterface {
    private RemoteSignProviderInterface transactionSignProvider;
    private int encryptType;

    public TransactionSignerWithRemoteSignService(RemoteSignProviderInterface transactionSignProvider, int encryptType) {
        this.transactionSignProvider = transactionSignProvider;
        this.encryptType = encryptType;
    }

    @Override
    public SignatureResult sign(String rawTxHash, CryptoKeyPair cryptoKeyPair) {
        return this.sign(rawTxHash.getBytes(), cryptoKeyPair);
    }

    @Override
    public SignatureResult sign(byte[] rawTxHash, CryptoKeyPair cryptoKeyPair) {
        return this.transactionSignProvider.requestForSign(rawTxHash, this.encryptType);
    }

    @Override
    public void signAsync(byte[] dataToSign, RemoteSignCallbackInterface transactionSignCallback) {
        this.transactionSignProvider.requestForSignAsync(dataToSign, this.encryptType, transactionSignCallback);
    }
}

