/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto.signature;

import com.webank.blockchain.hsm.crypto.sdf.AlgorithmType;
import com.webank.blockchain.hsm.crypto.sdf.SDF;
import com.webank.blockchain.hsm.crypto.sdf.SDFCryptoResult;
import com.webank.wedpr.crypto.CryptoResult;
import com.webank.wedpr.crypto.NativeInterface;
import org.fisco.bcos.sdk.crypto.exceptions.SignatureException;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.crypto.keypair.SDFSM2KeyPair;
import org.fisco.bcos.sdk.crypto.signature.SM2SignatureResult;
import org.fisco.bcos.sdk.crypto.signature.Signature;
import org.fisco.bcos.sdk.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.utils.Hex;
import org.fisco.bcos.sdk.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDFSM2Signature
implements Signature {
    private static Logger logger = LoggerFactory.getLogger(SDFSM2Signature.class);

    @Override
    public SignatureResult sign(String message, CryptoKeyPair keyPair) {
        return new SM2SignatureResult(keyPair.getHexPublicKey(), this.signWithStringSignature(message, keyPair));
    }

    @Override
    public SignatureResult sign(byte[] message, CryptoKeyPair keyPair) {
        return this.sign(Hex.toHexString(message), keyPair);
    }

    @Override
    public String signWithStringSignature(String message, CryptoKeyPair keyPair) {
        return this.signMessage(message, keyPair);
    }

    public String signMessage(String message, CryptoKeyPair keyPair) {
        SDFSM2KeyPair sdfKeyPair;
        CryptoResult hashResult = NativeInterface.sm2ComputeHashE((String)Numeric.getHexKeyWithPrefix(keyPair.getHexPublicKey(), "04", 128), (String)Numeric.cleanHexPrefix(message));
        SDFSM2Signature.checkCryptoResult(hashResult);
        if (keyPair instanceof SDFSM2KeyPair && (sdfKeyPair = (SDFSM2KeyPair)keyPair).isInternalKey()) {
            SDFCryptoResult signatureResult = SDF.SignWithInternalKey((long)((sdfKeyPair.getKeyIndex() + 1L) / 2L), (String)sdfKeyPair.getPassword(), (AlgorithmType)AlgorithmType.SM2, (String)hashResult.hash);
            SDFSM2Signature.checkSDFCryptoResult(signatureResult);
            return signatureResult.getSignature();
        }
        SDFCryptoResult signatureResult = SDF.Sign((String)Numeric.cleanHexPrefix(keyPair.getHexPrivateKey()), (AlgorithmType)AlgorithmType.SM2, (String)hashResult.hash);
        SDFSM2Signature.checkSDFCryptoResult(signatureResult);
        return signatureResult.getSignature();
    }

    public static void checkCryptoResult(CryptoResult result) {
        if (result.wedprErrorMessage != null && !result.wedprErrorMessage.isEmpty()) {
            throw new SignatureException("Sign with sdf sm2 failed:" + result.wedprErrorMessage);
        }
    }

    public static void checkSDFCryptoResult(SDFCryptoResult result) {
        if (result.getSdfErrorMessage() != null && !result.getSdfErrorMessage().isEmpty()) {
            throw new SignatureException("Sign with sdf sm2 failed:" + result.getSdfErrorMessage());
        }
    }

    @Override
    public boolean verify(String publicKey, String message, String signature) {
        return SDFSM2Signature.verifyMessage(publicKey, message, signature);
    }

    @Override
    public boolean verify(String publicKey, byte[] message, byte[] signature) {
        return this.verify(publicKey, Hex.toHexString(message), Hex.toHexString(signature));
    }

    public static boolean verifyMessage(String publicKey, String message, String signature) {
        CryptoResult hashResult = NativeInterface.sm2ComputeHashE((String)Numeric.cleanHexPrefix(publicKey), (String)Numeric.cleanHexPrefix(message));
        SDFSM2Signature.checkCryptoResult(hashResult);
        SDFCryptoResult verifyResult = SDF.Verify((String)Numeric.getKeyNoPrefix("04", publicKey, 128), (AlgorithmType)AlgorithmType.SM2, (String)hashResult.hash, (String)Numeric.cleanHexPrefix(signature));
        SDFSM2Signature.checkSDFCryptoResult(verifyResult);
        return verifyResult.getResult();
    }
}

