/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.contract.precompiled.permission;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.fisco.bcos.sdk.abi.FunctionReturnDecoder;
import org.fisco.bcos.sdk.abi.TypeReference;
import org.fisco.bcos.sdk.abi.datatypes.Address;
import org.fisco.bcos.sdk.abi.datatypes.Bool;
import org.fisco.bcos.sdk.abi.datatypes.Function;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;
import org.fisco.bcos.sdk.abi.datatypes.generated.Int256;
import org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated.Tuple1;
import org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated.Tuple2;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.contract.Contract;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;

public class ChainGovernancePrecompiled
extends Contract {
    public static final String[] BINARY_ARRAY = new String[0];
    public static final String BINARY = String.join((CharSequence)"", BINARY_ARRAY);
    public static final String[] SM_BINARY_ARRAY = new String[0];
    public static final String SM_BINARY = String.join((CharSequence)"", SM_BINARY_ARRAY);
    public static final String[] ABI_ARRAY = new String[]{"[{\"constant\":true,\"inputs\":[],\"name\":\"listOperators\",\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"user\",\"type\":\"address\"},{\"name\":\"weight\",\"type\":\"int256\"}],\"name\":\"updateCommitteeMemberWeight\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"queryThreshold\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"account\",\"type\":\"address\"}],\"name\":\"queryVotesOfMember\",\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"user\",\"type\":\"address\"}],\"name\":\"queryCommitteeMemberWeight\",\"outputs\":[{\"name\":\"\",\"type\":\"bool\"},{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"user\",\"type\":\"address\"}],\"name\":\"grantCommitteeMember\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"account\",\"type\":\"address\"}],\"name\":\"unfreezeAccount\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"queryVotesOfThreshold\",\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[],\"name\":\"listCommitteeMembers\",\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"threshold\",\"type\":\"int256\"}],\"name\":\"updateThreshold\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"user\",\"type\":\"address\"}],\"name\":\"revokeCommitteeMember\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"user\",\"type\":\"address\"}],\"name\":\"grantOperator\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"account\",\"type\":\"address\"}],\"name\":\"freezeAccount\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"user\",\"type\":\"address\"}],\"name\":\"revokeOperator\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"account\",\"type\":\"address\"}],\"name\":\"getAccountStatus\",\"outputs\":[{\"name\":\"\",\"type\":\"string\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"}]"};
    public static final String ABI = String.join((CharSequence)"", ABI_ARRAY);
    public static final String FUNC_LISTOPERATORS = "listOperators";
    public static final String FUNC_UPDATECOMMITTEEMEMBERWEIGHT = "updateCommitteeMemberWeight";
    public static final String FUNC_QUERYTHRESHOLD = "queryThreshold";
    public static final String FUNC_QUERYVOTESOFMEMBER = "queryVotesOfMember";
    public static final String FUNC_QUERYCOMMITTEEMEMBERWEIGHT = "queryCommitteeMemberWeight";
    public static final String FUNC_GRANTCOMMITTEEMEMBER = "grantCommitteeMember";
    public static final String FUNC_UNFREEZEACCOUNT = "unfreezeAccount";
    public static final String FUNC_QUERYVOTESOFTHRESHOLD = "queryVotesOfThreshold";
    public static final String FUNC_LISTCOMMITTEEMEMBERS = "listCommitteeMembers";
    public static final String FUNC_UPDATETHRESHOLD = "updateThreshold";
    public static final String FUNC_REVOKECOMMITTEEMEMBER = "revokeCommitteeMember";
    public static final String FUNC_GRANTOPERATOR = "grantOperator";
    public static final String FUNC_FREEZEACCOUNT = "freezeAccount";
    public static final String FUNC_REVOKEOPERATOR = "revokeOperator";
    public static final String FUNC_GETACCOUNTSTATUS = "getAccountStatus";

    protected ChainGovernancePrecompiled(String contractAddress, Client client, CryptoKeyPair credential) {
        super(ChainGovernancePrecompiled.getBinary(client.getCryptoSuite()), contractAddress, client, credential);
    }

    public static String getBinary(CryptoSuite cryptoSuite) {
        return cryptoSuite.getCryptoTypeConfig() == 0 ? BINARY : SM_BINARY;
    }

    public String listOperators() throws ContractException {
        Function function = new Function(FUNC_LISTOPERATORS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeCallWithSingleValueReturn(function, String.class);
    }

    public TransactionReceipt updateCommitteeMemberWeight(String user, BigInteger weight) {
        Function function = new Function(FUNC_UPDATECOMMITTEEMEMBERWEIGHT, Arrays.asList(new Address(user), new Int256(weight)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public void updateCommitteeMemberWeight(String user, BigInteger weight, TransactionCallback callback) {
        Function function = new Function(FUNC_UPDATECOMMITTEEMEMBERWEIGHT, Arrays.asList(new Address(user), new Int256(weight)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForUpdateCommitteeMemberWeight(String user, BigInteger weight) {
        Function function = new Function(FUNC_UPDATECOMMITTEEMEMBERWEIGHT, Arrays.asList(new Address(user), new Int256(weight)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple2<String, BigInteger> getUpdateCommitteeMemberWeightInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_UPDATECOMMITTEEMEMBERWEIGHT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple2<String, BigInteger>((String)results.get(0).getValue(), (BigInteger)results.get(1).getValue());
    }

    public Tuple1<BigInteger> getUpdateCommitteeMemberWeightOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_UPDATECOMMITTEEMEMBERWEIGHT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public BigInteger queryThreshold() throws ContractException {
        Function function = new Function(FUNC_QUERYTHRESHOLD, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        return this.executeCallWithSingleValueReturn(function, BigInteger.class);
    }

    public String queryVotesOfMember(String account) throws ContractException {
        Function function = new Function(FUNC_QUERYVOTESOFMEMBER, Arrays.asList(new Address(account)), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeCallWithSingleValueReturn(function, String.class);
    }

    public Tuple2<Boolean, BigInteger> queryCommitteeMemberWeight(String user) throws ContractException {
        Function function = new Function(FUNC_QUERYCOMMITTEEMEMBERWEIGHT, Arrays.asList(new Address(user)), Arrays.asList(new TypeReference<Bool>(){}, new TypeReference<Int256>(){}));
        List<Type> results = this.executeCallWithMultipleValueReturn(function);
        return new Tuple2<Boolean, BigInteger>((Boolean)results.get(0).getValue(), (BigInteger)results.get(1).getValue());
    }

    public TransactionReceipt grantCommitteeMember(String user) {
        Function function = new Function(FUNC_GRANTCOMMITTEEMEMBER, Arrays.asList(new Address(user)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public void grantCommitteeMember(String user, TransactionCallback callback) {
        Function function = new Function(FUNC_GRANTCOMMITTEEMEMBER, Arrays.asList(new Address(user)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForGrantCommitteeMember(String user) {
        Function function = new Function(FUNC_GRANTCOMMITTEEMEMBER, Arrays.asList(new Address(user)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple1<String> getGrantCommitteeMemberInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_GRANTCOMMITTEEMEMBER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<String>((String)results.get(0).getValue());
    }

    public Tuple1<BigInteger> getGrantCommitteeMemberOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_GRANTCOMMITTEEMEMBER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public TransactionReceipt unfreezeAccount(String account) {
        Function function = new Function(FUNC_UNFREEZEACCOUNT, Arrays.asList(new Address(account)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public void unfreezeAccount(String account, TransactionCallback callback) {
        Function function = new Function(FUNC_UNFREEZEACCOUNT, Arrays.asList(new Address(account)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForUnfreezeAccount(String account) {
        Function function = new Function(FUNC_UNFREEZEACCOUNT, Arrays.asList(new Address(account)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple1<String> getUnfreezeAccountInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_UNFREEZEACCOUNT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<String>((String)results.get(0).getValue());
    }

    public Tuple1<BigInteger> getUnfreezeAccountOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_UNFREEZEACCOUNT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public String queryVotesOfThreshold() throws ContractException {
        Function function = new Function(FUNC_QUERYVOTESOFTHRESHOLD, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeCallWithSingleValueReturn(function, String.class);
    }

    public String listCommitteeMembers() throws ContractException {
        Function function = new Function(FUNC_LISTCOMMITTEEMEMBERS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeCallWithSingleValueReturn(function, String.class);
    }

    public TransactionReceipt updateThreshold(BigInteger threshold) {
        Function function = new Function(FUNC_UPDATETHRESHOLD, Arrays.asList(new Int256(threshold)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public void updateThreshold(BigInteger threshold, TransactionCallback callback) {
        Function function = new Function(FUNC_UPDATETHRESHOLD, Arrays.asList(new Int256(threshold)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForUpdateThreshold(BigInteger threshold) {
        Function function = new Function(FUNC_UPDATETHRESHOLD, Arrays.asList(new Int256(threshold)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple1<BigInteger> getUpdateThresholdInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_UPDATETHRESHOLD, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public Tuple1<BigInteger> getUpdateThresholdOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_UPDATETHRESHOLD, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public TransactionReceipt revokeCommitteeMember(String user) {
        Function function = new Function(FUNC_REVOKECOMMITTEEMEMBER, Arrays.asList(new Address(user)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public void revokeCommitteeMember(String user, TransactionCallback callback) {
        Function function = new Function(FUNC_REVOKECOMMITTEEMEMBER, Arrays.asList(new Address(user)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForRevokeCommitteeMember(String user) {
        Function function = new Function(FUNC_REVOKECOMMITTEEMEMBER, Arrays.asList(new Address(user)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple1<String> getRevokeCommitteeMemberInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_REVOKECOMMITTEEMEMBER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<String>((String)results.get(0).getValue());
    }

    public Tuple1<BigInteger> getRevokeCommitteeMemberOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_REVOKECOMMITTEEMEMBER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public TransactionReceipt grantOperator(String user) {
        Function function = new Function(FUNC_GRANTOPERATOR, Arrays.asList(new Address(user)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public void grantOperator(String user, TransactionCallback callback) {
        Function function = new Function(FUNC_GRANTOPERATOR, Arrays.asList(new Address(user)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForGrantOperator(String user) {
        Function function = new Function(FUNC_GRANTOPERATOR, Arrays.asList(new Address(user)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple1<String> getGrantOperatorInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_GRANTOPERATOR, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<String>((String)results.get(0).getValue());
    }

    public Tuple1<BigInteger> getGrantOperatorOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_GRANTOPERATOR, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public TransactionReceipt freezeAccount(String account) {
        Function function = new Function(FUNC_FREEZEACCOUNT, Arrays.asList(new Address(account)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public void freezeAccount(String account, TransactionCallback callback) {
        Function function = new Function(FUNC_FREEZEACCOUNT, Arrays.asList(new Address(account)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForFreezeAccount(String account) {
        Function function = new Function(FUNC_FREEZEACCOUNT, Arrays.asList(new Address(account)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple1<String> getFreezeAccountInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_FREEZEACCOUNT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<String>((String)results.get(0).getValue());
    }

    public Tuple1<BigInteger> getFreezeAccountOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_FREEZEACCOUNT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public TransactionReceipt revokeOperator(String user) {
        Function function = new Function(FUNC_REVOKEOPERATOR, Arrays.asList(new Address(user)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public void revokeOperator(String user, TransactionCallback callback) {
        Function function = new Function(FUNC_REVOKEOPERATOR, Arrays.asList(new Address(user)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForRevokeOperator(String user) {
        Function function = new Function(FUNC_REVOKEOPERATOR, Arrays.asList(new Address(user)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple1<String> getRevokeOperatorInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_REVOKEOPERATOR, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<String>((String)results.get(0).getValue());
    }

    public Tuple1<BigInteger> getRevokeOperatorOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_REVOKEOPERATOR, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public String getAccountStatus(String account) throws ContractException {
        Function function = new Function(FUNC_GETACCOUNTSTATUS, Arrays.asList(new Address(account)), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeCallWithSingleValueReturn(function, String.class);
    }

    public static ChainGovernancePrecompiled load(String contractAddress, Client client, CryptoKeyPair credential) {
        return new ChainGovernancePrecompiled(contractAddress, client, credential);
    }

    public static ChainGovernancePrecompiled deploy(Client client, CryptoKeyPair credential) throws ContractException {
        return ChainGovernancePrecompiled.deploy(ChainGovernancePrecompiled.class, client, credential, ChainGovernancePrecompiled.getBinary(client.getCryptoSuite()), "");
    }
}

