/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.contract.precompiled.consensus;

import java.util.List;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.contract.precompiled.consensus.ConsensusPrecompiled;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.model.RetCode;
import org.fisco.bcos.sdk.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;

public class ConsensusService {
    private final ConsensusPrecompiled consensusPrecompiled;
    private final Client client;

    public ConsensusService(Client client, CryptoKeyPair credential) {
        this.client = client;
        this.consensusPrecompiled = ConsensusPrecompiled.load("0x0000000000000000000000000000000000001003", client, credential);
    }

    private boolean existsInNodeList(String nodeId) {
        List<String> nodeIdList = this.client.getNodeIDList().getNodeIDList();
        return nodeIdList.contains(nodeId);
    }

    public RetCode addSealer(String nodeId) throws ContractException {
        if (!this.existsInNodeList(nodeId)) {
            throw new ContractException("The operated node must be in the list returned by getNodeIDList");
        }
        List sealerList = (List)this.client.getSealerList().getResult();
        if (sealerList.contains(nodeId)) {
            throw new ContractException("The node already exists in the sealerList");
        }
        return ReceiptParser.parseTransactionReceipt(this.consensusPrecompiled.addSealer(nodeId));
    }

    public RetCode addObserver(String nodeId) throws ContractException {
        List observerList = (List)this.client.getObserverList().getResult();
        if (observerList.contains(nodeId)) {
            throw new ContractException("The node already exists in the observerList");
        }
        return ReceiptParser.parseTransactionReceipt(this.consensusPrecompiled.addObserver(nodeId));
    }

    public RetCode removeNode(String nodeId) throws ContractException {
        List sealerList = (List)this.client.getSealerList().getResult();
        List observerList = (List)this.client.getObserverList().getResult();
        if (!sealerList.contains(nodeId) && !observerList.contains(nodeId)) {
            throw new ContractException("The node already has been removed from the group");
        }
        return ReceiptParser.parseTransactionReceipt(this.consensusPrecompiled.remove(nodeId));
    }
}

