/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.contract.precompiled.consensus;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.fisco.bcos.sdk.abi.FunctionReturnDecoder;
import org.fisco.bcos.sdk.abi.TypeReference;
import org.fisco.bcos.sdk.abi.datatypes.Function;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;
import org.fisco.bcos.sdk.abi.datatypes.generated.Int256;
import org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated.Tuple1;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.contract.Contract;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;

public class ConsensusPrecompiled
extends Contract {
    public static final String[] BINARY_ARRAY = new String[0];
    public static final String BINARY = String.join((CharSequence)"", BINARY_ARRAY);
    public static final String[] SM_BINARY_ARRAY = new String[0];
    public static final String SM_BINARY = String.join((CharSequence)"", SM_BINARY_ARRAY);
    public static final String[] ABI_ARRAY = new String[]{"[{\"constant\":false,\"inputs\":[{\"name\":\"\",\"type\":\"string\"}],\"name\":\"addObserver\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"\",\"type\":\"string\"}],\"name\":\"remove\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":false,\"inputs\":[{\"name\":\"\",\"type\":\"string\"}],\"name\":\"addSealer\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"}]"};
    public static final String ABI = String.join((CharSequence)"", ABI_ARRAY);
    public static final String FUNC_ADDOBSERVER = "addObserver";
    public static final String FUNC_REMOVE = "remove";
    public static final String FUNC_ADDSEALER = "addSealer";

    protected ConsensusPrecompiled(String contractAddress, Client client, CryptoKeyPair credential) {
        super(ConsensusPrecompiled.getBinary(client.getCryptoSuite()), contractAddress, client, credential);
    }

    public static String getBinary(CryptoSuite cryptoSuite) {
        return cryptoSuite.getCryptoTypeConfig() == 0 ? BINARY : SM_BINARY;
    }

    public TransactionReceipt addObserver(String param0) {
        Function function = new Function(FUNC_ADDOBSERVER, Arrays.asList(new Utf8String(param0)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public void addObserver(String param0, TransactionCallback callback) {
        Function function = new Function(FUNC_ADDOBSERVER, Arrays.asList(new Utf8String(param0)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForAddObserver(String param0) {
        Function function = new Function(FUNC_ADDOBSERVER, Arrays.asList(new Utf8String(param0)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple1<String> getAddObserverInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_ADDOBSERVER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<String>((String)results.get(0).getValue());
    }

    public Tuple1<BigInteger> getAddObserverOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_ADDOBSERVER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public TransactionReceipt remove(String param0) {
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Utf8String(param0)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public void remove(String param0, TransactionCallback callback) {
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Utf8String(param0)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForRemove(String param0) {
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Utf8String(param0)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple1<String> getRemoveInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<String>((String)results.get(0).getValue());
    }

    public Tuple1<BigInteger> getRemoveOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public TransactionReceipt addSealer(String param0) {
        Function function = new Function(FUNC_ADDSEALER, Arrays.asList(new Utf8String(param0)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public void addSealer(String param0, TransactionCallback callback) {
        Function function = new Function(FUNC_ADDSEALER, Arrays.asList(new Utf8String(param0)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForAddSealer(String param0) {
        Function function = new Function(FUNC_ADDSEALER, Arrays.asList(new Utf8String(param0)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple1<String> getAddSealerInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_ADDSEALER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<String>((String)results.get(0).getValue());
    }

    public Tuple1<BigInteger> getAddSealerOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_ADDSEALER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public static ConsensusPrecompiled load(String contractAddress, Client client, CryptoKeyPair credential) {
        return new ConsensusPrecompiled(contractAddress, client, credential);
    }

    public static ConsensusPrecompiled deploy(Client client, CryptoKeyPair credential) throws ContractException {
        return ConsensusPrecompiled.deploy(ConsensusPrecompiled.class, client, credential, ConsensusPrecompiled.getBinary(client.getCryptoSuite()), "");
    }
}

