/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.client.handler;

import io.netty.channel.ChannelHandlerContext;
import java.util.function.Consumer;
import org.fisco.bcos.sdk.channel.ChannelVersionNegotiation;
import org.fisco.bcos.sdk.model.Message;
import org.fisco.bcos.sdk.model.MsgType;
import org.fisco.bcos.sdk.network.MsgHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionNotifyHandler
implements MsgHandler {
    private static Logger logger = LoggerFactory.getLogger(TransactionNotifyHandler.class);
    private final Consumer<Message> transactionNotifyReceiver;

    public TransactionNotifyHandler(Consumer<Message> transactionNotifyReceiver) {
        this.transactionNotifyReceiver = transactionNotifyReceiver;
    }

    @Override
    public void onConnect(ChannelHandlerContext ctx) {
        logger.debug("onConnect, endpoint: {}", (Object)ChannelVersionNegotiation.getPeerHost(ctx));
    }

    @Override
    public void onMessage(ChannelHandlerContext ctx, Message msg) {
        if (msg.getType().shortValue() != MsgType.TRANSACTION_NOTIFY.getType()) {
            return;
        }
        this.transactionNotifyReceiver.accept(msg);
    }

    @Override
    public void onDisconnect(ChannelHandlerContext ctx) {
        logger.debug("onDisconnect, endpoint: {}", (Object)ChannelVersionNegotiation.getPeerHost(ctx));
    }
}

