/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.channel.model;

import org.fisco.bcos.sdk.channel.model.ChannelPrococolExceiption;

public enum EnumNodeVersion {
    BCOS_2_0_0_RC1("2.0.0-rc1"),
    BCOS_2_0_0("2.0.0"),
    BCOS_2_1_0("2.1.0");

    private String version;

    private EnumNodeVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static Version getClassVersion(String version) throws ChannelPrococolExceiption {
        try {
            String[] s1;
            if (version.endsWith("gm")) {
                version = version.substring(0, version.indexOf("gm"));
            }
            String[] s0 = version.trim().split("-");
            Version v = BCOS_2_0_0.new Version();
            if (s0.length > 1) {
                v.setExt(s0[1]);
            }
            if ((s1 = s0[0].split("\\.")).length < 3) {
                throw new ChannelPrococolExceiption(" invalid node version format, version: " + version);
            }
            v.setMajor(Integer.parseInt(s1[0].trim()));
            v.setMinor(Integer.parseInt(s1[1].trim()));
            v.setPatch(Integer.parseInt(s1[2].trim()));
            return v;
        }
        catch (Exception e) {
            throw new ChannelPrococolExceiption(" invalid node version format, version: " + version);
        }
    }

    public static boolean channelProtocolHandleShakeSupport(String version) throws ChannelPrococolExceiption {
        Version v = EnumNodeVersion.getClassVersion(version);
        return v.getMajor() == 2 && v.getMinor() >= 1;
    }

    public class Version {
        private int major;
        private int minor;
        private int patch;
        private String ext;

        public String toString() {
            return "Version [major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + ", ext=" + this.ext + "]";
        }

        public String toVersionString() {
            return this.getMajor() + "." + this.getMinor();
        }

        public int getMajor() {
            return this.major;
        }

        public void setMajor(int major) {
            this.major = major;
        }

        public int getMinor() {
            return this.minor;
        }

        public void setMinor(int minor) {
            this.minor = minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public void setPatch(int patch) {
            this.patch = patch;
        }

        public String getExt() {
            return this.ext;
        }

        public void setExt(String ext) {
            this.ext = ext;
        }
    }
}

