/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.amop.topic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.fisco.bcos.sdk.amop.AmopCallback;
import org.fisco.bcos.sdk.amop.AmopMsgOut;
import org.fisco.bcos.sdk.amop.topic.TopicType;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.crypto.keystore.KeyTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicManager {
    private static Logger logger = LoggerFactory.getLogger(TopicManager.class);
    private CryptoSuite cryptoSuite = new CryptoSuite(0);
    private Map<String, CryptoKeyPair> topic2PrivateKey = new ConcurrentHashMap<String, CryptoKeyPair>();
    private Map<String, List<String>> topic2PublicKeys = new ConcurrentHashMap<String, List<String>>();
    private Map<String, String> topicName2FullName = new ConcurrentHashMap<String, String>();
    private Map<String, AmopCallback> topic2Callback = new ConcurrentHashMap<String, AmopCallback>();
    private Set<String> topics = Collections.synchronizedSet(new HashSet());
    private Map<String, Set<String>> peer2BlockNotify = new ConcurrentHashMap<String, Set<String>>();
    private AmopCallback callback;
    public static final String verifyChannelPrefix = "#!$VerifyChannel_";
    public static final String pushChannelPrefix = "#!$PushChannel_";
    public static final String topicNeedVerifyPrefix = "#!$TopicNeedVerify_";

    public void addTopic(String topicString, AmopCallback callback) {
        this.topics.add(topicString);
        this.topicName2FullName.put(topicString, topicString);
        if (callback != null) {
            this.topic2Callback.put(topicString, callback);
        }
    }

    public void addPrivateTopicSubscribe(String topicName, KeyTool keyTool, AmopCallback callback) {
        CryptoKeyPair cryptoKeyPair = this.cryptoSuite.getKeyPairFactory().createKeyPair(keyTool.getKeyPair());
        this.addPrivateTopicSubscribe(topicName, cryptoKeyPair, callback);
    }

    public void addPrivateTopicSubscribe(String topicName, CryptoKeyPair cryptoKeyPair, AmopCallback callback) {
        String fullNameToSendToNode = this.makeVerifyChannelPrefixTopic(topicName);
        logger.trace("add private topic subscribe, topic:{} full name:{}", (Object)topicName, (Object)fullNameToSendToNode);
        this.topics.add(fullNameToSendToNode);
        this.topics.add(this.addNeedVerifyTopicPrefix(topicName));
        this.topic2PrivateKey.put(this.addNeedVerifyTopicPrefix(topicName), cryptoKeyPair);
        this.topicName2FullName.put(topicName, fullNameToSendToNode);
        if (callback != null) {
            this.topic2Callback.put(this.addNeedVerifyTopicPrefix(topicName), callback);
        }
    }

    public void addPrivateTopicSend(String topicName, List<KeyTool> publicKeyToolList) {
        ArrayList<String> publicKeyList = new ArrayList<String>();
        for (KeyTool publicKey : publicKeyToolList) {
            publicKeyList.add(publicKey.getHexedPublicKey());
        }
        this.addPrivateTopicSendWithHexPublicKey(topicName, publicKeyList);
    }

    public void addPrivateTopicSendWithHexPublicKey(String topicName, List<String> publicKeyList) {
        String fullNameToSendToNode = this.makePushChannelPrefixTopic(topicName);
        logger.trace("add private topic to send, topic:{} full name:{}", (Object)topicName, (Object)fullNameToSendToNode);
        this.topics.add(fullNameToSendToNode);
        this.topic2PublicKeys.put(this.addNeedVerifyTopicPrefix(topicName), publicKeyList);
        this.topicName2FullName.put(topicName, fullNameToSendToNode);
    }

    public void addPrivateTopicCallback(String topicName, AmopCallback callback) {
        logger.trace("add private topic callback, topic:{}", (Object)topicName);
        this.topic2Callback.put(this.addNeedVerifyTopicPrefix(topicName), callback);
    }

    public void removeTopic(String topicName) {
        logger.trace("remove topic, topic:{}", (Object)topicName);
        String fullName = this.topicName2FullName.get(topicName);
        if (null != fullName) {
            this.topics.remove(fullName);
            this.topics.remove(this.addNeedVerifyTopicPrefix(topicName));
            this.topicName2FullName.remove(topicName);
            this.topic2PublicKeys.remove(this.addNeedVerifyTopicPrefix(topicName));
            this.topic2PrivateKey.remove(this.addNeedVerifyTopicPrefix(topicName));
            if (fullName.length() > topicName.length()) {
                this.topic2Callback.remove(this.addNeedVerifyTopicPrefix(topicName));
            } else {
                this.topic2Callback.remove(topicName);
            }
            logger.trace("success remove topic, topic:{}", (Object)topicName);
        }
    }

    public Set<String> getSubByPeer(String peerIpPort) {
        Set<String> notify = this.peer2BlockNotify.get(peerIpPort);
        HashSet<String> peerSub = new HashSet<String>();
        if (this.topics != null) {
            peerSub.addAll(this.topics);
        }
        if (notify != null) {
            peerSub.addAll(notify);
        }
        logger.trace("get sub by peer, peer:{}, sub:{}", (Object)peerIpPort, (Object)peerSub.size());
        return peerSub;
    }

    public Set<String> getBlockNotifyByPeer(String peerIpPort) {
        Set<String> notify = this.peer2BlockNotify.get(peerIpPort);
        HashSet<String> peerSub = new HashSet<String>();
        if (notify != null) {
            peerSub.addAll(notify);
        }
        logger.trace("get sub by peer, peer:{}, sub:{}", (Object)peerIpPort, (Object)peerSub.size());
        return peerSub;
    }

    public Set<String> getTopicNames() {
        return this.topicName2FullName.keySet();
    }

    public void updateBlockNotify(String peerIpPort, List<String> groupInfo) {
        if (groupInfo == null) {
            return;
        }
        logger.debug("update block notify, peer: {}, groupInfo: {}", (Object)peerIpPort, (Object)groupInfo.toString());
        HashSet<String> pnf = new HashSet<String>();
        for (String group : groupInfo) {
            pnf.add("_block_notify_" + group);
            logger.debug("add block notify, peer: {}, topic: {}", (Object)peerIpPort, (Object)("_block_notify_" + group));
        }
        this.peer2BlockNotify.put(peerIpPort, pnf);
    }

    public AmopCallback getCallback(String topicName) {
        if (this.topic2Callback.get(topicName) != null) {
            return this.topic2Callback.get(topicName);
        }
        return this.callback;
    }

    public String getFullTopicString(String topicName) {
        return this.topicName2FullName.get(topicName);
    }

    public void setCallback(AmopCallback cb) {
        this.callback = cb;
    }

    public List<String> getPublicKeysByTopic(String topic) {
        return this.topic2PublicKeys.get(topic);
    }

    public CryptoKeyPair getPrivateKeyByTopic(String topic) {
        return this.topic2PrivateKey.get(topic);
    }

    public boolean isSubTopic(String topic) {
        return this.topics.contains(topic);
    }

    public boolean canSendTopicMsg(AmopMsgOut out) {
        if (out.getType() == TopicType.NORMAL_TOPIC) {
            return true;
        }
        return this.topic2PublicKeys.keySet().contains(out.getTopic());
    }

    public void updatePrivateTopicUUID() {
        for (Map.Entry<String, String> topic : this.topicName2FullName.entrySet()) {
            if (!topic.getValue().contains(verifyChannelPrefix)) continue;
            this.topics.remove(topic.getValue());
            String newFullname = this.makeVerifyChannelPrefixTopic(topic.getKey());
            this.topics.add(newFullname);
            this.topicName2FullName.put(topic.getKey(), newFullname);
            logger.trace("update uuid, old:{} new:{}", (Object)topic.getValue(), (Object)newFullname);
        }
    }

    public Set<String> getAllTopics() {
        return this.topics;
    }

    private String addNeedVerifyTopicPrefix(String topicName) {
        StringBuilder sb = new StringBuilder();
        sb.append(topicNeedVerifyPrefix);
        sb.append(topicName);
        return sb.toString();
    }

    private String makeVerifyChannelPrefixTopic(String topicName) {
        StringBuilder sb = new StringBuilder();
        sb.append(verifyChannelPrefix).append(this.addNeedVerifyTopicPrefix(topicName)).append('_');
        sb.append(UUID.randomUUID().toString().replaceAll("-", ""));
        return sb.toString();
    }

    private String makePushChannelPrefixTopic(String topicName) {
        StringBuilder sb = new StringBuilder();
        sb.append(pushChannelPrefix).append(this.addNeedVerifyTopicPrefix(topicName));
        return sb.toString();
    }
}

