/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.fisco.bcos.sdk.abi.datatypes.Address;
import org.fisco.bcos.sdk.abi.datatypes.Array;
import org.fisco.bcos.sdk.abi.datatypes.Bool;
import org.fisco.bcos.sdk.abi.datatypes.Bytes;
import org.fisco.bcos.sdk.abi.datatypes.BytesType;
import org.fisco.bcos.sdk.abi.datatypes.DynamicArray;
import org.fisco.bcos.sdk.abi.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.abi.datatypes.DynamicStruct;
import org.fisco.bcos.sdk.abi.datatypes.NumericType;
import org.fisco.bcos.sdk.abi.datatypes.StaticArray;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.Ufixed;
import org.fisco.bcos.sdk.abi.datatypes.Uint;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;
import org.fisco.bcos.sdk.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeEncoder {
    private static final Logger logger = LoggerFactory.getLogger(TypeEncoder.class);

    private TypeEncoder() {
    }

    public static String encode(Type parameter) {
        if (parameter instanceof NumericType) {
            return TypeEncoder.encodeNumeric((NumericType)parameter);
        }
        if (parameter instanceof Address) {
            return TypeEncoder.encodeAddress((Address)parameter);
        }
        if (parameter instanceof Bool) {
            return TypeEncoder.encodeBool((Bool)parameter);
        }
        if (parameter instanceof Bytes) {
            return TypeEncoder.encodeBytes((Bytes)parameter);
        }
        if (parameter instanceof DynamicBytes) {
            return TypeEncoder.encodeDynamicBytes((DynamicBytes)parameter);
        }
        if (parameter instanceof Utf8String) {
            return TypeEncoder.encodeString((Utf8String)parameter);
        }
        if (parameter instanceof StaticArray) {
            if (DynamicStruct.class.isAssignableFrom(((StaticArray)parameter).getValue().get(0).getClass())) {
                return TypeEncoder.encodeStaticArrayWithDynamicStruct((StaticArray)parameter);
            }
            return TypeEncoder.encodeArrayValues((StaticArray)parameter);
        }
        if (parameter instanceof DynamicStruct) {
            return TypeEncoder.encodeDynamicStruct((DynamicStruct)parameter);
        }
        if (parameter instanceof DynamicArray) {
            return TypeEncoder.encodeDynamicArray((DynamicArray)parameter);
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + parameter.getClass());
    }

    public static String encodeAddress(Address address) {
        return TypeEncoder.encodeNumeric(address.toUint160());
    }

    public static String encodeNumeric(NumericType numericType) {
        byte[] rawValue = TypeEncoder.toByteArray(numericType);
        byte paddingValue = TypeEncoder.getPaddingValue(numericType);
        byte[] paddedRawValue = new byte[32];
        if (paddingValue != 0) {
            for (int i = 0; i < paddedRawValue.length; ++i) {
                paddedRawValue[i] = paddingValue;
            }
        }
        System.arraycopy(rawValue, 0, paddedRawValue, 32 - rawValue.length, rawValue.length);
        return Numeric.toHexStringNoPrefix(paddedRawValue);
    }

    private static byte getPaddingValue(NumericType numericType) {
        if (numericType.getValue().signum() == -1) {
            return -1;
        }
        return 0;
    }

    private static byte[] toByteArray(NumericType numericType) {
        BigInteger value = numericType.getValue();
        if ((numericType instanceof Ufixed || numericType instanceof Uint) && value.bitLength() == 256) {
            byte[] byteArray = new byte[32];
            System.arraycopy(value.toByteArray(), 1, byteArray, 0, 32);
            return byteArray;
        }
        return value.toByteArray();
    }

    static String encodeBool(Bool value) {
        byte[] rawValue = new byte[32];
        if (value.getValue().booleanValue()) {
            rawValue[rawValue.length - 1] = 1;
        }
        return Numeric.toHexStringNoPrefix(rawValue);
    }

    static String encodeBytes(BytesType bytesType) {
        byte[] dest;
        byte[] value = bytesType.getValue();
        int length = value.length;
        int mod = length % 32;
        if (mod != 0) {
            int padding = 32 - mod;
            dest = new byte[length + padding];
            System.arraycopy(value, 0, dest, 0, length);
        } else {
            dest = value;
        }
        return Numeric.toHexStringNoPrefix(dest);
    }

    static String encodeDynamicBytes(DynamicBytes dynamicBytes) {
        int size = dynamicBytes.getValue().length;
        String encodedLength = TypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        String encodedValue = TypeEncoder.encodeBytes(dynamicBytes);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(encodedValue);
        return result.toString();
    }

    static String encodeString(Utf8String string) {
        byte[] utfEncoded = string.getValue().getBytes(StandardCharsets.UTF_8);
        return TypeEncoder.encodeDynamicBytes(new DynamicBytes(utfEncoded));
    }

    static <T extends Type> String encodeArrayValues(Array<T> value) {
        StringBuilder encodedOffset = new StringBuilder();
        StringBuilder encodedValue = new StringBuilder();
        int offset = value.getValue().size() * 32;
        Iterator iterator = value.getValue().iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            String r = TypeEncoder.encode(type);
            encodedValue.append(r);
            if (!type.dynamicType()) continue;
            encodedOffset.append(TypeEncoder.encode(new Uint(BigInteger.valueOf(offset))));
            offset += r.length() >> 1;
        }
        StringBuilder result = new StringBuilder();
        result.append((CharSequence)encodedOffset);
        result.append((CharSequence)encodedValue);
        return result.toString();
    }

    static <T extends Type> String encodeDynamicArray(DynamicArray<T> value) {
        StringBuilder encodedSize = new StringBuilder();
        StringBuilder encodedOffset = new StringBuilder();
        StringBuilder encodedValue = new StringBuilder();
        encodedSize.append(TypeEncoder.encode(new Uint(BigInteger.valueOf(value.getValue().size()))));
        int offset = value.getValue().size() * 32;
        Iterator iterator = value.getValue().iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            String r = TypeEncoder.encode(type);
            encodedValue.append(r);
            if (!type.dynamicType()) continue;
            encodedOffset.append(TypeEncoder.encode(new Uint(BigInteger.valueOf(offset))));
            offset += r.length() >> 1;
        }
        StringBuilder result = new StringBuilder();
        result.append((CharSequence)encodedSize);
        result.append((CharSequence)encodedOffset);
        result.append((CharSequence)encodedValue);
        return result.toString();
    }

    public static String encodeDynamicStruct(DynamicStruct value) {
        String encodedValues = TypeEncoder.encodeDynamicStructValues(value);
        return encodedValues;
    }

    private static String encodeDynamicStructValues(DynamicStruct value) {
        int staticSize = 0;
        for (int i = 0; i < value.getValue().size(); ++i) {
            Type type = (Type)value.getValue().get(i);
            if (type.dynamicType()) {
                staticSize += 32;
                continue;
            }
            staticSize += type.offset() * 32;
        }
        int dynamicOffset = staticSize;
        ArrayList<String> offsetsAndStaticValues = new ArrayList<String>();
        ArrayList<String> dynamicValues = new ArrayList<String>();
        for (int i = 0; i < value.getValue().size(); ++i) {
            Type type = (Type)value.getValue().get(i);
            if (type.dynamicType()) {
                offsetsAndStaticValues.add(TypeEncoder.toBytesPadded(new BigInteger(Long.toString(dynamicOffset)), 32));
                String encodedValue = TypeEncoder.encode(type);
                dynamicValues.add(encodedValue);
                dynamicOffset += encodedValue.length() >> 1;
                continue;
            }
            offsetsAndStaticValues.add(TypeEncoder.encode(type));
        }
        StringBuilder result = new StringBuilder();
        for (String offsetsAndStaticValue : offsetsAndStaticValues) {
            result.append(offsetsAndStaticValue);
        }
        for (String dynamicValue : dynamicValues) {
            result.append(dynamicValue);
        }
        return result.toString();
    }

    static String toBytesPadded(BigInteger value, int length) {
        int srcOffset;
        int bytesLength;
        byte[] result = new byte[length];
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            bytesLength = bytes.length - 1;
            srcOffset = 1;
        } else {
            bytesLength = bytes.length;
            srcOffset = 0;
        }
        if (bytesLength > length) {
            throw new RuntimeException("Input is too large to put in byte array of size " + length);
        }
        int destOffset = length - bytesLength;
        System.arraycopy(bytes, srcOffset, result, destOffset, bytesLength);
        return Numeric.toHexStringNoPrefix(result);
    }

    static <T extends Type> String encodeStaticArrayWithDynamicStruct(Array<T> value) {
        String valuesOffsets = TypeEncoder.encodeStructsArraysOffsets(value);
        String encodedValues = TypeEncoder.encodeArrayValues(value);
        StringBuilder result = new StringBuilder();
        result.append(valuesOffsets);
        result.append(encodedValues);
        return result.toString();
    }

    static <T extends Type> String encodeStructsArraysOffsets(Array<T> value) {
        StringBuilder result = new StringBuilder();
        long offset = value.getValue().size();
        List tailsEncoding = value.getValue().stream().map(TypeEncoder::encode).collect(Collectors.toList());
        for (int i = 0; i < value.getValue().size(); ++i) {
            offset = i == 0 ? (offset *= 32L) : (offset += (long)(((String)tailsEncoding.get(i - 1)).length() >> 1));
            result.append(TypeEncoder.toBytesPadded(new BigInteger(Long.toString(offset)), 32));
        }
        return result.toString();
    }
}

