/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ClumpletReader;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.DbAttachInfo;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractConnection;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.wire.AbstractWireOperations;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.FbWireOperations;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.ProtocolCollection;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.XdrStreamAccess;
import org.firebirdsql.gds.ng.wire.auth.ClientAuthBlock;
import org.firebirdsql.gds.ng.wire.crypt.KnownServerKey;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jaybird.util.ByteArrayHelper;

public abstract class WireConnection<T extends IAttachProperties<T>, C extends FbWireAttachment>
extends AbstractConnection<T, C>
implements Closeable {
    private static final System.Logger log = System.getLogger(WireConnection.class.getName());
    private static final String REJECTION_POSSIBLE_REASON = "The server and client could not agree on connection options. A possible reason is attempting to connect to an unsupported Firebird version; see the documentation of connection property 'enableProtocol' for a workaround.";
    private static final WarningMessageCallback NOOP_WARNING_MESSAGE_CALLBACK = warning -> {};
    private final List<KnownServerKey> knownServerKeys = new ArrayList<KnownServerKey>(3);
    private final DbAttachInfo dbAttachInfo;
    private ClientAuthBlock clientAuthBlock;
    private Socket socket;
    private ProtocolCollection protocols;
    private int protocolVersion;
    private int protocolArchitecture;
    private int protocolMinimumType;
    private XdrOutputStream xdrOut;
    private XdrInputStream xdrIn;
    private final XdrStreamAccess streamAccess = new XdrStreamAccess(){

        @Override
        public XdrInputStream getXdrIn() throws SQLException {
            if (WireConnection.this.isConnected() && WireConnection.this.xdrIn != null) {
                return WireConnection.this.xdrIn;
            }
            throw FbExceptionBuilder.connectionClosed();
        }

        @Override
        public XdrOutputStream getXdrOut() throws SQLException {
            if (WireConnection.this.isConnected() && WireConnection.this.xdrOut != null) {
                return WireConnection.this.xdrOut;
            }
            throw FbExceptionBuilder.connectionClosed();
        }
    };

    protected WireConnection(T attachProperties) throws SQLException {
        this(attachProperties, EncodingFactory.getPlatformDefault(), ProtocolCollection.getProtocols(attachProperties.getEnableProtocol()));
    }

    protected WireConnection(T attachProperties, IEncodingFactory encodingFactory, ProtocolCollection protocols) throws SQLException {
        super(attachProperties, encodingFactory);
        this.protocols = protocols;
        this.clientAuthBlock = new ClientAuthBlock(this.attachProperties);
        this.dbAttachInfo = this.toDbAttachInfo(attachProperties);
    }

    final LockCloseable withLockProxy() {
        return this.withLock();
    }

    public final String getServerName() {
        return this.dbAttachInfo.serverName();
    }

    public final int getPortNumber() {
        return this.dbAttachInfo.portNumber();
    }

    protected String getCnctFile() {
        return this.getAttachObjectName();
    }

    public final String getAttachObjectName() {
        return this.dbAttachInfo.attachObjectName();
    }

    protected abstract DbAttachInfo toDbAttachInfo(T var1) throws SQLException;

    public final boolean isConnected() {
        return this.socket != null && !this.socket.isClosed();
    }

    public final int getProtocolVersion() {
        return this.protocolVersion;
    }

    public final int getProtocolArchitecture() {
        return this.protocolArchitecture;
    }

    public final int getProtocolMinimumType() {
        return this.protocolMinimumType;
    }

    public final ClientAuthBlock getClientAuthBlock() {
        return this.clientAuthBlock;
    }

    public final void setSoTimeout(int socketTimeout) throws SQLException {
        this.attachProperties.setSoTimeout(socketTimeout);
        this.resetSocketTimeout();
    }

    public final void resetSocketTimeout() throws SQLException {
        if (this.isConnected()) {
            try {
                int desiredTimeout;
                int soTimeout = this.attachProperties.getSoTimeout();
                int n = desiredTimeout = soTimeout != -1 ? soTimeout : 0;
                if (this.socket.getSoTimeout() != desiredTimeout) {
                    this.socket.setSoTimeout(desiredTimeout);
                }
            }
            catch (SocketException e) {
                throw FbExceptionBuilder.forException(337248308).cause(e).toSQLException();
            }
        }
    }

    public final void socketConnect() throws SQLException {
        try {
            this.socket = this.createSocket();
            this.socket.setTcpNoDelay(true);
            int connectTimeout = this.attachProperties.getConnectTimeout();
            int socketConnectTimeout = Math.max(0, (int)TimeUnit.SECONDS.toMillis(connectTimeout));
            if (socketConnectTimeout != 0) {
                this.socket.setSoTimeout(socketConnectTimeout);
            } else {
                this.socket.setSoTimeout(Math.max(this.attachProperties.getSoTimeout(), 0));
            }
            int socketBufferSize = this.attachProperties.getSocketBufferSize();
            if (socketBufferSize != -1) {
                this.socket.setReceiveBufferSize(socketBufferSize);
                this.socket.setSendBufferSize(socketBufferSize);
            }
            this.socket.connect(new InetSocketAddress(this.getServerName(), this.getPortNumber()), socketConnectTimeout);
        }
        catch (SocketTimeoutException ste) {
            throw FbExceptionBuilder.forTimeoutException(335544721).messageParameter((Object)this.getServerName()).cause(ste).toSQLException();
        }
        catch (IOException ioex) {
            throw FbExceptionBuilder.forNonTransientConnectionException(335544721).messageParameter((Object)this.getServerName()).cause(ioex).toSQLException();
        }
    }

    private Socket createSocket() throws IOException, SQLException {
        try {
            return this.createSocketFactory().createSocket();
        }
        catch (RuntimeException e) {
            throw FbExceptionBuilder.forNonTransientConnectionException(337248349).messageParameter((Object)this.attachProperties.getSocketFactory()).cause(e).toSQLException();
        }
    }

    private SocketFactory createSocketFactory() throws SQLException {
        String socketFactoryName = this.attachProperties.getSocketFactory();
        if (socketFactoryName == null) {
            return SocketFactory.getDefault();
        }
        return this.createSocketFactory0(socketFactoryName);
    }

    private SocketFactory createSocketFactory0(String socketFactoryName) throws SQLException {
        log.log(System.Logger.Level.DEBUG, "Attempting to create custom socket factory {0}", socketFactoryName);
        try {
            Class<SocketFactory> socketFactoryClass = Class.forName(socketFactoryName).asSubclass(SocketFactory.class);
            try {
                Constructor<SocketFactory> propsConstructor = socketFactoryClass.getConstructor(Properties.class);
                return propsConstructor.newInstance(this.getSocketFactoryProperties());
            }
            catch (ReflectiveOperationException e) {
                log.log(System.Logger.Level.DEBUG, socketFactoryName + "has no Properties constructor, or constructor execution resulted in an exception", (Throwable)e);
                try {
                    Constructor<SocketFactory> noArgConstructor = socketFactoryClass.getConstructor(new Class[0]);
                    return noArgConstructor.newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e2) {
                    log.log(System.Logger.Level.DEBUG, socketFactoryName + "has no no-arg constructor, or constructor execution resulted in an exception", (Throwable)e2);
                    throw FbExceptionBuilder.forNonTransientConnectionException(337248348).messageParameter((Object)socketFactoryName).toSQLException();
                }
            }
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw FbExceptionBuilder.forNonTransientConnectionException(337248347).messageParameter((Object)socketFactoryName).cause(e).toSQLException();
        }
    }

    private Properties getSocketFactoryProperties() {
        Properties props = new Properties();
        this.attachProperties.connectionPropertyValues().entrySet().stream().filter(e -> e.getValue() != null && ((ConnectionProperty)e.getKey()).name().endsWith("@socketFactory")).forEach(e -> {
            ConnectionProperty connectionProperty = (ConnectionProperty)e.getKey();
            props.setProperty(connectionProperty.name(), connectionProperty.type().asString(e.getValue()));
        });
        return props;
    }

    public final XdrStreamAccess getXdrStreamAccess() {
        return this.streamAccess;
    }

    @Override
    public final C identify() throws SQLException {
        try {
            this.xdrIn = new XdrInputStream(this.socket.getInputStream());
            this.xdrOut = new XdrOutputStream(this.socket.getOutputStream());
            this.sendConnectAttach(this.xdrOut);
            int operation = this.handleCryptKeyCallbackBeforeAttachResponse();
            if (operation == 3 || operation == 98 || operation == 94) {
                return this.handleConnectAttachAccept(this.xdrIn, operation);
            }
            throw this.handleConnectAttachReject(operation);
        }
        catch (SocketTimeoutException ste) {
            throw FbExceptionBuilder.forTimeoutException(335544721).messageParameter((Object)this.getServerName()).cause(ste).toSQLException();
        }
        catch (IOException ioex) {
            throw FbExceptionBuilder.forException(335544721).messageParameter((Object)this.getServerName()).cause(ioex).toSQLException();
        }
    }

    private void sendConnectAttach(XdrOutputStream xdrOut) throws IOException, SQLException {
        xdrOut.writeInt(1);
        xdrOut.writeInt(19);
        xdrOut.writeInt(3);
        xdrOut.writeInt(1);
        xdrOut.writeString(this.getCnctFile(), this.getEncoding());
        xdrOut.writeInt(this.protocols.getProtocolCount());
        xdrOut.writeBuffer(this.createUserIdentificationBlock());
        for (ProtocolDescriptor protocol : this.protocols) {
            this.writeProtocolDescriptor(xdrOut, protocol);
        }
        xdrOut.flush();
    }

    private void writeProtocolDescriptor(XdrOutputStream xdrOut, ProtocolDescriptor protocol) throws IOException {
        xdrOut.writeInt(protocol.getVersion());
        xdrOut.writeInt(protocol.getArchitecture());
        xdrOut.writeInt(protocol.getMinimumType());
        if (protocol.supportsWireCompression() && this.attachProperties.isWireCompression()) {
            xdrOut.writeInt(protocol.getMaximumType() | 0x100);
        } else {
            xdrOut.writeInt(protocol.getMaximumType());
        }
        xdrOut.writeInt(protocol.getWeight());
    }

    private int handleCryptKeyCallbackBeforeAttachResponse() throws IOException, SQLException {
        int operation = this.readNextOperation();
        FbWireOperations cryptKeyCallbackWireOperations = null;
        DbCryptCallback dbCryptCallback = null;
        while (operation == 97) {
            if (cryptKeyCallbackWireOperations == null) {
                cryptKeyCallbackWireOperations = this.getCryptKeyCallbackWireOperations();
            }
            if (dbCryptCallback == null) {
                dbCryptCallback = this.createDbCryptCallback();
            }
            cryptKeyCallbackWireOperations.handleCryptKeyCallback(dbCryptCallback);
            operation = this.readNextOperation();
        }
        return operation;
    }

    private C handleConnectAttachAccept(XdrInputStream xdrIn, int operation) throws IOException, SQLException {
        ProtocolDescriptor descriptor;
        boolean compress;
        FbWireAttachment.AcceptPacket acceptPacket = new FbWireAttachment.AcceptPacket();
        acceptPacket.operation = operation;
        this.protocolVersion = xdrIn.readInt();
        this.protocolArchitecture = xdrIn.readInt();
        int acceptType = xdrIn.readInt();
        this.protocolMinimumType = acceptType & 0xFF;
        boolean bl = compress = (acceptType & 0x100) != 0;
        if (this.protocolVersion < 0) {
            this.protocolVersion = this.protocolVersion & Short.MAX_VALUE | 0x8000;
        }
        if (operation == 98 || operation == 94) {
            acceptPacket.p_acpt_data = xdrIn.readBuffer();
            byte[] data = acceptPacket.p_acpt_data;
            acceptPacket.p_acpt_plugin = xdrIn.readString(this.getEncoding());
            boolean authComplete = xdrIn.readInt() == 1;
            acceptPacket.p_acpt_keys = xdrIn.readBuffer();
            byte[] serverKeys = acceptPacket.p_acpt_keys;
            this.clientAuthBlock.setServerData(data);
            this.clientAuthBlock.setAuthComplete(authComplete);
            this.addServerKeys(serverKeys);
            this.clientAuthBlock.resetClient(serverKeys);
            this.clientAuthBlock.switchPlugin(acceptPacket.p_acpt_plugin);
        } else {
            this.clientAuthBlock.resetClient(null);
        }
        if (compress) {
            this.xdrOut.enableCompression();
            xdrIn.enableDecompression();
        }
        if ((descriptor = this.protocols.getProtocolDescriptor(this.protocolVersion)) == null) {
            throw new SQLException(String.format("Unsupported or unexpected protocol version %d connecting to database %s. Supported version(s): %s", this.protocolVersion, this.getServerName(), this.protocols.getProtocolVersions()));
        }
        C connectionHandle = this.createConnectionHandle(descriptor);
        if (operation == 98) {
            connectionHandle.authReceiveResponse(acceptPacket);
        }
        return connectionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLException handleConnectAttachReject(int operation) throws IOException {
        try {
            Object wireOperations2;
            if (operation == 9) {
                GenericResponse genericResponse;
                wireOperations2 = this.getDefaultWireOperations();
                Response response = ((AbstractWireOperations)wireOperations2).processOperation(operation);
                if (response instanceof GenericResponse && (genericResponse = (GenericResponse)response).exception() != null) {
                    SQLException sQLException = genericResponse.exception();
                    return sQLException;
                }
            } else if (operation == 4) {
                SQLException wireOperations2 = FbExceptionBuilder.forException(335544421).messageParameter((Object)REJECTION_POSSIBLE_REASON).toSQLException();
                return wireOperations2;
            }
            log.log(System.Logger.Level.DEBUG, "Reached end of identify without error or connection, last operation: {0}", operation);
            wireOperations2 = FbExceptionBuilder.toException(335544472);
            return wireOperations2;
        }
        catch (SQLException e) {
            SQLException sQLException = e;
            return sQLException;
        }
        finally {
            try {
                this.close();
            }
            catch (Exception ex) {
                log.log(System.Logger.Level.DEBUG, "Ignoring exception on disconnect in connect phase of protocol", (Throwable)ex);
            }
        }
    }

    public final void clearAuthData() {
        this.clientAuthBlock = null;
        this.clearServerKeys();
    }

    private byte[] createUserIdentificationBlock() throws IOException, SQLException {
        byte[] userBytes = WireConnection.getSystemUserName().getBytes(StandardCharsets.UTF_8);
        byte[] hostBytes = WireConnection.getSystemHostName().getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream userId = new ByteArrayOutputStream();
        this.clientAuthBlock.authenticateStep0();
        this.clientAuthBlock.writePluginDataTo(userId);
        userId.write(11);
        VaxEncoding.encodeVaxInteger(userId, this.attachProperties.getWireCryptAsEnum().getWireProtocolCryptLevel());
        userId.write(1);
        int userLength = Math.min(userBytes.length, 255);
        userId.write(userLength);
        userId.write(userBytes, 0, userLength);
        userId.write(4);
        int hostLength = Math.min(hostBytes.length, 255);
        userId.write(hostLength);
        userId.write(hostBytes, 0, hostLength);
        userId.write(6);
        userId.write(0);
        return userId.toByteArray();
    }

    void addServerKeys(byte[] serverKeys) throws SQLException {
        ClumpletReader newKeys = new ClumpletReader(ClumpletReader.Kind.UnTagged, serverKeys);
        newKeys.rewind();
        while (!newKeys.isEof()) {
            this.addServerKey(newKeys);
            newKeys.moveNext();
        }
    }

    private void addServerKey(ClumpletReader newKeys) throws SQLException {
        int currentTag = newKeys.getClumpTag();
        switch (currentTag) {
            case 2: {
                break;
            }
            case 3: {
                log.log(System.Logger.Level.DEBUG, "Possible implementation problem, found TAG_PLUGIN_SPECIFIC without TAG_KEY_TYPE");
                break;
            }
            case 0: {
                WireConnection.extractServerKey(newKeys).ifPresent(this.knownServerKeys::add);
                break;
            }
            default: {
                log.log(System.Logger.Level.DEBUG, "Ignored unexpected tag type: {0}", currentTag);
            }
        }
    }

    private static Optional<KnownServerKey> extractServerKey(ClumpletReader newKeys) throws SQLException {
        String keyType = newKeys.getString(StandardCharsets.ISO_8859_1);
        newKeys.moveNext();
        if (newKeys.isEof()) {
            return Optional.empty();
        }
        int currentTag = newKeys.getClumpTag();
        if (currentTag != 1) {
            throw new SQLException("Unexpected tag type: " + currentTag);
        }
        String keyPlugins = newKeys.getString(StandardCharsets.ISO_8859_1);
        HashMap<String, byte[]> pluginSpecificData = null;
        while (newKeys.directNext(3)) {
            byte[] data = newKeys.getBytes();
            int sepIdx = ByteArrayHelper.indexOf(data, (byte)0);
            if (sepIdx <= 0) continue;
            String plugin = new String(data, 0, sepIdx, StandardCharsets.ISO_8859_1);
            byte[] specificData = Arrays.copyOfRange(data, sepIdx + 1, data.length);
            if (pluginSpecificData == null) {
                pluginSpecificData = new HashMap<String, byte[]>();
            }
            pluginSpecificData.put(plugin, specificData);
        }
        return Optional.of(new KnownServerKey(keyType, keyPlugins, pluginSpecificData));
    }

    void clearServerKeys() {
        this.knownServerKeys.forEach(KnownServerKey::clear);
        this.knownServerKeys.clear();
    }

    private AbstractWireOperations getDefaultWireOperations() {
        ProtocolDescriptor protocolDescriptor = this.protocols.getProtocolDescriptor(10);
        return (AbstractWireOperations)protocolDescriptor.createWireOperations(this, NOOP_WARNING_MESSAGE_CALLBACK);
    }

    private FbWireOperations getCryptKeyCallbackWireOperations() {
        ProtocolDescriptor protocolDescriptor = this.protocols.getProtocolDescriptor(32783);
        return protocolDescriptor.createWireOperations(this, NOOP_WARNING_MESSAGE_CALLBACK);
    }

    protected abstract C createConnectionHandle(ProtocolDescriptor var1);

    public final int readNextOperation() throws IOException {
        int op;
        while ((op = this.xdrIn.readInt()) == 71) {
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        try (Socket ignored1 = this.socket;
             XdrInputStream ignored2 = this.xdrIn;){
            XdrOutputStream ignored3 = this.xdrOut;
            if (ignored3 != null) {
                ignored3.close();
            }
        }
        finally {
            this.xdrOut = null;
            this.xdrIn = null;
            this.socket = null;
            this.protocols = null;
        }
    }

    private static String getSystemUserName() {
        try {
            return WireConnection.getSystemPropertyPrivileged("user.name");
        }
        catch (SecurityException ex) {
            log.log(System.Logger.Level.DEBUG, "Unable to retrieve user.name property", (Throwable)ex);
            return "jaybird";
        }
    }

    private static String getSystemHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException ex1) {
                return "127.0.0.1";
            }
        }
    }

    private static String getSystemPropertyPrivileged(String propertyName) {
        return AccessController.doPrivileged(() -> System.getProperty(propertyName));
    }

    public final void writeDirect(byte[] data) throws IOException {
        this.xdrOut.writeDirect(data);
    }

    final List<KnownServerKey.PluginSpecificData> getPluginSpecificData() {
        if (this.knownServerKeys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KnownServerKey.PluginSpecificData> pluginSpecificData = new ArrayList<KnownServerKey.PluginSpecificData>();
        for (KnownServerKey knownServerKey : this.knownServerKeys) {
            pluginSpecificData.addAll(knownServerKey.getPluginSpecificData());
        }
        return pluginSpecificData;
    }
}

