/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.DataTruncation;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBStringField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;

public final class FBWorkaroundStringField
extends FBStringField {
    private boolean trimString;
    private static final String[] SYSTEM_TABLES = new String[]{"RDB$CHARACTER_SETS", "RDB$CHECK_CONSTRAINTS", "RDB$COLLATIONS", "RDB$DATABASE", "RDB$DEPENDENCIES", "RDB$EXCEPTIONS", "RDB$FIELDS", "RDB$FIELD_DIMENSIONS", "RDB$FILES", "RDB$FILTERS", "RDB$FORMATS", "RDB$FUNCTIONS", "RDB$FUNCTION_ARGUMENTS", "RDB$GENERATORS", "RDB$INDEX_SEGMENTS", "RDB$INDICES", "RDB$LOG_FILES", "RDB$PAGES", "RDB$PROCEDURES", "RDB$PROCEDURE_PARAMETERS", "RDB$REF_CONSTRAINTS", "RDB$RELATIONS", "RDB$RELATION_CONSTRAINTS", "RDB$RELATION_FIELDS", "RDB$ROLES", "RDB$SECURITY_CLASSES", "RDB$TRANSACTIONS", "RDB$TRIGGERS", "RDB$TRIGGER_MESSAGES", "RDB$TYPES", "RDB$USER_PRIVILEGES", "RDB$VIEW_RELATIONS"};

    FBWorkaroundStringField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    public void setTrimString(boolean trimString) {
        this.trimString = trimString;
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        byte[] data = this.getDatatypeCoder().encodeString(value);
        if (data.length > this.fieldDescriptor.getLength() && !this.isSystemTable(this.fieldDescriptor.getOriginalTableName()) && (value.length() > this.fieldDescriptor.getLength() + 2 || value.charAt(0) != '%' && value.charAt(value.length() - 1) != '%')) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, data.length, this.fieldDescriptor.getLength());
        }
        this.setFieldData(data);
    }

    public void setStringForced(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        byte[] data = this.getDatatypeCoder().encodeString(value);
        this.setFieldData(data);
    }

    @Override
    public String getString() throws SQLException {
        String result = super.getString();
        if (result == null) {
            return null;
        }
        if (JdbcTypeConverter.isJdbcType(this.fieldDescriptor, 12)) {
            return result;
        }
        int maxBytesPerChar = this.getDatatypeCoder().getEncodingDefinition().getMaxBytesPerChar();
        if (this.fieldDescriptor.getLength() % maxBytesPerChar == 0 && result.length() > this.possibleCharLength) {
            result = result.substring(0, this.possibleCharLength);
        }
        if (this.trimString) {
            result = result.trim();
        }
        return result;
    }

    private boolean isSystemTable(String tableName) {
        boolean result = false;
        for (String systemTable : SYSTEM_TABLES) {
            if (!systemTable.equals(tableName)) continue;
            result = true;
            break;
        }
        return result;
    }
}

