/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.jna;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.logging.LoggerFactory;

public final class NativeResourceTracker {
    private static final List<Reference<NativeResource>> registeredNativeResources = Collections.synchronizedList(new ArrayList());
    private static final boolean NATIVE_RESOURCE_SHUTDOWN_DISABLED = JaybirdSystemProperties.isNativeResourceShutdownDisabled();
    private static final AtomicReference<Object> shutdownThread = new AtomicReference();

    private NativeResourceTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends NativeResource> T registerNativeResource(T resource) {
        NativeResourceTracker.registerShutdownThreadIfNecessary();
        List<Reference<NativeResource>> list = registeredNativeResources;
        synchronized (list) {
            NativeResourceTracker.cleanupExpiredReferences();
            registeredNativeResources.add(new WeakReference<T>(resource));
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupExpiredReferences() {
        List<Reference<NativeResource>> list = registeredNativeResources;
        synchronized (list) {
            Iterator<Reference<NativeResource>> iterator = registeredNativeResources.iterator();
            while (iterator.hasNext()) {
                Reference<NativeResource> resourceReference = iterator.next();
                if (resourceReference.get() != null) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownNativeResources() {
        List<Reference<NativeResource>> list = registeredNativeResources;
        synchronized (list) {
            for (Reference<NativeResource> resourceReference : registeredNativeResources) {
                NativeResource resource = resourceReference.get();
                try {
                    if (resource == null) continue;
                    resource.dispose();
                }
                catch (Throwable e) {
                    LoggerFactory.getLogger(NativeResourceTracker.class).error("Error disposing resource " + resource, e);
                }
            }
            registeredNativeResources.clear();
        }
    }

    static void disableShutdownHook() {
        Object currentShutdownThread = shutdownThread.getAndSet(new Object());
        if (currentShutdownThread instanceof Thread) {
            try {
                Runtime.getRuntime().removeShutdownHook((Thread)currentShutdownThread);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException e) {
                LoggerFactory.getLogger(NativeResourceTracker.class).warn("Could not remove NativeLibraryTracker shutdown hook, this may possibly lead to a memory leak until JVM exit", e);
            }
        }
    }

    static boolean isNativeResourceShutdownDisabled() {
        return NATIVE_RESOURCE_SHUTDOWN_DISABLED;
    }

    private static void registerShutdownThreadIfNecessary() {
        if (shutdownThread.get() != null) {
            return;
        }
        NativeResourceTracker.registerShutdownThread();
    }

    private static void registerShutdownThread() {
        if (NativeResourceTracker.isNativeResourceShutdownDisabled()) {
            shutdownThread.compareAndSet(null, new Object());
            return;
        }
        Thread newShutdownThread = new Thread(new NativeLibraryShutdownRunnable());
        if (shutdownThread.compareAndSet(null, newShutdownThread)) {
            try {
                Runtime.getRuntime().addShutdownHook(newShutdownThread);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException e) {
                LoggerFactory.getLogger(NativeResourceTracker.class).warn("Could not register NativeLibraryTracker shutdown hook, this may result in errors or crashes on exit when Firebird Embedded is used and connections have not been properly closed", e);
            }
        }
    }

    static abstract class NativeResource {
        NativeResource() {
        }

        abstract void dispose();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.dispose();
            }
            finally {
                super.finalize();
            }
        }
    }

    private static class NativeLibraryShutdownRunnable
    implements Runnable {
        private NativeLibraryShutdownRunnable() {
        }

        @Override
        public void run() {
            NativeResourceTracker.shutdownNativeResources();
        }
    }
}

