/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.jdbc.FBBlobInputStream;
import org.firebirdsql.jdbc.FBBlobOutputStream;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.jdbc.Synchronizable;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class FBBlob
implements FirebirdBlob,
TransactionListener,
Synchronizable {
    public static final boolean SEGMENTED = true;
    private static final Logger logger = LoggerFactory.getLogger(FBBlob.class);
    private final int bufferLength;
    private boolean isNew;
    private long blob_id;
    private volatile GDSHelper gdsHelper;
    private FBObjectListener.BlobListener blobListener;
    private final Collection<FBBlobInputStream> inputStreams = Collections.synchronizedSet(new HashSet());
    private FBBlobOutputStream blobOut = null;
    private static final byte[] BLOB_LENGTH_REQUEST = new byte[]{6};

    private FBBlob(GDSHelper c, boolean isNew, FBObjectListener.BlobListener blobListener) {
        this.gdsHelper = c;
        this.isNew = isNew;
        this.bufferLength = c.getBlobBufferLength();
        this.blobListener = blobListener != null ? blobListener : FBObjectListener.NoActionBlobListener.instance();
    }

    public FBBlob(GDSHelper c, FBObjectListener.BlobListener blobListener) {
        this(c, true, blobListener);
    }

    public FBBlob(GDSHelper c) {
        this(c, null);
    }

    public FBBlob(GDSHelper c, long blob_id, FBObjectListener.BlobListener blobListener) {
        this(c, false, blobListener);
        this.blob_id = blob_id;
    }

    public FBBlob(GDSHelper c, long blob_id) {
        this(c, blob_id, null);
    }

    @Override
    public final Object getSynchronizationObject() {
        GDSHelper gdsHelper = this.gdsHelper;
        if (gdsHelper == null) {
            return this;
        }
        return gdsHelper.getSynchronizationObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try {
                SQLExceptionChainBuilder<FBSQLException> chain = new SQLExceptionChainBuilder<FBSQLException>();
                for (FBBlobInputStream blobIS : new ArrayList<FBBlobInputStream>(this.inputStreams)) {
                    try {
                        blobIS.close();
                    }
                    catch (IOException ex) {
                        chain.append(new FBSQLException(ex));
                    }
                }
                this.inputStreams.clear();
                if (this.blobOut != null) {
                    try {
                        this.blobOut.close();
                    }
                    catch (IOException ex) {
                        chain.append(new FBSQLException(ex));
                    }
                }
                if (chain.hasException()) {
                    throw chain.getException();
                }
            }
            finally {
                this.gdsHelper = null;
                this.blobListener = FBObjectListener.NoActionBlobListener.instance();
                this.blobOut = null;
            }
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new FBDriverNotCapableException("Method getBinaryStream(long, long) is not supported");
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public byte[] getInfo(byte[] items, int buffer_length) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkClosed();
            this.blobListener.executionStarted(this);
            try {
                byte[] byArray;
                try (FbBlob blob = this.gdsHelper.openBlob(this.blob_id, true);){
                    byArray = blob.getBlobInfo(items, buffer_length);
                }
                return byArray;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.blobListener.executionCompleted(this);
            }
        }
    }

    @Override
    public long length() throws SQLException {
        byte[] info = this.getInfo(BLOB_LENGTH_REQUEST, 20);
        return this.interpretLength(info, 0);
    }

    long interpretLength(byte[] info, int position) throws SQLException {
        if (info[position] != 6) {
            throw new FBSQLException("Length is not available.");
        }
        int dataLength = VaxEncoding.iscVaxInteger(info, position + 1, 2);
        return VaxEncoding.iscVaxLong(info, position + 3, dataLength);
    }

    @Override
    public boolean isSegmented() throws SQLException {
        byte[] info = this.getInfo(new byte[]{7}, 20);
        if (info[0] != 7) {
            throw new FBSQLException("Cannot determine BLOB type");
        }
        int dataLength = VaxEncoding.iscVaxInteger(info, 1, 2);
        int type = VaxEncoding.iscVaxInteger(info, 3, dataLength);
        return type == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FirebirdBlob detach() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkClosed();
            return new FBBlob(this.gdsHelper, this.blob_id, this.blobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new FBSQLException("Blob position should be >= 1");
        }
        if (pos > Integer.MAX_VALUE) {
            throw new FBSQLException("Blob position is limited to 2^31 - 1 due to isc_seek_blob limitations.", "HY009");
        }
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.blobListener.executionStarted(this);
            try {
                byte[] byArray;
                FirebirdBlob.BlobInputStream in = (FirebirdBlob.BlobInputStream)((Object)this.getBinaryStream());
                try {
                    if (pos != 1L) {
                        in.seek((int)pos - 1);
                    }
                    byte[] result = new byte[length];
                    in.readFully(result);
                    byArray = result;
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new FBSQLException(ex);
                    }
                }
                in.close();
                return byArray;
            }
            finally {
                this.blobListener.executionCompleted(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkClosed();
            FBBlobInputStream blobstream = new FBBlobInputStream(this);
            this.inputStreams.add(blobstream);
            return blobstream;
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method position(byte[], long) is not supported");
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method position(Blob, long) is not supported");
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new FBDriverNotCapableException("Method truncate(long) is not supported");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try (OutputStream out = this.setBinaryStream(pos);){
                out.write(bytes, offset, len);
                int n = len;
                return n;
            }
            catch (IOException e) {
                throw new SQLException("IOException writing bytes to blob", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            this.checkClosed();
            this.blobListener.executionStarted(this);
            if (this.blobOut != null) {
                throw new FBSQLException("OutputStream already open. Only one blob output stream can be open at a time.");
            }
            if (pos < 1L) {
                throw new FBSQLException("You can't start before the beginning of the blob", "HY009");
            }
            if (this.isNew && pos > 1L) {
                throw new FBSQLException("Previous value was null, you must start at position 1", "HY009");
            }
            this.blobOut = new FBBlobOutputStream(this);
            if (pos > 1L) {
                throw new FBDriverNotCapableException("Offset start positions are not yet supported.");
            }
            return this.blobOut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBlobId() throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (this.isNew) {
                throw new FBSQLException("No Blob ID is available in new Blob object.");
            }
            return this.blob_id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBlobId(long blob_id) {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            FbTransaction currentTransaction;
            this.blob_id = blob_id;
            if (this.isNew && this.gdsHelper != null && (currentTransaction = this.gdsHelper.getCurrentTransaction()) != null) {
                currentTransaction.addWeakTransactionListener(this);
            }
            this.isNew = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyBytes(byte[] bytes, int pos, int len) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try (OutputStream out = this.setBinaryStream(1L);){
                out.write(bytes, pos, len);
            }
            catch (IOException ex) {
                throw new FBSQLException(ex);
            }
        }
    }

    int getBufferLength() {
        return this.bufferLength;
    }

    void notifyClosed(FBBlobInputStream stream) {
        this.inputStreams.remove(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNew() {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            return this.isNew;
        }
    }

    public GDSHelper getGdsHelper() {
        return this.gdsHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStream(InputStream inputStream, long length) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (length == -1L) {
                this.copyStream(inputStream);
                return;
            }
            try (OutputStream os = this.setBinaryStream(1L);){
                int chunk;
                byte[] buffer = new byte[(int)Math.min((long)this.bufferLength, length)];
                while (length > 0L && (chunk = inputStream.read(buffer, 0, (int)Math.min((long)buffer.length, length))) != -1) {
                    os.write(buffer, 0, chunk);
                    length -= (long)chunk;
                }
            }
            catch (IOException ioe) {
                throw new SQLException(ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStream(InputStream inputStream) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try (OutputStream os = this.setBinaryStream(1L);){
                int chunk;
                byte[] buffer = new byte[this.bufferLength];
                while ((chunk = inputStream.read(buffer)) != -1) {
                    os.write(buffer, 0, chunk);
                }
            }
            catch (IOException ioe) {
                throw new SQLException(ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyCharacterStream(Reader reader, long length, Encoding encoding) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            if (length == -1L) {
                this.copyCharacterStream(reader, encoding);
                return;
            }
            try (OutputStream os = this.setBinaryStream(1L);
                 Writer osw = encoding.createWriter(os);){
                int chunk;
                char[] buffer = new char[(int)Math.min((long)this.bufferLength, length)];
                while (length > 0L && (chunk = reader.read(buffer, 0, (int)Math.min((long)buffer.length, length))) != -1) {
                    osw.write(buffer, 0, chunk);
                    length -= (long)chunk;
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new SQLException("Cannot set character stream because the encoding '" + encoding + "' is unsupported in the JVM. " + "Please report this to the driver developers.");
            }
            catch (IOException ioe) {
                throw new SQLException(ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyCharacterStream(Reader reader, Encoding encoding) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try (OutputStream os = this.setBinaryStream(1L);
                 Writer osw = encoding.createWriter(os);){
                int chunk;
                char[] buffer = new char[this.bufferLength];
                while ((chunk = reader.read(buffer, 0, buffer.length)) != -1) {
                    osw.write(buffer, 0, chunk);
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new SQLException("Cannot set character stream because the encoding '" + encoding + "' is unsupported in the JVM. " + "Please report this to the driver developers.");
            }
            catch (IOException ioe) {
                throw new SQLException(ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionStateChanged(FbTransaction transaction, TransactionState newState, TransactionState previousState) {
        switch (newState) {
            case COMMITTED: 
            case ROLLED_BACK: {
                Object object = this.getSynchronizationObject();
                synchronized (object) {
                    try {
                        this.free();
                    }
                    catch (SQLException e) {
                        logger.error("Error calling free on blob during transaction end", e);
                    }
                    break;
                }
            }
        }
    }

    private void checkClosed() throws SQLException {
        if (this.gdsHelper == null) {
            throw FbExceptionBuilder.forException(337248295).toFlatSQLException();
        }
    }
}

