/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.firebirdsql.encodings.DefaultEncodingDefinition;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.gds.ng.DatatypeCoder;

class ConnectionEncodingFactory
implements IEncodingFactory {
    private final EncodingFactory factory;
    private final EncodingDefinition defaultEncodingDefinition;
    private final Encoding defaultEncoding;
    private final EncodingDefinition noneEncodingDefinition;
    private final EncodingDefinition octetsEncodingDefinition;
    private final ConcurrentMap<Class<? extends DatatypeCoder>, DatatypeCoder> datatypeCoderCache = new ConcurrentHashMap<Class<? extends DatatypeCoder>, DatatypeCoder>(3);

    ConnectionEncodingFactory(EncodingFactory factory, EncodingDefinition defaultEncodingDefinition) {
        assert (factory != null && defaultEncodingDefinition != null);
        this.factory = factory;
        this.defaultEncodingDefinition = defaultEncodingDefinition;
        this.defaultEncoding = defaultEncodingDefinition.getEncoding();
        this.noneEncodingDefinition = "NONE".equalsIgnoreCase(defaultEncodingDefinition.getFirebirdEncodingName()) ? defaultEncodingDefinition : (factory.getEncodingDefinitionByFirebirdName("NONE").isInformationOnly() ? new DefaultEncodingDefinition("NONE", defaultEncodingDefinition.getJavaCharset(), 1, 0, false) : this.getEncodingDefinitionByFirebirdName("NONE"));
        this.octetsEncodingDefinition = factory.getEncodingDefinitionByFirebirdName("OCTETS").isInformationOnly() ? new DefaultEncodingDefinition("OCTETS", defaultEncodingDefinition.getJavaCharset(), 1, 1, false) : this.getEncodingDefinitionByFirebirdName("OCTETS");
    }

    @Override
    public Encoding getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public EncodingDefinition getDefaultEncodingDefinition() {
        return this.defaultEncodingDefinition;
    }

    @Override
    public EncodingDefinition getEncodingDefinitionByFirebirdName(String firebirdEncodingName) {
        if ("NONE".equalsIgnoreCase(firebirdEncodingName)) {
            return this.noneEncodingDefinition;
        }
        if ("OCTETS".equalsIgnoreCase(firebirdEncodingName)) {
            return this.octetsEncodingDefinition;
        }
        return this.factory.getEncodingDefinitionByFirebirdName(firebirdEncodingName);
    }

    @Override
    public Encoding getEncodingForFirebirdName(String firebirdEncodingName) {
        if ("NONE".equalsIgnoreCase(firebirdEncodingName)) {
            return this.noneEncodingDefinition.getEncoding();
        }
        if ("OCTETS".equalsIgnoreCase(firebirdEncodingName)) {
            return this.octetsEncodingDefinition.getEncoding();
        }
        return this.factory.getEncodingForFirebirdName(firebirdEncodingName, this.getDefaultEncoding());
    }

    @Override
    public EncodingDefinition getEncodingDefinitionByCharacterSetId(int firebirdCharacterSetId) {
        switch (firebirdCharacterSetId & 0xFF) {
            case 0: {
                return this.noneEncodingDefinition;
            }
            case 1: {
                return this.octetsEncodingDefinition;
            }
            case 127: {
                return this.defaultEncodingDefinition;
            }
        }
        return this.factory.getEncodingDefinitionByCharacterSetId(firebirdCharacterSetId);
    }

    @Override
    public Encoding getEncodingForCharacterSetId(int firebirdCharacterSetId) {
        switch (firebirdCharacterSetId & 0xFF) {
            case 0: {
                return this.noneEncodingDefinition.getEncoding();
            }
            case 1: {
                return this.octetsEncodingDefinition.getEncoding();
            }
            case 127: {
                return this.defaultEncoding;
            }
        }
        return this.factory.getEncodingForCharacterSetId(firebirdCharacterSetId, this.getDefaultEncoding());
    }

    @Override
    public EncodingDefinition getEncodingDefinitionByCharset(Charset charset) {
        return this.factory.getEncodingDefinitionByCharset(charset);
    }

    @Override
    public Encoding getEncodingForCharset(Charset charset, Encoding fallbackEncoding) {
        return this.factory.getEncodingForCharset(charset, fallbackEncoding);
    }

    @Override
    public Encoding getEncodingForCharset(Charset charset) {
        return this.factory.getEncodingForCharset(charset, this.getDefaultEncoding());
    }

    @Override
    public Encoding getOrCreateEncodingForCharset(Charset charset) {
        return this.factory.getOrCreateEncodingForCharset(charset);
    }

    @Override
    public EncodingDefinition getEncodingDefinitionByCharsetAlias(String charsetAlias) {
        return this.factory.getEncodingDefinitionByCharsetAlias(charsetAlias);
    }

    @Override
    public Encoding getEncodingForCharsetAlias(String charsetAlias) {
        return this.factory.getEncodingForCharsetAlias(charsetAlias, this.getDefaultEncoding());
    }

    @Override
    public EncodingDefinition getEncodingDefinition(String firebirdEncodingName, String javaCharsetAlias) {
        return this.factory.getEncodingDefinition(firebirdEncodingName, javaCharsetAlias);
    }

    @Override
    public IEncodingFactory withDefaultEncodingDefinition(EncodingDefinition encodingDefinition) {
        return this.factory.withDefaultEncodingDefinition(encodingDefinition != null ? encodingDefinition : this.getDefaultEncodingDefinition());
    }

    @Override
    public IEncodingFactory withDefaultEncodingDefinition(Charset charset) {
        return this.withDefaultEncodingDefinition(this.getEncodingDefinitionByCharset(charset));
    }

    @Override
    public <T extends DatatypeCoder> T getOrCreateDatatypeCoder(Class<T> datatypeCoderClass) {
        T newCoder;
        DatatypeCoder coder = (DatatypeCoder)this.datatypeCoderCache.get(datatypeCoderClass);
        if (coder == null && (coder = this.datatypeCoderCache.putIfAbsent((Class<? extends DatatypeCoder>)datatypeCoderClass, (DatatypeCoder)(newCoder = EncodingFactory.createNewDatatypeCoder(datatypeCoderClass, this)))) == null) {
            return newCoder;
        }
        return (T)coder;
    }
}

